/*
 * Decompiled with CFR 0.152.
 */
package forge.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;

public class UnsortedListModel<T>
extends AbstractListModel<T> {
    final List<T> model = Lists.newArrayList();

    @Override
    public int getSize() {
        return this.model.size();
    }

    @Override
    public T getElementAt(int index) {
        return this.model.get(index);
    }

    public void add(T element) {
        this.model.add(element);
        this.fireIntervalAdded(this, this.getSize() - 1, this.getSize() - 1);
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public void addAll(Collection<T> elements) {
        if (elements.isEmpty()) {
            return;
        }
        this.model.addAll(elements);
        this.fireIntervalAdded(this, this.getSize() - elements.size(), this.getSize() - 1);
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public void addAll(ListModel<T> otherModel) {
        ArrayList<T> elements = new ArrayList<T>();
        int size = otherModel.getSize();
        for (int i = 0; size > i; ++i) {
            elements.add(otherModel.getElementAt(i));
        }
        this.addAll(elements);
    }

    public void clear() {
        int prevSize = this.getSize();
        this.model.clear();
        this.fireIntervalRemoved(this, 0, prevSize - 1);
        this.fireContentsChanged(this, 0, prevSize - 1);
    }

    public boolean contains(Object element) {
        return this.model.contains(element);
    }

    public Iterator<T> iterator() {
        return this.model.iterator();
    }

    public void removeElement(int idx) {
        this.model.remove(idx);
        this.fireIntervalRemoved(this, idx, idx);
        this.fireContentsChanged(this, 0, this.getSize());
    }
}

