/*
 * Decompiled with CFR 0.152.
 */
package forge.gui;

import forge.Singletons;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FLabel;
import forge.toolbox.FOverlay;
import forge.toolbox.FPanel;
import forge.toolbox.FSkin;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public final class SOverlayUtils {
    private static boolean _overlayHasFocus;
    private static Component prevFocusOwner;

    private SOverlayUtils() {
    }

    public static void startGameOverlay() {
        SOverlayUtils.startGameOverlay("Loading new game...");
    }

    public static void startGameOverlay(String message) {
        JPanel overlay = SOverlayUtils.genericOverlay();
        int w = overlay.getWidth();
        int h2 = overlay.getHeight();
        int pnlW = 400;
        int pnlH = 300;
        int labelHeight = 50;
        int logoSize = 250;
        FPanel pnl = new FPanel();
        pnl.setLayout(new MigLayout("insets 0, gap 0, ax center, wrap"));
        pnl.setBackground(FSkin.getColor(FSkin.Colors.CLR_ACTIVE).alphaColor(191));
        pnl.setBounds(new Rectangle((w - 400) / 2, (h2 - 300) / 2, 400, 300));
        pnl.add((Component)new FLabel.Builder().icon(FSkin.getIcon(FSkinProp.ICO_LOGO)).iconScaleFactor(1.0).iconInBackground().build(), "w 250px!, h 250px!, align center");
        pnl.add((Component)new FLabel.Builder().text(message).fontSize(22).build(), "h 50px!, align center");
        overlay.add(pnl);
    }

    public static JPanel genericOverlay() {
        FSkin.SkinnedPanel overlay = FOverlay.SINGLETON_INSTANCE.getPanel();
        int w = overlay.getWidth();
        FSkin.SkinnedButton btnCloseTopRight = new FSkin.SkinnedButton("X");
        btnCloseTopRight.setBounds(w - 25, 10, 15, 15);
        btnCloseTopRight.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        btnCloseTopRight.setBorder(new FSkin.LineSkinBorder(FSkin.getColor(FSkin.Colors.CLR_TEXT)));
        btnCloseTopRight.setOpaque(false);
        btnCloseTopRight.setBackground(new Color(0, 0, 0));
        btnCloseTopRight.setFocusPainted(false);
        btnCloseTopRight.addActionListener(arg0 -> SOverlayUtils.hideOverlay());
        overlay.removeAll();
        overlay.setLayout(null);
        overlay.add(btnCloseTopRight);
        return overlay;
    }

    public static boolean overlayHasFocus() {
        return _overlayHasFocus;
    }

    public static void showOverlay() {
        Singletons.getView().getNavigationBar().setEnabled(false);
        prevFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        FOverlay.SINGLETON_INSTANCE.getPanel().setVisible(true);
        FOverlay.SINGLETON_INSTANCE.getPanel().requestFocusInWindow();
        _overlayHasFocus = true;
    }

    public static void hideOverlay() {
        Singletons.getView().getNavigationBar().setEnabled(true);
        FOverlay.SINGLETON_INSTANCE.getPanel().removeAll();
        FOverlay.SINGLETON_INSTANCE.getPanel().setVisible(false);
        if (null != prevFocusOwner) {
            prevFocusOwner.requestFocusInWindow();
            prevFocusOwner = null;
        }
        _overlayHasFocus = false;
    }
}

