/*
 * Decompiled with CFR 0.152.
 */
package forge.gui;

import forge.gui.MultiLineLabel;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;
import javax.swing.text.View;

public class MultiLineLabelUI
extends BasicLabelUI
implements ComponentListener {
    private static LabelUI labelUI = new MultiLineLabelUI();
    public static final String PROPERTY_KEY = "WrappedText";
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);
    private FontMetrics metrics;
    private static int defaultSize = 4;

    @Override
    protected void uninstallDefaults(JLabel c) {
        super.uninstallDefaults(c);
        this.clearCache(c);
    }

    @Override
    protected void installListeners(JLabel c) {
        super.installListeners(c);
        c.addComponentListener(this);
    }

    @Override
    protected void uninstallListeners(JLabel c) {
        super.uninstallListeners(c);
        c.removeComponentListener(this);
    }

    protected void clearCache(JLabel l) {
        l.putClientProperty(PROPERTY_KEY, null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String name = e.getPropertyName();
        if (name.equals("text") || "font".equals(name)) {
            this.clearCache((JLabel)e.getSource());
        }
    }

    protected void updateLayout(JLabel l, FontMetrics fm, int width, int height) {
        if (fm == null) {
            fm = l.getFontMetrics(l.getFont());
        }
        this.metrics = fm;
        String text = l.getText();
        Icon icon = l.getIcon();
        Insets insets = l.getInsets(paintViewInsets);
        MultiLineLabelUI.paintViewR.x = insets.left;
        MultiLineLabelUI.paintViewR.y = insets.top;
        MultiLineLabelUI.paintViewR.width = width - (insets.left + insets.right);
        MultiLineLabelUI.paintViewR.height = height - (insets.top + insets.bottom);
        MultiLineLabelUI.paintIconR.x = 0;
        MultiLineLabelUI.paintIconR.y = 0;
        MultiLineLabelUI.paintIconR.width = 0;
        MultiLineLabelUI.paintIconR.height = 0;
        MultiLineLabelUI.paintTextR.x = 0;
        MultiLineLabelUI.paintTextR.y = 0;
        MultiLineLabelUI.paintTextR.width = 0;
        MultiLineLabelUI.paintTextR.height = 0;
        this.layoutCL(l, fm, text, icon, paintViewR, paintIconR, paintTextR);
    }

    protected void prepareGraphics(Graphics g2) {
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        Icon icon;
        this.prepareGraphics(g2);
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = g2.getFontMetrics();
        this.updateLayout(label, fm, c.getWidth(), c.getHeight());
        if (icon != null) {
            icon.paintIcon(c, g2, MultiLineLabelUI.paintIconR.x, MultiLineLabelUI.paintIconR.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g2, paintTextR);
            } else {
                this.paintTextLines(g2, label, fm);
            }
        }
    }

    protected void paintTextLines(Graphics g2, JLabel label, FontMetrics fm) {
        int textHeight;
        List<String> lines = this.getTextLines(label);
        int height = this.getAvailableHeight(label);
        for (textHeight = lines.size() * fm.getHeight(); textHeight > height; textHeight -= fm.getHeight()) {
        }
        MultiLineLabelUI.paintTextR.height = Math.min(textHeight, height);
        MultiLineLabelUI.paintTextR.y = this.alignmentY(label, fm, paintTextR);
        int textX = MultiLineLabelUI.paintTextR.x;
        int textY = MultiLineLabelUI.paintTextR.y;
        Iterator<String> it = lines.iterator();
        while (it.hasNext() && paintTextR.contains(textX, textY + MultiLineLabelUI.getAscent(fm))) {
            String text = it.next().trim();
            if (it.hasNext() && !paintTextR.contains(textX, textY + fm.getHeight() + MultiLineLabelUI.getAscent(fm))) {
                text = this.clip(text, fm, paintTextR);
            }
            int x = this.alignmentX(label, fm, text, paintTextR);
            if (label.isEnabled()) {
                this.paintEnabledText(label, g2, text, x, textY);
            } else {
                this.paintDisabledText(label, g2, text, x, textY);
            }
            textY += fm.getHeight();
        }
    }

    protected int getAvailableHeight(JLabel l) {
        l.getInsets(paintViewInsets);
        return l.getHeight() - MultiLineLabelUI.paintViewInsets.top - MultiLineLabelUI.paintViewInsets.bottom;
    }

    protected String clip(String text, FontMetrics fm, Rectangle bounds) {
        if (text.length() < 3) {
            return "...";
        }
        return text.substring(0, text.length() - 3) + "...";
    }

    protected int alignmentY(JLabel label, FontMetrics fm, Rectangle bounds) {
        int height = this.getAvailableHeight(label);
        int textHeight = bounds.height;
        if (label instanceof MultiLineLabel) {
            int align = ((MultiLineLabel)label).getVerticalTextAlignment();
            switch (align) {
                case 1: {
                    return MultiLineLabelUI.getAscent(fm) + MultiLineLabelUI.paintViewInsets.top;
                }
                case 3: {
                    return MultiLineLabelUI.getAscent(fm) + height - MultiLineLabelUI.paintViewInsets.top + MultiLineLabelUI.paintViewInsets.bottom - textHeight;
                }
            }
        }
        int textY = MultiLineLabelUI.paintViewInsets.top + (height - textHeight) / 2 + MultiLineLabelUI.getAscent(fm);
        return Math.max(textY, MultiLineLabelUI.getAscent(fm) + MultiLineLabelUI.paintViewInsets.top);
    }

    private static int getAscent(FontMetrics fm) {
        return fm.getAscent() + fm.getLeading();
    }

    protected int alignmentX(JLabel label, FontMetrics fm, String s2, Rectangle bounds) {
        if (label instanceof MultiLineLabel) {
            int align = ((MultiLineLabel)label).getHorizontalTextAlignment();
            switch (align) {
                case 4: {
                    return bounds.x + MultiLineLabelUI.paintViewR.width - fm.stringWidth(s2);
                }
                case 0: {
                    return bounds.x + MultiLineLabelUI.paintViewR.width / 2 - fm.stringWidth(s2) / 2;
                }
            }
            return bounds.x;
        }
        return bounds.x;
    }

    private static boolean isHTMLString(String s2) {
        if (s2 != null && s2.length() >= 6 && s2.charAt(0) == '<' && s2.charAt(5) == '>') {
            String tag = s2.substring(1, 5);
            return tag.equalsIgnoreCase("html");
        }
        return false;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        JLabel label = (JLabel)c;
        if (MultiLineLabelUI.isHTMLString(label.getText())) {
            return d;
        }
        if (c.getParent() != null) {
            Insets insets = c.getParent().getInsets();
            Dimension size = c.getParent().getSize();
            if (size.width > 0) {
                d.width = size.width - insets.left - insets.right;
            }
        }
        this.updateLayout(label, null, d.width, d.height);
        d.height = Math.max(d.height, this.getPreferredHeight(label));
        return d;
    }

    protected int getPreferredHeight(JLabel label) {
        int numOfLines = this.getTextLines(label).size();
        Insets insets = label.getInsets(paintViewInsets);
        return numOfLines * this.metrics.getHeight() + insets.top + insets.bottom;
    }

    protected List<String> getTextLines(JLabel l) {
        List<String> lines = (List<String>)l.getClientProperty(PROPERTY_KEY);
        if (lines == null) {
            lines = this.prepareLines(l);
            l.putClientProperty(PROPERTY_KEY, lines);
        }
        return lines;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.clearCache((JLabel)e.getSource());
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    protected List<String> prepareLines(JLabel l) {
        ArrayList<String> lines = new ArrayList<String>(defaultSize);
        String text = l.getText();
        if (text == null) {
            return null;
        }
        PlainDocument doc = new PlainDocument();
        try {
            doc.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            return null;
        }
        Element root = doc.getDefaultRootElement();
        int j = root.getElementCount();
        for (int i = 0; i < j; ++i) {
            this.wrap(lines, root.getElement(i));
        }
        return lines;
    }

    protected void wrap(List<String> lines, Element elem) {
        int p1 = elem.getEndOffset();
        Document doc = elem.getDocument();
        int p0 = elem.getStartOffset();
        while (p0 < p1) {
            int p = this.calculateBreakPosition(doc, p0, p1);
            try {
                lines.add(doc.getText(p0, p - p0));
            }
            catch (BadLocationException e) {
                throw new Error("Can't get line text. p0=" + p0 + " p=" + p);
            }
            p0 = p == p0 ? p1 : p;
        }
    }

    protected int calculateBreakPosition(Document doc, int p0, int p1) {
        Segment segment = SegmentCache.getSegment();
        try {
            doc.getText(p0, p1 - p0, segment);
        }
        catch (BadLocationException e) {
            throw new Error("Can't get line text");
        }
        int width = MultiLineLabelUI.paintTextR.width;
        int p = p0 + Utilities.getBreakLocation(segment, this.metrics, 0, width, null, p0);
        SegmentCache.releaseSegment(segment);
        return p;
    }

    public static LabelUI getLabelUI() {
        return labelUI;
    }

    protected static final class SegmentCache {
        private final List<Segment> segments = new ArrayList<Segment>(2);
        private static SegmentCache cache = new SegmentCache();

        private SegmentCache() {
        }

        public static Segment getSegment() {
            int size = SegmentCache.cache.segments.size();
            if (size > 0) {
                return SegmentCache.cache.segments.remove(size - 1);
            }
            return new Segment();
        }

        public static void releaseSegment(Segment segment) {
            segment.array = null;
            segment.count = 0;
            SegmentCache.cache.segments.add(segment);
        }
    }
}

