/*
 * Decompiled with CFR 0.152.
 */
package forge.gui;

import forge.view.FView;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public final class MouseUtil {
    private static Cursor cursor;
    private static int cursorLockCount;

    public static void lockCursor() {
        ++cursorLockCount;
    }

    public static void unlockCursor() {
        if (cursorLockCount == 0) {
            return;
        }
        if (--cursorLockCount == 0) {
            FView.SINGLETON_INSTANCE.getLpnDocument().setCursor(cursor);
        }
    }

    public static void resetCursor() {
        MouseUtil.setCursor(Cursor.getDefaultCursor());
    }

    public static void setCursor(int cursorType) {
        MouseUtil.setCursor(Cursor.getPredefinedCursor(cursorType));
    }

    public static void setCursor(Cursor cursor0) {
        if (cursor == cursor0) {
            return;
        }
        cursor = cursor0;
        if (cursorLockCount > 0) {
            return;
        }
        FView.SINGLETON_INSTANCE.getLpnDocument().setCursor(cursor);
    }

    public static void setComponentCursor(Component comp, int cursorType) {
        MouseUtil.setComponentCursor(comp, Cursor.getPredefinedCursor(cursorType));
    }

    public static void setComponentCursor(Component comp, final Cursor cursor0) {
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                MouseUtil.setCursor(cursor0);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MouseUtil.resetCursor();
            }
        });
    }
}

