/*
 * Decompiled with CFR 0.152.
 */
package forge.gui;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import forge.gui.FThreads;
import forge.toolbox.FList;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FOptionPane;
import forge.toolbox.FScrollPane;
import forge.util.Localizer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListChooser<T> {
    private final List<T> list;
    private final int minChoices;
    private final int maxChoices;
    private boolean called;
    private final FList<T> lstChoices;
    private final FOptionPane optionPane;

    public ListChooser(String title, int minChoices, int maxChoices, Collection<T> list, Function<T, String> display) {
        FThreads.assertExecutedByEdt(true);
        this.minChoices = minChoices;
        this.maxChoices = maxChoices;
        this.list = list.getClass().isInstance(List.class) ? (ArrayList<T>)list : Lists.newArrayList(list);
        this.lstChoices = new FList(new ChooserListModel());
        ImmutableList<String> options = minChoices == 0 ? ImmutableList.of(Localizer.getInstance().getMessage("lblOK", new Object[0]), Localizer.getInstance().getMessage("lblCancel", new Object[0])) : ImmutableList.of(Localizer.getInstance().getMessage("lblOK", new Object[0]));
        if (maxChoices == 1 || minChoices == -1) {
            this.lstChoices.setSelectionMode(0);
        }
        if (display != null) {
            this.lstChoices.setCellRenderer(new TransformedCellRenderer(display));
        }
        FScrollPane listScroller = new FScrollPane(this.lstChoices, true);
        int minWidth = this.lstChoices.getAutoSizeWidth();
        if (this.lstChoices.getModel().getSize() > this.lstChoices.getVisibleRowCount()) {
            minWidth += listScroller.getVerticalScrollBar().getPreferredSize().width;
        }
        listScroller.setMinimumSize(new Dimension(minWidth, listScroller.getMinimumSize().height));
        this.optionPane = new FOptionPane(null, title, null, listScroller, options, minChoices < 0 ? 0 : -1);
        this.optionPane.setButtonEnabled(0, minChoices <= 0);
        if (minChoices != -1) {
            this.optionPane.setDefaultFocus(this.lstChoices);
        }
        if (minChoices > 0) {
            this.optionPane.setDefaultCloseOperation(0);
        }
        if (minChoices != -1) {
            this.lstChoices.getSelectionModel().addListSelectionListener(new SelListener());
        }
        this.lstChoices.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ListChooser.this.commit();
                }
            }
        });
        this.lstChoices.addMouseListener(new FMouseAdapter(){

            @Override
            public void onLeftDoubleClick(MouseEvent e) {
                ListChooser.this.commit();
            }
        });
    }

    public FList<T> getLstChoices() {
        return this.lstChoices;
    }

    public boolean show() {
        return this.show(this.list.get(0));
    }

    public boolean show(T item) {
        int result;
        if (this.called) {
            throw new IllegalStateException("Already shown");
        }
        do {
            SwingUtilities.invokeLater(() -> {
                if (this.list.contains(item)) {
                    this.lstChoices.setSelectedValue(item, true);
                } else {
                    this.lstChoices.setSelectedIndex(0);
                }
            });
            this.optionPane.setVisible(true);
            result = this.optionPane.getResult();
            if (result == 0) continue;
            this.lstChoices.clearSelection();
        } while (this.minChoices > 0 && result != 0);
        this.optionPane.dispose();
        assert (this.minChoices <= 0 || result == 0);
        this.called = true;
        return result == 0;
    }

    public boolean isCommitted() {
        if (!this.called) {
            throw new IllegalStateException("not yet shown");
        }
        return this.optionPane.getResult() == 0;
    }

    public int[] getSelectedIndices() {
        if (!this.called) {
            throw new IllegalStateException("not yet shown");
        }
        return this.lstChoices.getSelectedIndices();
    }

    public List<T> getSelectedValues() {
        if (!this.called) {
            throw new IllegalStateException("not yet shown");
        }
        return this.lstChoices.getSelectedValuesList();
    }

    public int getSelectedIndex() {
        if (!this.called) {
            throw new IllegalStateException("not yet shown");
        }
        return this.lstChoices.getSelectedIndex();
    }

    public T getSelectedValue() {
        if (!this.called) {
            throw new IllegalStateException("not yet shown");
        }
        return (T)this.lstChoices.getSelectedValue();
    }

    private void commit() {
        if (this.optionPane.isButtonEnabled(0)) {
            this.optionPane.setResult(0);
        }
    }

    private class TransformedCellRenderer
    implements ListCellRenderer<T> {
        public final Function<T, String> transformer;
        public final DefaultListCellRenderer defRenderer;

        public TransformedCellRenderer(Function<T, String> t1) {
            this.transformer = t1;
            this.defRenderer = new DefaultListCellRenderer();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.defRenderer.getListCellRendererComponent((JList<?>)list, this.transformer.apply(value), index, isSelected, cellHasFocus);
        }
    }

    private class SelListener
    implements ListSelectionListener {
        private SelListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int num = ListChooser.this.lstChoices.getSelectedIndices().length;
            ListChooser.this.optionPane.setButtonEnabled(0, num >= ListChooser.this.minChoices && num <= ListChooser.this.maxChoices);
        }
    }

    private class ChooserListModel
    extends AbstractListModel<T> {
        private static final long serialVersionUID = 3871965346333840556L;

        private ChooserListModel() {
        }

        @Override
        public int getSize() {
            return ListChooser.this.list.size();
        }

        @Override
        public T getElementAt(int index) {
            return ListChooser.this.list.get(index);
        }
    }
}

