/*
 * Decompiled with CFR 0.152.
 */
package forge.gui;

import com.google.common.collect.ImmutableList;
import forge.gui.ImportSourceAnalyzer;
import forge.gui.SOverlayUtils;
import forge.gui.error.BugReporter;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FButton;
import forge.toolbox.FCheckBox;
import forge.toolbox.FComboBoxWrapper;
import forge.toolbox.FLabel;
import forge.toolbox.FOptionPane;
import forge.toolbox.FOverlay;
import forge.toolbox.FPanel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.toolbox.FTextField;
import forge.toolbox.SmartScroller;
import forge.util.TextUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ImportDialog {
    private final FButton _btnStart;
    private final FButton _btnCancel;
    private final FLabel _btnChooseDir;
    private final FPanel _topPanel;
    private final JPanel _selectionPanel;
    private final FTextField _txfSrc;
    private final String forcedSrcDir;
    private final boolean isMigration;
    private volatile boolean _cancel;
    private static final ImmutableList<String> fixOrContinue = ImmutableList.of("Whoops, let me fix that!", "Continue with the import, I know what I'm doing.");

    public ImportDialog(String forcedSrcDir, Runnable onDialogClose) {
        this.forcedSrcDir = forcedSrcDir;
        this._topPanel = new FPanel(new MigLayout("insets dialog, gap 0, center, wrap, fill"));
        this._topPanel.setOpaque(false);
        this._topPanel.setBackgroundTexture(FSkin.getIcon(FSkinProp.BG_TEXTURE));
        this.isMigration = !StringUtils.isEmpty(forcedSrcDir);
        this._topPanel.add((Component)new FLabel.Builder().text((this.isMigration ? "Migrate" : "Import") + " profile data").fontSize(15).build(), "center");
        if (this.isMigration) {
            FPanel blurbPanel = new FPanel(new MigLayout("insets panel, gap 10, fill"));
            blurbPanel.setOpaque(false);
            JPanel blurbPanelInterior = new JPanel(new MigLayout("insets dialog, gap 10, center, wrap, fill"));
            blurbPanelInterior.setOpaque(false);
            blurbPanelInterior.add((Component)new FLabel.Builder().text("<html><b>What's this?</b></html>").build(), "growx, w 50:50:");
            blurbPanelInterior.add((Component)new FLabel.Builder().text("<html>Over the last several years, people have had to jump through a lot of hoops to update to the most recent version.  We hope to reduce this workload to a point where a new user will find that it is fairly painless to update.  In order to make this happen, Forge has changed where it stores your data so that it is outside of the program installation directory.  This way, when you upgrade, you will no longer need to import your data every time to get things working.  There are other benefits to having user data separate from program data, too, and it lays the groundwork for some cool new features.</html>").build(), "growx, w 50:50:");
            blurbPanelInterior.add((Component)new FLabel.Builder().text("<html><b>So where's my data going?</b></html>").build(), "growx, w 50:50:");
            blurbPanelInterior.add((Component)new FLabel.Builder().text("<html>Forge will now store your data in the same place as other applications on your system.  Specifically, your personal data, like decks, quest progress, and program preferences will be stored in <b>" + ForgeConstants.USER_DIR + "</b> and all downloaded content, such as card pictures, skins, and quest world prices will be under <b>" + ForgeConstants.CACHE_DIR + "</b>.  If, for whatever reason, you need to set different paths, cancel out of this dialog, exit Forge, and find the <b>" + ForgeConstants.PROFILE_TEMPLATE_FILE + "</b> file in the program installation directory.  Copy or rename it to <b>" + ForgeConstants.PROFILE_FILE + "</b> and edit the paths inside it.  Then restart Forge and use this dialog to move your data to the paths that you set.  Keep in mind that if you install a future version of Forge into a different directory, you'll need to copy this file over so Forge will know where to find your data.</html>").build(), "growx, w 50:50:");
            blurbPanelInterior.add((Component)new FLabel.Builder().text("<html><b>Remember, your data won't be available until you complete this step!</b></html>").build(), "growx, w 50:50:");
            FScrollPane blurbScroller = new FScrollPane(blurbPanelInterior, true, 20, 31);
            blurbPanel.add((Component)blurbScroller, "hmin 150, growy, growx, center, gap 0 0 5 5");
            this._topPanel.add((Component)blurbPanel, "gap 10 10 20 0, growy, growx, w 50:50:");
        }
        JPanel importSourcePanel = new JPanel(new MigLayout("insets 0, gap 10"));
        importSourcePanel.setOpaque(false);
        importSourcePanel.add(new FLabel.Builder().text("Import from:").build());
        this._txfSrc = new FTextField.Builder().readonly().build();
        importSourcePanel.add((Component)this._txfSrc, "pushx, growx");
        this._btnChooseDir = new FLabel.ButtonBuilder().text("Choose directory...").enabled(!this.isMigration).build();
        JFileChooser _fileChooser = new JFileChooser();
        _fileChooser.setMultiSelectionEnabled(false);
        _fileChooser.setFileSelectionMode(1);
        this._btnChooseDir.setCommand(() -> {
            if (0 == _fileChooser.showOpenDialog(JOptionPane.getRootFrame())) {
                File f = _fileChooser.getSelectedFile();
                if (!f.canRead()) {
                    FOptionPane.showErrorDialog("Cannot access selected directory (Permission denied).");
                } else {
                    this._txfSrc.setText(f.getAbsolutePath());
                }
            }
        });
        importSourcePanel.add((Component)this._btnChooseDir, "h pref+8!, w pref+12!");
        this._txfSrc.getDocument().addDocumentListener(new DocumentListener(){
            boolean _analyzerActive;
            String prevText;
            private final Runnable _onAnalyzerDone = new Runnable(){

                @Override
                public synchronized void run() {
                    _analyzerActive = false;
                    this.notify();
                }
            };

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                final String text = ImportDialog.this._txfSrc.getText();
                if (text.equals(this.prevText)) {
                    return;
                }
                this.prevText = text;
                ImportDialog.this._cancel = true;
                if (!text.isEmpty()) {
                    ImportDialog.this._btnChooseDir.setEnabled(false);
                    ImportDialog.this._btnStart.setEnabled(false);
                    SwingWorker<Void, Void> analyzerStarter = new SwingWorker<Void, Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected Void doInBackground() throws Exception {
                            Runnable runnable = _onAnalyzerDone;
                            synchronized (runnable) {
                                while (_analyzerActive) {
                                    _onAnalyzerDone.wait();
                                }
                            }
                            return null;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void done() {
                            ImportDialog.this._cancel = false;
                            Runnable runnable = _onAnalyzerDone;
                            synchronized (runnable) {
                                _AnalyzerUpdater analyzer = new _AnalyzerUpdater(text, _onAnalyzerDone, ImportDialog.this.isMigration);
                                analyzer.run();
                                _analyzerActive = true;
                            }
                            if (!ImportDialog.this.isMigration) {
                                ImportDialog.this._btnChooseDir.setEnabled(true);
                            }
                        }
                    };
                    analyzerStarter.execute();
                }
            }
        });
        this._topPanel.add((Component)importSourcePanel, "gaptop 20, pushx, growx");
        this._selectionPanel = new JPanel();
        this._selectionPanel.setOpaque(false);
        this._topPanel.add((Component)this._selectionPanel, "growx, growy, gaptop 10");
        Runnable cleanup = SOverlayUtils::hideOverlay;
        this._btnStart = new FButton("Start import");
        this._btnStart.setEnabled(false);
        this._btnCancel = new FButton("Cancel");
        this._btnCancel.addActionListener(e -> {
            this._cancel = true;
            cleanup.run();
            if (null != onDialogClose) {
                onDialogClose.run();
            }
        });
        JPanel southPanel = new JPanel(new MigLayout("ax center"));
        southPanel.setOpaque(false);
        southPanel.add((Component)this._btnStart, "center, w pref+144!, h pref+12!");
        southPanel.add((Component)this._btnCancel, "center, w pref+144!, h pref+12!, gap 72");
        this._topPanel.add((Component)southPanel, "growx");
    }

    public void show() {
        FSkin.SkinnedPanel overlay = FOverlay.SINGLETON_INSTANCE.getPanel();
        overlay.setLayout(new MigLayout("insets 0, gap 0, wrap, ax center, ay center"));
        overlay.add((Component)this._topPanel, "w 500::90%, h 100::90%");
        SOverlayUtils.showOverlay();
        SwingUtilities.invokeLater(this._btnCancel::requestFocusInWindow);
        if (this.isMigration) {
            File srcDirFile = new File(this.forcedSrcDir);
            this._txfSrc.setText(srcDirFile.getAbsolutePath());
        }
    }

    private static void _copyFile(File srcFile, File destFile, boolean deleteSrcAfter) throws IOException {
        destFile.getParentFile().mkdirs();
        if (deleteSrcAfter && srcFile.renameTo(destFile)) {
            return;
        }
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        try (FileInputStream srcStream = new FileInputStream(srcFile);
             FileChannel src = srcStream.getChannel();
             FileOutputStream destStream = new FileOutputStream(destFile);
             FileChannel dest = destStream.getChannel();){
            dest.transferFrom(src, 0L, src.size());
        }
        if (deleteSrcAfter) {
            srcFile.delete();
        }
    }

    private class _Importer
    extends SwingWorker<Void, Void> {
        private final String _srcDir;
        private final Map<File, File> _operations;
        private final JTextArea _operationLog;
        private final JProgressBar _progressBar;
        private final boolean _move;
        private final boolean _overwrite;

        public _Importer(String srcDir, Map<ImportSourceAnalyzer.OpType, Pair<FCheckBox, ? extends Map<File, File>>> selections, FComboBoxWrapper<_UnknownDeckChoice> unknownDeckCombo, JTextArea operationLog, JProgressBar progressBar, boolean move, boolean overwrite) {
            this._srcDir = srcDir;
            this._operationLog = operationLog;
            this._progressBar = progressBar;
            this._move = move;
            this._overwrite = overwrite;
            this._operations = new TreeMap<File, File>();
            for (Map.Entry<ImportSourceAnalyzer.OpType, Pair<FCheckBox, ? extends Map<File, File>>> entry : selections.entrySet()) {
                Pair<FCheckBox, ? extends Map<File, File>> selection = entry.getValue();
                if (!selection.getLeft().isSelected()) continue;
                if (ImportSourceAnalyzer.OpType.UNKNOWN_DECK != entry.getKey()) {
                    this._operations.putAll(selection.getRight());
                    continue;
                }
                for (Map.Entry<File, File> op : selection.getRight().entrySet()) {
                    _UnknownDeckChoice choice = unknownDeckCombo.getSelectedItem();
                    this._operations.put(op.getKey(), new File(choice.path, op.getValue().getName()));
                }
            }
            this._progressBar.setString(this._move ? "Moving files..." : "Copying files...");
            this._progressBar.setMinimum(0);
            this._progressBar.setMaximum(this._operations.size());
        }

        @Override
        protected Void doInBackground() {
            try {
                this._operationLog.setText("");
                long updateIntervalMs = 500L;
                long lastUpdateTimestampMs = System.currentTimeMillis() - 400L;
                StringBuffer opLogBuf = new StringBuffer();
                long progressInterval = Math.max(1, this._operations.size() / this._progressBar.getWidth());
                int srcPathPrefixLen = this._srcDir.endsWith("/") || this._srcDir.endsWith(File.separator) ? this._srcDir.length() : this._srcDir.length() + 1;
                int numOps = 0;
                int numExisting = 0;
                int numSucceeded = 0;
                int numFailed = 0;
                for (Map.Entry<File, File> op : this._operations.entrySet()) {
                    long curTimeMs;
                    int curOpNum;
                    if (ImportDialog.this._cancel) break;
                    if (0L == (long)(curOpNum = ++numOps) % progressInterval) {
                        SwingUtilities.invokeLater(() -> {
                            if (ImportDialog.this._cancel) {
                                return;
                            }
                            this._progressBar.setValue(curOpNum);
                        });
                    }
                    if (500L <= (curTimeMs = System.currentTimeMillis()) - lastUpdateTimestampMs) {
                        lastUpdateTimestampMs = curTimeMs;
                        this._operationLog.append(opLogBuf.toString());
                        opLogBuf.setLength(0);
                    }
                    File srcFile = op.getKey();
                    File destFile = op.getValue();
                    try {
                        String srcPath = srcFile.getAbsolutePath();
                        if (srcPath.startsWith(this._srcDir)) {
                            srcPath = srcPath.substring(srcPathPrefixLen);
                        }
                        opLogBuf.append(this._move ? "Moving " : "Copying ").append(srcPath).append(" -> ");
                        opLogBuf.append(destFile.getAbsolutePath()).append("\n");
                        if (!destFile.exists()) {
                            ImportDialog._copyFile(srcFile, destFile, this._move);
                        } else {
                            if (this._overwrite) {
                                opLogBuf.append("  Destination file exists; overwriting\n");
                                ImportDialog._copyFile(srcFile, destFile, this._move);
                            } else {
                                opLogBuf.append("  Destination file exists; skipping copy\n");
                            }
                            ++numExisting;
                        }
                        if (this._move) {
                            srcFile.delete();
                            opLogBuf.append("  Removed source file after successful copy\n");
                        }
                        ++numSucceeded;
                    }
                    catch (IOException e) {
                        opLogBuf.append("  Operation failed: ").append(e.getMessage()).append("\n");
                        ++numFailed;
                    }
                }
                opLogBuf.append("\nImport complete: ");
                opLogBuf.append(numSucceeded).append(" operation").append(1 == numSucceeded ? "" : "s").append(" succeeded, ");
                opLogBuf.append(numFailed).append(" error").append(1 == numFailed ? "" : "s");
                if (0 < numExisting) {
                    opLogBuf.append(", ").append(numExisting);
                    if (this._overwrite) {
                        opLogBuf.append(" existing destination files overwritten");
                    } else {
                        opLogBuf.append(" copy operations skipped due to existing destination files");
                    }
                }
                this._operationLog.append(opLogBuf.toString());
            }
            catch (Exception e) {
                ImportDialog.this._cancel = true;
                SwingUtilities.invokeLater(() -> {
                    this._progressBar.setString("Error");
                    BugReporter.reportException(e);
                });
            }
            return null;
        }

        @Override
        protected void done() {
            ImportDialog.this._btnCancel.requestFocusInWindow();
            if (ImportDialog.this._cancel) {
                return;
            }
            this._progressBar.setValue(this._progressBar.getMaximum());
            this._progressBar.setString("Import complete");
            ImportDialog.this._btnCancel.setText("Done");
        }
    }

    private class _OperationLogAsyncUpdater
    extends Thread {
        final Map<ImportSourceAnalyzer.OpType, Map<File, File>> _selections;
        final JTextArea _operationLog;
        private int _updateCallCnt;
        private Set<ImportSourceAnalyzer.OpType> _selectedOptions;
        private _UnknownDeckChoice _unknownDeckChoice;
        private boolean _isMove;
        private boolean _isOverwrite;
        private boolean _stop;
        int _maxLogLength;

        public _OperationLogAsyncUpdater(Map<ImportSourceAnalyzer.OpType, Pair<FCheckBox, ? extends Map<File, File>>> selections, JTextArea operationLog) {
            super("OperationLogUpdater");
            this._updateCallCnt = 0;
            this._maxLogLength = 0;
            this.setDaemon(true);
            this._selections = new HashMap<ImportSourceAnalyzer.OpType, Map<File, File>>();
            this._operationLog = operationLog;
            for (Map.Entry<ImportSourceAnalyzer.OpType, Pair<FCheckBox, ? extends Map<File, File>>> entry : selections.entrySet()) {
                this._selections.put(entry.getKey(), entry.getValue().getRight());
            }
        }

        public synchronized void requestUpdate(Set<ImportSourceAnalyzer.OpType> selectedOptions, _UnknownDeckChoice unknownDeckChoice, boolean isMove, boolean isOverwrite) {
            ++this._updateCallCnt;
            this._selectedOptions = selectedOptions;
            this._unknownDeckChoice = unknownDeckChoice;
            this._isMove = isMove;
            this._isOverwrite = isOverwrite;
            this.notify();
        }

        public synchronized void requestStop() {
            this._stop = true;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _run() throws InterruptedException {
            int lastUpdateCallCnt = this._updateCallCnt;
            while (true) {
                boolean isOverwrite;
                boolean isMove;
                _UnknownDeckChoice unknownDeckChoice;
                Set<ImportSourceAnalyzer.OpType> selectedOptions;
                _OperationLogAsyncUpdater _OperationLogAsyncUpdater2 = this;
                synchronized (_OperationLogAsyncUpdater2) {
                    if (this._stop) {
                        break;
                    }
                    while (lastUpdateCallCnt == this._updateCallCnt && !this._stop) {
                        this.wait();
                    }
                    lastUpdateCallCnt = this._updateCallCnt;
                    selectedOptions = this._selectedOptions;
                    unknownDeckChoice = this._unknownDeckChoice;
                    isMove = this._isMove;
                    isOverwrite = this._isOverwrite;
                }
                StringBuilder log = new StringBuilder();
                int totalOps = 0;
                for (ImportSourceAnalyzer.OpType opType : selectedOptions) {
                    Map<File, File> ops = this._selections.get((Object)opType);
                    totalOps += ops.size();
                    for (Map.Entry<File, File> op : ops.entrySet()) {
                        File dest = op.getValue();
                        if (ImportSourceAnalyzer.OpType.UNKNOWN_DECK == opType) {
                            dest = new File(unknownDeckChoice.path, dest.getName());
                        }
                        log.append(op.getKey().getAbsolutePath()).append(" -> ");
                        log.append(dest.getAbsolutePath()).append("\n");
                    }
                }
                if (0 < totalOps) {
                    log.append("\n");
                }
                log.append("Prepared to ").append(isMove ? "move" : "copy");
                log.append(" ").append(totalOps).append(" files\n");
                log.append(isOverwrite ? "O" : "Not o").append("verwriting existing files");
                SwingUtilities.invokeLater(() -> {
                    String logText = log.toString();
                    this._operationLog.setText(log.toString());
                    if (this._maxLogLength < logText.length()) {
                        this._maxLogLength = logText.length();
                        ImportDialog.this._selectionPanel.getParent().validate();
                        ImportDialog.this._selectionPanel.getParent().invalidate();
                        ImportDialog.this._topPanel.getParent().validate();
                        ImportDialog.this._topPanel.getParent().invalidate();
                    }
                });
            }
        }

        @Override
        public void run() {
            try {
                this._run();
            }
            catch (InterruptedException e) {
                ImportDialog.this._cancel = true;
                SwingUtilities.invokeLater(() -> BugReporter.reportException(e));
            }
        }
    }

    private class _AnalyzerUpdater
    extends SwingWorker<Void, Void> {
        private final Map<ImportSourceAnalyzer.OpType, Pair<FCheckBox, ? extends Map<File, File>>> _selections = new HashMap<ImportSourceAnalyzer.OpType, Pair<FCheckBox, ? extends Map<File, File>>>();
        private final ChangeListener _stateChangedListener = arg0 -> this._updateUI();
        private final String _srcDir;
        private final Runnable _onAnalyzerDone;
        private final boolean _isMigration;
        private final FLabel _unknownDeckLabel;
        private final FComboBoxWrapper<_UnknownDeckChoice> _unknownDeckCombo;
        private final FCheckBox _moveCheckbox;
        private final FCheckBox _overwriteCheckbox;
        private final JTextArea _operationLog;
        private final JScrollPane _operationLogScroller;
        private final JProgressBar _progressBar;
        private final _OperationLogAsyncUpdater _operationLogUpdater;

        public _AnalyzerUpdater(String srcDir, Runnable onAnalyzerDone, boolean isMigration) {
            this._srcDir = srcDir;
            this._onAnalyzerDone = onAnalyzerDone;
            this._isMigration = isMigration;
            ImportDialog.this._selectionPanel.removeAll();
            ImportDialog.this._selectionPanel.setLayout(new MigLayout("insets 0, gap 5, wrap, fill"));
            JPanel cbPanel = new JPanel(new MigLayout("insets 0, gap 5"));
            cbPanel.setOpaque(false);
            JPanel knownDeckPanel = new JPanel(new MigLayout("insets 0, gap 5, wrap 2"));
            knownDeckPanel.setOpaque(false);
            knownDeckPanel.add((Component)new FLabel.Builder().text("Decks").build(), "wrap");
            this._addSelectionWidget(knownDeckPanel, ImportSourceAnalyzer.OpType.CONSTRUCTED_DECK, "Constructed decks");
            this._addSelectionWidget(knownDeckPanel, ImportSourceAnalyzer.OpType.DRAFT_DECK, "Draft decks");
            this._addSelectionWidget(knownDeckPanel, ImportSourceAnalyzer.OpType.PLANAR_DECK, "Planar decks");
            this._addSelectionWidget(knownDeckPanel, ImportSourceAnalyzer.OpType.SCHEME_DECK, "Scheme decks");
            this._addSelectionWidget(knownDeckPanel, ImportSourceAnalyzer.OpType.SEALED_DECK, "Sealed decks");
            this._addSelectionWidget(knownDeckPanel, ImportSourceAnalyzer.OpType.UNKNOWN_DECK, "Unknown decks");
            JPanel unknownDeckPanel = new JPanel(new MigLayout("insets 0, gap 5"));
            unknownDeckPanel.setOpaque(false);
            this._unknownDeckCombo = new FComboBoxWrapper();
            this._unknownDeckCombo.addItem(new _UnknownDeckChoice("Constructed", ForgeConstants.DECK_CONSTRUCTED_DIR));
            this._unknownDeckCombo.addItem(new _UnknownDeckChoice("Draft", ForgeConstants.DECK_DRAFT_DIR));
            this._unknownDeckCombo.addItem(new _UnknownDeckChoice("Planar", ForgeConstants.DECK_PLANE_DIR));
            this._unknownDeckCombo.addItem(new _UnknownDeckChoice("Scheme", ForgeConstants.DECK_SCHEME_DIR));
            this._unknownDeckCombo.addItem(new _UnknownDeckChoice("Sealed", ForgeConstants.DECK_SEALED_DIR));
            this._unknownDeckCombo.addActionListener(arg0 -> this._updateUI());
            this._unknownDeckLabel = new FLabel.Builder().text("Treat unknown decks as:").build();
            unknownDeckPanel.add(this._unknownDeckLabel);
            this._unknownDeckCombo.addTo(unknownDeckPanel);
            knownDeckPanel.add((Component)unknownDeckPanel, "span");
            cbPanel.add((Component)knownDeckPanel, "aligny top");
            JPanel dataPanel = new JPanel(new MigLayout("insets 0, gap 5, wrap"));
            dataPanel.setOpaque(false);
            dataPanel.add(new FLabel.Builder().text("Other data").build());
            this._addSelectionWidget(dataPanel, ImportSourceAnalyzer.OpType.GAUNTLET_DATA, "Gauntlet data");
            this._addSelectionWidget(dataPanel, ImportSourceAnalyzer.OpType.QUEST_DATA, "Quest saves");
            this._addSelectionWidget(dataPanel, ImportSourceAnalyzer.OpType.PREFERENCE_FILE, "Preference files");
            cbPanel.add((Component)dataPanel, "aligny top");
            JPanel cachePanel = new JPanel(new MigLayout("insets 0, gap 5, wrap 2"));
            cachePanel.setOpaque(false);
            cachePanel.add((Component)new FLabel.Builder().text("Cached data").build(), "wrap");
            this._addSelectionWidget(cachePanel, ImportSourceAnalyzer.OpType.DEFAULT_CARD_PIC, "Default card pics");
            this._addSelectionWidget(cachePanel, ImportSourceAnalyzer.OpType.SET_CARD_PIC, "Set-specific card pics");
            this._addSelectionWidget(cachePanel, ImportSourceAnalyzer.OpType.TOKEN_PIC, "Card token pics");
            this._addSelectionWidget(cachePanel, ImportSourceAnalyzer.OpType.QUEST_PIC, "Quest-related pics");
            this._addSelectionWidget(cachePanel, ImportSourceAnalyzer.OpType.DB_FILE, "Database files", true, null, "wrap");
            this._addSelectionWidget(cachePanel, ImportSourceAnalyzer.OpType.POSSIBLE_SET_CARD_PIC, "Import possible set pics from as-yet unsupported cards", false, "<html>Picture files that are not recognized as belonging to any known card.<br>It could be that these pictures belong to cards that are not yet supported<br>by Forge.  If you know this to be the case and want the pictures imported for<br>future use, select this option.<html>", "span");
            cbPanel.add((Component)cachePanel, "aligny top");
            ImportDialog.this._selectionPanel.add((Component)cbPanel, "center");
            JPanel ioOptionPanel = new JPanel(new MigLayout("insets 0, gap 10"));
            ioOptionPanel.setOpaque(false);
            this._moveCheckbox = new FCheckBox("Remove source files after copy");
            this._moveCheckbox.setToolTipText("Move files into the data directories instead of just copying them");
            this._moveCheckbox.setSelected(isMigration);
            this._moveCheckbox.addChangeListener(this._stateChangedListener);
            ioOptionPanel.add(this._moveCheckbox);
            this._overwriteCheckbox = new FCheckBox("Overwrite files in destination");
            this._overwriteCheckbox.setToolTipText("Overwrite existing data with the imported data");
            this._overwriteCheckbox.addChangeListener(this._stateChangedListener);
            ioOptionPanel.add(this._overwriteCheckbox);
            ImportDialog.this._selectionPanel.add(ioOptionPanel);
            this._operationLog = new JTextArea();
            this._operationLog.setFont(new Font("Monospaced", 0, 10));
            this._operationLog.setOpaque(false);
            this._operationLog.setWrapStyleWord(true);
            this._operationLog.setLineWrap(true);
            this._operationLog.setEditable(false);
            this._operationLogScroller = new JScrollPane(this._operationLog);
            this._operationLogScroller.setVerticalScrollBarPolicy(22);
            new SmartScroller(this._operationLogScroller).attach();
            ImportDialog.this._selectionPanel.add((Component)this._operationLogScroller, "w 400:400:, hmin 60, growy, growx");
            this._progressBar = new JProgressBar();
            this._progressBar.setString("Preparing to analyze source directory...");
            this._progressBar.setStringPainted(true);
            ImportDialog.this._selectionPanel.add((Component)this._progressBar, "w 100%!");
            this._operationLogUpdater = new _OperationLogAsyncUpdater(this._selections, this._operationLog);
            this._operationLogUpdater.start();
            this._updateUI();
            ImportDialog.this._selectionPanel.getParent().validate();
            ImportDialog.this._selectionPanel.getParent().invalidate();
        }

        private void _addSelectionWidget(JPanel parent, ImportSourceAnalyzer.OpType type, String name) {
            this._addSelectionWidget(parent, type, name, true, null, null);
        }

        private void _addSelectionWidget(JPanel parent, ImportSourceAnalyzer.OpType type, String name, boolean selected, String tooltip, String constraints) {
            FCheckBox cb = new FCheckBox();
            cb.setName(name);
            cb.setSelected(selected);
            cb.setToolTipText(tooltip);
            cb.addChangeListener(this._stateChangedListener);
            this._selections.put(type, Pair.of(cb, new ConcurrentSkipListMap()));
            parent.add((Component)cb, constraints);
        }

        private void _updateUI() {
            HashSet<ImportSourceAnalyzer.OpType> selectedOptions = new HashSet<ImportSourceAnalyzer.OpType>();
            for (Map.Entry<ImportSourceAnalyzer.OpType, Pair<FCheckBox, ? extends Map<File, File>>> entry : this._selections.entrySet()) {
                Pair<FCheckBox, ? extends Map<File, File>> selection = entry.getValue();
                FCheckBox cb = selection.getLeft();
                if (cb.isSelected()) {
                    selectedOptions.add(entry.getKey());
                }
                cb.setText(TextUtil.concatWithSpace(cb.getName(), TextUtil.enclosedParen(String.valueOf(selection.getRight().size()))));
            }
            this._operationLogUpdater.requestUpdate(selectedOptions, this._unknownDeckCombo.getSelectedItem(), this._moveCheckbox.isSelected(), this._overwriteCheckbox.isSelected());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doInBackground() {
            Timer timer = null;
            try {
                HashMap<ImportSourceAnalyzer.OpType, Map<File, File>> selections = new HashMap<ImportSourceAnalyzer.OpType, Map<File, File>>();
                for (Map.Entry<ImportSourceAnalyzer.OpType, Pair<FCheckBox, ? extends Map<File, File>>> entry : this._selections.entrySet()) {
                    selections.put(entry.getKey(), entry.getValue().getRight());
                }
                ImportSourceAnalyzer.AnalysisCallback cb = new ImportSourceAnalyzer.AnalysisCallback(){

                    @Override
                    public boolean checkCancel() {
                        return ImportDialog.this._cancel;
                    }

                    @Override
                    public void addOp(ImportSourceAnalyzer.OpType type, File src, File dest) {
                        ((Map)((Pair)_AnalyzerUpdater.this._selections.get((Object)type)).getRight()).put(src, dest);
                    }
                };
                ImportSourceAnalyzer msa = new ImportSourceAnalyzer(this._srcDir, cb);
                int numFilesToAnalyze = msa.getNumFilesToAnalyze();
                timer = new Timer(500, null);
                timer.setInitialDelay(100);
                Timer finalTimer = timer;
                timer.addActionListener(arg0 -> {
                    if (ImportDialog.this._cancel) {
                        finalTimer.stop();
                        return;
                    }
                    this._progressBar.setValue(msa.getNumFilesAnalyzed());
                    this._updateUI();
                    ImportDialog.this._selectionPanel.getParent().validate();
                    ImportDialog.this._selectionPanel.getParent().invalidate();
                });
                SwingUtilities.invokeLater(() -> {
                    if (ImportDialog.this._cancel) {
                        return;
                    }
                    this._progressBar.setString("Analyzing...");
                    this._progressBar.setMaximum(numFilesToAnalyze);
                    this._progressBar.setValue(0);
                    this._progressBar.setIndeterminate(false);
                    finalTimer.start();
                });
                msa.doAnalysis();
            }
            catch (Exception e) {
                ImportDialog.this._cancel = true;
                SwingUtilities.invokeLater(() -> {
                    this._progressBar.setString("Error");
                    BugReporter.reportException(e);
                });
            }
            finally {
                if (null != timer) {
                    timer.stop();
                }
            }
            return null;
        }

        @Override
        protected void done() {
            if (!ImportDialog.this._cancel) {
                this._progressBar.setValue(this._progressBar.getMaximum());
                this._updateUI();
                this._progressBar.setString("Analysis complete");
                for (ActionListener a : ImportDialog.this._btnStart.getActionListeners()) {
                    ImportDialog.this._btnStart.removeActionListener(a);
                }
                for (Pair pair : this._selections.values()) {
                    FCheckBox cb = (FCheckBox)pair.getLeft();
                    if (0 != ((Map)pair.getRight()).size()) continue;
                    cb.removeChangeListener(this._stateChangedListener);
                    cb.setSelected(false);
                    cb.setEnabled(false);
                }
                if (0 == this._selections.get((Object)ImportSourceAnalyzer.OpType.UNKNOWN_DECK).getRight().size()) {
                    this._unknownDeckLabel.setEnabled(false);
                    this._unknownDeckCombo.setEnabled(false);
                }
                ImportDialog.this._btnStart.addActionListener(arg0 -> {
                    if (this._isMigration) {
                        ArrayList unselectedButShouldBe = new ArrayList();
                        for (Map.Entry<ImportSourceAnalyzer.OpType, Pair<FCheckBox, ? extends Map<File, File>>> entry : this._selections.entrySet()) {
                            Pair<FCheckBox, ? extends Map<File, File>> p;
                            FCheckBox cb;
                            if (ImportSourceAnalyzer.OpType.POSSIBLE_SET_CARD_PIC == entry.getKey() || (cb = (p = entry.getValue()).getLeft()).isSelected() || 0 >= p.getRight().size()) continue;
                            unselectedButShouldBe.add(cb.getName());
                        }
                        if (!unselectedButShouldBe.isEmpty() || !this._moveCheckbox.isSelected()) {
                            StringBuilder stringBuilder = new StringBuilder("<html>");
                            if (!unselectedButShouldBe.isEmpty()) {
                                Map.Entry<ImportSourceAnalyzer.OpType, Pair<FCheckBox, ? extends Map<File, File>>> entry;
                                stringBuilder.append("It looks like the following options are not selected, which will result in an incomplete migration:");
                                stringBuilder.append("<ul>");
                                entry = unselectedButShouldBe.iterator();
                                while (entry.hasNext()) {
                                    String cbName = (String)entry.next();
                                    stringBuilder.append("<li><b>").append(cbName).append("</b></li>");
                                }
                                stringBuilder.append("</ul>");
                            }
                            if (!this._moveCheckbox.isSelected()) {
                                stringBuilder.append(unselectedButShouldBe.isEmpty() ? "It " : "It also ").append("looks like the <b>");
                                stringBuilder.append(this._moveCheckbox.getText()).append("</b> option is not selected.<br><br>");
                            }
                            stringBuilder.append("You can continue anyway, but the migration will be incomplete, and the data migration prompt<br>");
                            stringBuilder.append("will come up again the next time you start Forge in order to migrate the remaining files<br>");
                            stringBuilder.append("unless you move or delete them manually.</html>");
                            int chosen = FOptionPane.showOptionDialog(stringBuilder.toString(), "Migration warning", FOptionPane.WARNING_ICON, fixOrContinue);
                            if (chosen != 1) {
                                return;
                            }
                        }
                    }
                    ImportDialog.this._btnStart.setEnabled(false);
                    ImportDialog.this._btnChooseDir.setEnabled(false);
                    for (Pair pair : this._selections.values()) {
                        ((FCheckBox)pair.getLeft()).setEnabled(false);
                    }
                    this._unknownDeckCombo.setEnabled(false);
                    this._moveCheckbox.setEnabled(false);
                    this._overwriteCheckbox.setEnabled(false);
                    this._operationLogUpdater.requestStop();
                    JScrollBar scrollBar = this._operationLogScroller.getVerticalScrollBar();
                    scrollBar.setValue(scrollBar.getMaximum());
                    _Importer _Importer2 = new _Importer(this._srcDir, this._selections, this._unknownDeckCombo, this._operationLog, this._progressBar, this._moveCheckbox.isSelected(), this._overwriteCheckbox.isSelected());
                    _Importer2.run();
                    ImportDialog.this._btnCancel.requestFocusInWindow();
                });
                ImportDialog.this._btnStart.setEnabled(true);
            }
            this._onAnalyzerDone.run();
        }
    }

    private class _UnknownDeckChoice {
        public final String name;
        public final String path;

        public _UnknownDeckChoice(String name0, String path0) {
            this.name = name0;
            this.path = path0;
        }

        public String toString() {
            return this.name;
        }
    }
}

