/*
 * Decompiled with CFR 0.152.
 */
package forge.gui;

import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public final class GuiUtils {
    private static final int minItemWidth = 100;
    private static final int itemHeight = 25;

    private GuiUtils() {
        throw new AssertionError();
    }

    public static Font newFont(String filename) {
        File file = new File(filename);
        Font ttf = null;
        try {
            ttf = Font.createFont(0, file);
        }
        catch (FontFormatException e) {
            System.err.println("GuiUtils > newFont: bad font format \"" + filename + "\"");
        }
        catch (IOException e) {
            System.err.println("GuiUtils > newFont: can't find \"" + filename + "\"");
        }
        if ("ja-JP".equals(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_LANGUAGE)) && !ttf.canDisplay('\u936e') || "zh-CN".equals(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_LANGUAGE)) && !ttf.canDisplay('\u9e6b')) {
            ttf = new JLabel().getFont();
        }
        return ttf;
    }

    public static void setMenuItemSize(JMenuItem item) {
        item.setPreferredSize(new Dimension(Math.max(item.getPreferredSize().width, 100), 25));
    }

    public static JMenu createMenu(String label) {
        if (label.startsWith("<html>")) {
            label = "<html><div style='height: 25px; margin-top: 6px;'>" + label.substring(6, label.length() - 7) + "</div></html>";
        }
        JMenu menu = new JMenu(label);
        GuiUtils.setMenuItemSize(menu);
        return menu;
    }

    public static JMenuItem createMenuItem(String label, KeyStroke accelerator, Runnable onClick, boolean enabled, boolean bold) {
        if (label.startsWith("<html>")) {
            label = "<html><div style='height: 25px; margin-top: 6px;'>" + label.substring(6, label.length() - 7) + "</div></html>";
        }
        JMenuItem item = new JMenuItem(label);
        item.addActionListener(arg0 -> {
            if (null != onClick) {
                onClick.run();
            }
        });
        item.setEnabled(enabled);
        item.setAccelerator(accelerator);
        if (bold) {
            item.setFont(item.getFont().deriveFont(1));
        }
        GuiUtils.setMenuItemSize(item);
        return item;
    }

    public static void addMenuItem(JPopupMenu parent, String label, KeyStroke accelerator, Runnable onClick) {
        parent.add(GuiUtils.createMenuItem(label, accelerator, onClick, true, false));
    }

    public static void addMenuItem(JMenuItem parent, String label, KeyStroke accelerator, Runnable onClick) {
        parent.add(GuiUtils.createMenuItem(label, accelerator, onClick, true, false));
    }

    public static void addMenuItem(JPopupMenu parent, String label, KeyStroke accelerator, Runnable onClick, boolean enabled) {
        parent.add(GuiUtils.createMenuItem(label, accelerator, onClick, enabled, false));
    }

    public static void addMenuItem(JMenuItem parent, String label, KeyStroke accelerator, Runnable onClick, boolean enabled) {
        parent.add(GuiUtils.createMenuItem(label, accelerator, onClick, enabled, false));
    }

    public static void addMenuItem(JPopupMenu parent, String label, KeyStroke accelerator, Runnable onClick, boolean enabled, boolean bold) {
        parent.add(GuiUtils.createMenuItem(label, accelerator, onClick, enabled, bold));
    }

    public static void addMenuItem(JMenuItem parent, String label, KeyStroke accelerator, Runnable onClick, boolean enabled, boolean bold) {
        parent.add(GuiUtils.createMenuItem(label, accelerator, onClick, enabled, bold));
    }

    public static void addSeparator(JPopupMenu parent) {
        parent.add(new JSeparator());
    }

    public static void addSeparator(JMenuItem parent) {
        parent.add(new JSeparator());
    }
}

