/*
 * Decompiled with CFR 0.152.
 */
package forge.gui;

import com.google.common.collect.ImmutableList;
import forge.game.card.CardView;
import forge.gui.FThreads;
import forge.screens.match.CMatchUI;
import forge.toolbox.FOptionPane;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.apache.commons.lang3.StringUtils;

public class GuiDialog {
    private static final ImmutableList<String> defaultConfirmOptions = ImmutableList.of("Yes", "No");

    public static boolean confirm(CardView c, String question, boolean defaultIsYes, List<String> options, CMatchUI matchUI) {
        Callable<Boolean> confirmTask = () -> {
            if (matchUI != null && c != null) {
                matchUI.setCard(c);
            }
            String title = c == null ? "Question" : c + " - Ability";
            String questionToUse = StringUtils.isBlank(question) ? "Activate card's ability?" : question;
            List<String> opts = options == null ? defaultConfirmOptions : options;
            int answer = FOptionPane.showOptionDialog(questionToUse, title, FOptionPane.QUESTION_ICON, opts, defaultIsYes ? 0 : 1);
            return answer == 0;
        };
        FutureTask<Boolean> future = new FutureTask<Boolean>(confirmTask);
        FThreads.invokeInEdtAndWait(future);
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return false;
        }
    }
}

