/*
 * Decompiled with CFR 0.152.
 */
package forge.gui;

import com.google.common.base.Function;
import forge.card.CardStateName;
import forge.card.ICardFace;
import forge.game.card.Card;
import forge.game.card.CardFaceView;
import forge.game.card.CardView;
import forge.gui.DualListBox;
import forge.gui.FThreads;
import forge.gui.ListChooser;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.model.FModel;
import forge.screens.match.CMatchUI;
import forge.toolbox.FList;
import forge.toolbox.FOptionPane;
import forge.util.Localizer;
import forge.view.arcane.ListCardArea;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.commons.lang3.StringUtils;

public class GuiChoose {
    public static <T> T oneOrNone(String message, T[] choices) {
        if (choices == null || choices.length == 0) {
            return null;
        }
        List<T> choice = GuiChoose.getChoices(message, 0, 1, choices);
        return choice.isEmpty() ? null : (T)choice.get(0);
    }

    public static <T> T oneOrNone(String message, Collection<T> choices) {
        if (choices == null || choices.isEmpty()) {
            return null;
        }
        List<T> choice = GuiChoose.getChoices(message, 0, 1, choices);
        return choice.isEmpty() ? null : (T)choice.get(0);
    }

    public static Integer getInteger(String message, int min2, int max) {
        if (max <= min2) {
            return min2;
        }
        if (max == Integer.MAX_VALUE) {
            return GuiChoose.getInteger(message, min2, max, min2 + 99);
        }
        int count = max - min2 + 1;
        if (count > 100) {
            return GuiChoose.getInteger(message, min2, max, min2 + 99);
        }
        Integer[] choices = new Integer[count];
        for (int i = 0; i < count; ++i) {
            choices[i] = i + min2;
        }
        return GuiChoose.oneOrNone(message, choices);
    }

    public static Integer getInteger(String message, int min2, int max, int cutoff) {
        int val;
        String str;
        Localizer localizer = Localizer.getInstance();
        if (max <= min2 || cutoff < min2) {
            return min2;
        }
        if (cutoff >= max) {
            return GuiChoose.getInteger(message, min2, max);
        }
        ArrayList<Object> choices = new ArrayList<Object>();
        for (int i = min2; i <= cutoff; ++i) {
            choices.add(i);
        }
        choices.add(Localizer.getInstance().getMessage("lblOtherInteger", new Object[0]));
        Object choice = GuiChoose.oneOrNone(message, choices);
        if (choice instanceof Integer || choice == null) {
            return (Integer)choice;
        }
        String prompt = "";
        if (min2 != Integer.MIN_VALUE) {
            prompt = max != Integer.MAX_VALUE ? localizer.getMessage("lblEnterNumberBetweenMinAndMax", String.valueOf(min2), String.valueOf(max)) : localizer.getMessage("lblEnterNumberGreaterThanOrEqualsToMin", String.valueOf(min2));
        } else if (max != Integer.MAX_VALUE) {
            prompt = localizer.getMessage("lblEnterNumberLessThanOrEqualsToMax", String.valueOf(max));
        }
        do {
            if ((str = FOptionPane.showInputDialog(prompt, message)) != null) continue;
            return null;
        } while (!StringUtils.isNumeric(str) || (val = Integer.parseInt(str)) < min2 || val > max);
        return val;
    }

    public static <T> List<T> getChoices(String message, int min2, int max, T[] choices) {
        return GuiChoose.getChoices(message, min2, max, Arrays.asList(choices), null, null);
    }

    public static <T> List<T> getChoices(String message, int min2, int max, Collection<T> choices) {
        return GuiChoose.getChoices(message, min2, max, choices, null, null);
    }

    public static <T> List<T> getChoices(String message, int min2, int max, Collection<T> choices, T selected, Function<T, String> display) {
        return GuiChoose.getChoices(message, min2, max, choices, selected, display, null);
    }

    public static <T> List<T> getChoices(String message, int min2, int max, Collection<T> choices, T selected, Function<T, String> display, CMatchUI matchUI) {
        if (choices == null || choices.isEmpty()) {
            if (min2 == 0) {
                return new ArrayList();
            }
            throw new RuntimeException("choice required from empty list");
        }
        Callable<List> showChoice = () -> {
            ListChooser<Object> c = new ListChooser<Object>(message, min2, max, choices, display);
            FList list = c.getLstChoices();
            if (matchUI != null) {
                list.addListSelectionListener(ev -> {
                    Object sel = list.getSelectedValue();
                    if (sel instanceof InventoryItem) {
                        matchUI.setCard((InventoryItem)list.getSelectedValue());
                        return;
                    }
                    if (sel instanceof ICardFace || sel instanceof CardFaceView) {
                        String faceName = sel instanceof ICardFace ? ((ICardFace)sel).getName() : ((CardFaceView)sel).getOracleName();
                        PaperCard paper = FModel.getMagicDb().getCommonCards().getUniqueByName(faceName);
                        if (paper == null) {
                            paper = FModel.getMagicDb().getVariantCards().getUniqueByName(faceName);
                        }
                        if (paper != null) {
                            Card c1 = Card.getCardForUi(paper);
                            boolean foundState = false;
                            for (CardStateName cs : c1.getStates()) {
                                if (!c1.getState(cs).getName().equals(faceName)) continue;
                                foundState = true;
                                c1.setState(cs, true);
                                matchUI.setCard(c1.getView());
                                break;
                            }
                            if (!foundState) {
                                matchUI.setCard(paper);
                            }
                        }
                        return;
                    }
                    CardView card = sel instanceof CardView.CardStateView ? ((CardView.CardStateView)sel).getCard() : (sel instanceof CardView ? (CardView)sel : (sel instanceof Card ? CardView.get((Card)sel) : null));
                    matchUI.setCard(card);
                    matchUI.clearPanelSelections();
                    matchUI.setPanelSelection(card);
                });
            }
            if (selected != null) {
                c.show(selected);
            } else {
                c.show();
            }
            if (matchUI != null) {
                matchUI.clearPanelSelections();
            }
            return c.getSelectedValues();
        };
        FutureTask<List> future = new FutureTask<List>(showChoice);
        FThreads.invokeInEdtAndWait(future);
        try {
            return future.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends Comparable<? super T>> List<T> sideboard(CMatchUI matchUI, List<T> sideboard, List<T> deck, String message) {
        Collections.sort(deck);
        Collections.sort(sideboard);
        return GuiChoose.order(Localizer.getInstance().getMessage("lblSideboardForPlayer", message), Localizer.getInstance().getMessage("ttMain", new Object[0]), -1, -1, sideboard, deck, null, true, matchUI);
    }

    public static <T> List<T> order(String title, String top, int remainingObjectsMin, int remainingObjectsMax, List<T> sourceChoices, List<T> destChoices) {
        return GuiChoose.order(title, top, remainingObjectsMin, remainingObjectsMax, sourceChoices, destChoices, null, false, null);
    }

    public static <T> List<T> order(String title, String top, int remainingObjectsMin, int remainingObjectsMax, List<T> sourceChoices, List<T> destChoices, CardView referenceCard, boolean sideboardingMode, CMatchUI matchUI) {
        Callable<List> callable = () -> {
            DualListBox dual = new DualListBox(remainingObjectsMin, remainingObjectsMax, sourceChoices, destChoices, matchUI);
            dual.setSecondColumnLabelText(top);
            dual.setSideboardMode(sideboardingMode);
            dual.setTitle(title);
            dual.pack();
            dual.setDefaultCloseOperation(0);
            if (matchUI != null && referenceCard != null) {
                matchUI.setCard(referenceCard);
            }
            dual.setVisible(true);
            List objects = dual.getOrderedList();
            dual.dispose();
            if (matchUI != null) {
                matchUI.clearPanelSelections();
            }
            return objects;
        };
        FutureTask<List> ft = new FutureTask<List>(callable);
        FThreads.invokeInEdtAndWait(ft);
        try {
            return ft.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<CardView> manipulateCardList(final CMatchUI gui, final String title, final Iterable<CardView> cards, final Iterable<CardView> manipulable, final boolean toTop, final boolean toBottom, final boolean toAnywhere) {
        gui.setSelectables(manipulable);
        Callable<List<CardView>> callable = new Callable<List<CardView>>(){

            @Override
            public List<CardView> call() {
                ListCardArea tempArea = ListCardArea.show(gui, title, cards, manipulable, toTop, toBottom, toAnywhere);
                tempArea.setVisible(true);
                return tempArea.getCards();
            }
        };
        FutureTask<List<CardView>> ft = new FutureTask<List<CardView>>(callable);
        FThreads.invokeInEdtAndWait(ft);
        gui.clearSelectables();
        try {
            List<CardView> result = ft.get();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

