/*
 * Decompiled with CFR 0.152.
 */
package forge.gui;

import forge.gui.GuiBase;
import forge.util.ThreadUtil;

public class FThreads {
    private static int backgroundThreadCount;

    private FThreads() {
    }

    public static void assertExecutedByEdt(boolean mustBeEDT) {
        if (GuiBase.isNetworkplay()) {
            return;
        }
        if (FThreads.isGuiThread() != mustBeEDT) {
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            String methodName = trace[2].getClassName() + "." + trace[2].getMethodName();
            String modalOperator = mustBeEDT ? " must be" : " may not be";
            throw new IllegalStateException(methodName + modalOperator + " accessed from the event dispatch thread.");
        }
    }

    public static void invokeInEdtLater(Runnable proc) {
        GuiBase.getInterface().invokeInEdtLater(proc);
    }

    public static void invokeInEdtNowOrLater(Runnable proc) {
        if (FThreads.isGuiThread()) {
            GuiBase.getInterface().invokeInEdtNow(proc);
        } else {
            GuiBase.getInterface().invokeInEdtLater(proc);
        }
    }

    public static void invokeInEdtAndWait(Runnable proc) {
        GuiBase.getInterface().invokeInEdtAndWait(proc);
    }

    public static void invokeInBackgroundThread(Runnable proc) {
        new Thread(proc, "Game BT" + backgroundThreadCount).start();
        ++backgroundThreadCount;
    }

    public static boolean isGuiThread() {
        return GuiBase.getInterface().isGuiThread();
    }

    public static void delayInEDT(int milliseconds, Runnable inputUpdater) {
        Runnable runInEdt = () -> FThreads.invokeInEdtNowOrLater(inputUpdater);
        ThreadUtil.delay(milliseconds, runInEdt);
    }

    public static String debugGetCurrThreadId() {
        return FThreads.isGuiThread() ? "EDT" : Thread.currentThread().getName();
    }

    public static String debugGetStackTraceItem(int depth, boolean shorter) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        String lastItem = trace[depth].toString();
        if (shorter) {
            int lastPeriod = lastItem.lastIndexOf(46);
            lastPeriod = lastItem.lastIndexOf(46, lastPeriod - 1);
            lastPeriod = lastItem.lastIndexOf(46, lastPeriod - 1);
            lastItem = lastItem.substring(lastPeriod + 1);
            return String.format("%s > from %s", FThreads.debugGetCurrThreadId(), lastItem);
        }
        return String.format("%s > %s called from %s", FThreads.debugGetCurrThreadId(), trace[2].getClassName() + "." + trace[2].getMethodName(), lastItem);
    }

    public static String debugGetStackTraceItem(int depth) {
        return FThreads.debugGetStackTraceItem(depth, false);
    }
}

