/*
 * Decompiled with CFR 0.152.
 */
package forge.gui;

import forge.Singletons;
import forge.gamemodes.net.ChatMessage;
import forge.gamemodes.net.IOnlineChatInterface;
import forge.gamemodes.net.IRemote;
import forge.gamemodes.net.event.MessageEvent;
import forge.gui.framework.SDisplayUtil;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.home.online.OnlineMenu;
import forge.toolbox.FLabel;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.toolbox.FTextArea;
import forge.toolbox.FTextField;
import forge.toolbox.SmartScroller;
import forge.util.Localizer;
import forge.view.FDialog;
import forge.view.FFrame;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public enum FNetOverlay implements IOnlineChatInterface
{
    SINGLETON_INSTANCE;

    private static final String COORD_DELIM = ",";
    private final ForgePreferences prefs = FModel.getPreferences();
    private boolean hasBeenShown;
    private boolean locLoaded;
    private final FDialog window = new FDialog(false, true, "0"){

        @Override
        public void setLocationRelativeTo(Component c) {
            if (FNetOverlay.this.hasBeenShown || FNetOverlay.this.locLoaded) {
                return;
            }
            super.setLocationRelativeTo(c);
        }

        @Override
        public void setVisible(boolean b0) {
            if (this.isVisible() == b0) {
                return;
            }
            if (!b0 && FNetOverlay.this.hasBeenShown) {
                FNetOverlay.this.prefs.setPref(ForgePreferences.FPref.CHAT_WINDOW_LOC, this.getX() + FNetOverlay.COORD_DELIM + this.getY() + FNetOverlay.COORD_DELIM + this.getWidth() + FNetOverlay.COORD_DELIM + this.getHeight());
                FNetOverlay.this.prefs.save();
            }
            super.setVisible(b0);
            if (b0) {
                FNetOverlay.this.hasBeenShown = true;
            }
            OnlineMenu.chatItem.setState(b0);
        }
    };
    private final FTextArea txtLog = new FTextArea();
    private final FTextField txtInput = new FTextField.Builder().maxLength(255).build();
    private final FLabel cmdSend = new FLabel.ButtonBuilder().text(Localizer.getInstance().getMessage("lblSend", new Object[0])).build();
    private int height = 140;
    private int width = 400;
    private IRemote remote = null;
    private final ActionListener onSend = e -> {
        String message = this.txtInput.getText();
        this.txtInput.setText("");
        if (StringUtils.isBlank(message)) {
            return;
        }
        if (this.remote != null) {
            this.remote.send(new MessageEvent(this.prefs.getPref(ForgePreferences.FPref.PLAYER_NAME), message));
        }
    };

    public FDialog getWindow() {
        return this.window;
    }

    @Override
    public void setGameClient(IRemote remote) {
        this.remote = remote;
    }

    public FTextField getTxtInput() {
        return this.txtInput;
    }

    private FNetOverlay() {
        this.window.setTitle(Localizer.getInstance().getMessage("lblChat", new Object[0]));
        this.window.setVisible(false);
        this.window.setBackground(FSkin.getColor(FSkin.Colors.CLR_ZEBRA));
        this.window.setBorder(new FSkin.LineSkinBorder(FSkin.getColor(FSkin.Colors.CLR_BORDERS)));
        this.window.setLayout(new MigLayout("insets 0, gap 0, ax center, wrap 2"));
        this.txtLog.setOpaque(true);
        this.txtLog.setFocusable(true);
        this.txtLog.setBackground(FSkin.getColor(FSkin.Colors.CLR_ZEBRA));
        FScrollPane _operationLogScroller = new FScrollPane(this.txtLog, false);
        _operationLogScroller.setVerticalScrollBarPolicy(22);
        new SmartScroller(_operationLogScroller).attach();
        this.window.add((Component)_operationLogScroller, "pushx, hmin 24, pushy, growy, growx, gap 2px 2px 2px 0, sx 2");
        this.window.add((Component)this.txtInput, "pushx, growx, h 26px!, gap 2px 2px 2px 0");
        this.window.add((Component)this.cmdSend, "w 60px!, h 28px!, gap 0 0 2px 0");
        this.txtInput.addActionListener(this.onSend);
        this.cmdSend.setCommand(() -> this.onSend.actionPerformed(null));
    }

    public void reset() {
        this.setGameClient(null);
        this.txtLog.setText("");
        this.hide();
    }

    public void hide() {
        this.window.setVisible(false);
    }

    public void show() {
        this.show(null);
    }

    public void show(ChatMessage message) {
        if (!this.hasBeenShown) {
            this.hasBeenShown = true;
            this.loadLocation();
            this.window.getTitleBar().addMouseListener(new FMouseAdapter(){

                @Override
                public void onLeftDoubleClick(MouseEvent e) {
                    FNetOverlay.this.window.setVisible(false);
                }
            });
        }
        if (message != null) {
            this.txtLog.setText(message.getFormattedMessage());
        }
        this.window.setVisible(true);
    }

    private void loadLocation() {
        String value = this.prefs.getPref(ForgePreferences.FPref.CHAT_WINDOW_LOC);
        if (value.length() > 0) {
            String[] coords = value.split(COORD_DELIM);
            if (coords.length == 4) {
                try {
                    int x = Integer.parseInt(coords[0]);
                    int y = Integer.parseInt(coords[1]);
                    int w = Integer.parseInt(coords[2]);
                    int h2 = Integer.parseInt(coords[3]);
                    int centerX = x + w / 2;
                    int centerY = y + h2 / 2;
                    Rectangle screenBounds = SDisplayUtil.getScreenBoundsForPoint(new Point(centerX, centerY));
                    if (centerX < screenBounds.x) {
                        x = screenBounds.x;
                    } else if (centerX > screenBounds.x + screenBounds.width && (x = screenBounds.x + screenBounds.width - w) < screenBounds.x) {
                        x = screenBounds.x;
                    }
                    if (centerY < screenBounds.y) {
                        y = screenBounds.y;
                    } else if (centerY > screenBounds.y + screenBounds.height && (y = screenBounds.y + screenBounds.height - h2) < screenBounds.y) {
                        y = screenBounds.y;
                    }
                    this.window.setBounds(x, y, w, h2);
                    this.locLoaded = true;
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.prefs.setPref(ForgePreferences.FPref.CHAT_WINDOW_LOC, "");
            this.prefs.save();
        }
        FFrame mainFrame = Singletons.getView().getFrame();
        int w = Math.max(this.width, (int)((float)mainFrame.getWidth() * 0.25f));
        int x = mainFrame.getWidth() - w;
        int y = mainFrame.getHeight() - this.height;
        this.window.setBounds(x, y, w, this.height);
    }

    @Override
    public void addMessage(ChatMessage message) {
        this.txtLog.append("\n" + message.getFormattedMessage());
    }
}

