/*
 * Decompiled with CFR 0.152.
 */
package forge.gui;

import forge.Singletons;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.spellability.SpellAbilityView;
import forge.game.trigger.WrappedAbility;
import forge.gui.UnsortedListModel;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.screens.match.CMatchUI;
import forge.toolbox.FButton;
import forge.toolbox.FLabel;
import forge.toolbox.FList;
import forge.toolbox.FPanel;
import forge.toolbox.FScrollPane;
import forge.util.Localizer;
import forge.view.FDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DualListBox<T>
extends FDialog {
    private final FList<T> sourceList;
    private final UnsortedListModel<T> sourceListModel;
    private final FList<T> destList;
    private final UnsortedListModel<T> destListModel;
    private final FButton addButton;
    private final FButton addAllButton;
    private final FButton removeButton;
    private final FButton removeAllButton;
    private final FButton okButton;
    private final FButton autoButton;
    private final FLabel orderedLabel;
    private final FLabel selectOrder;
    private final int targetRemainingSourcesMin;
    private final int targetRemainingSourcesMax;
    private boolean sideboardingMode = false;
    private boolean showCard = true;
    private final CMatchUI matchUI;

    public DualListBox(int remainingSourcesMin, int remainingSourcesMax, List<T> sourceElements, List<T> destElements, CMatchUI matchUI) {
        this.matchUI = matchUI;
        this.targetRemainingSourcesMin = remainingSourcesMin;
        this.targetRemainingSourcesMax = remainingSourcesMax;
        this.sourceListModel = new UnsortedListModel();
        this.sourceList = new FList<T>(this.sourceListModel);
        this.destListModel = new UnsortedListModel();
        this.destList = new FList<T>(this.destListModel);
        final Runnable onAdd = new Runnable(){

            @Override
            public void run() {
                if (!DualListBox.this.addButton.isEnabled()) {
                    return;
                }
                ArrayList selected = new ArrayList();
                for (Object item : DualListBox.this.sourceList.getSelectedValuesList()) {
                    selected.add(item);
                }
                DualListBox.this.addDestinationElements(selected);
                DualListBox.this.clearSourceSelected();
                DualListBox.this.sourceList.validate();
                DualListBox.this._setButtonState();
            }
        };
        final Runnable onRemove = new Runnable(){

            @Override
            public void run() {
                if (!DualListBox.this.removeButton.isEnabled()) {
                    return;
                }
                ArrayList selected = new ArrayList();
                for (Object item : DualListBox.this.destList.getSelectedValuesList()) {
                    selected.add(item);
                }
                DualListBox.this.clearDestinationSelected();
                DualListBox.this.addSourceElements(selected);
                DualListBox.this._setButtonState();
            }
        };
        this.sourceList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                DualListBox.this._handleListKey(e, onAdd, DualListBox.this.destList);
            }
        });
        this.sourceList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (1 == e.getButton() && 2 == e.getClickCount()) {
                    onAdd.run();
                }
            }
        });
        this.destList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                DualListBox.this._handleListKey(e, onRemove, DualListBox.this.sourceList);
            }
        });
        this.destList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (1 == e.getButton() && 2 == e.getClickCount()) {
                    onRemove.run();
                }
            }
        });
        this.addButton = new FButton(">");
        this.addButton.addActionListener(e -> onAdd.run());
        this.addAllButton = new FButton(">>");
        this.addAllButton.addActionListener(e -> this._addAll());
        this.removeButton = new FButton("<");
        this.removeButton.addActionListener(e -> onRemove.run());
        this.removeAllButton = new FButton("<<");
        this.removeAllButton.addActionListener(e -> this._removeAll());
        this.okButton = new FButton(Localizer.getInstance().getMessage("lblOK", new Object[0]));
        this.okButton.addActionListener(e -> this._finish());
        this.autoButton = new FButton(Localizer.getInstance().getMessage("lblAuto", new Object[0]));
        this.autoButton.addActionListener(e -> {
            this._addAll();
            this._finish();
        });
        FPanel leftPanel = new FPanel(new BorderLayout());
        this.selectOrder = new FLabel.Builder().text(Localizer.getInstance().getMessage("lblSelectOrder", new Object[0]) + ":").build();
        leftPanel.add((Component)this.selectOrder, "North");
        leftPanel.add((Component)new FScrollPane(this.sourceList, true), "Center");
        leftPanel.add((Component)this.okButton, "South");
        FPanel centerPanel = new FPanel(new GridLayout(6, 1));
        centerPanel.setBorderToggle(false);
        JPanel emptyPanel = new JPanel();
        emptyPanel.setOpaque(false);
        centerPanel.add(emptyPanel);
        centerPanel.add(this.addButton);
        centerPanel.add(this.addAllButton);
        centerPanel.add(this.removeButton);
        centerPanel.add(this.removeAllButton);
        this.orderedLabel = new FLabel.Builder().build();
        FPanel rightPanel = new FPanel(new BorderLayout());
        rightPanel.add((Component)this.orderedLabel, "North");
        rightPanel.add((Component)new FScrollPane(this.destList, true), "Center");
        rightPanel.add((Component)this.autoButton, "South");
        this._addListListeners(this.sourceList);
        this._addListListeners(this.destList);
        if (destElements != null && !destElements.isEmpty()) {
            this.addDestinationElements(destElements);
            SwingUtilities.invokeLater(() -> this.destList.setSelectedIndex(0));
        }
        if (sourceElements != null && !sourceElements.isEmpty()) {
            this.addSourceElements(sourceElements);
            SwingUtilities.invokeLater(() -> this.sourceList.setSelectedIndex(0));
        }
        int columnWidth = this.getColumnWidth();
        String listConstraints = "w " + columnWidth + ", h 300";
        this.add((Component)leftPanel, listConstraints);
        this.add((Component)centerPanel, "w 100, h 300");
        this.add((Component)rightPanel, listConstraints);
        this._setButtonState();
        if (remainingSourcesMin <= sourceElements.size() && remainingSourcesMax >= sourceElements.size()) {
            SwingUtilities.invokeLater(this.okButton::requestFocusInWindow);
        }
    }

    private int getMaxElementWidth(UnsortedListModel<T> model) {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int width = 0;
        for (int i = 0; i < model.getSize(); ++i) {
            int itemWidth = metrics.stringWidth(model.getElementAt(i).toString());
            if (itemWidth <= width) continue;
            width = itemWidth;
        }
        return width;
    }

    private int getColumnWidth() {
        int maxWidth;
        int dstWidth;
        int width = 0;
        int srcWidth = this.getMaxElementWidth(this.sourceListModel);
        if (srcWidth > width) {
            width = srcWidth;
        }
        if ((dstWidth = this.getMaxElementWidth(this.destListModel)) > width) {
            width = dstWidth;
        }
        int minWidth = 250;
        if (width < 250) {
            width = 250;
        }
        if (width > (maxWidth = Singletons.getView().getFrame().getWidth() / 2 - 100)) {
            width = maxWidth;
        }
        return width;
    }

    public void setSecondColumnLabelText(String label) {
        this.orderedLabel.setText(label);
    }

    public void setSideboardMode(boolean isSideboardMode) {
        this.sideboardingMode = isSideboardMode;
        if (this.sideboardingMode) {
            this.addAllButton.setVisible(false);
            this.removeAllButton.setVisible(false);
            this.autoButton.setEnabled(false);
            this.selectOrder.setText(Localizer.getInstance().getMessage("lblSideboard", new Object[0]) + String.format(" (%d):", this.sourceListModel.getSize()));
            this.orderedLabel.setText(Localizer.getInstance().getMessage("ttMain", new Object[0]) + String.format(" (%d):", this.destListModel.getSize()));
        }
    }

    private void _handleListKey(KeyEvent e, Runnable onSpace, FList<T> arrowFocusTarget) {
        switch (e.getKeyCode()) {
            case 32: {
                onSpace.run();
                break;
            }
            case 37: 
            case 39: {
                arrowFocusTarget.requestFocusInWindow();
                break;
            }
            case 10: {
                if (this.okButton.isEnabled()) {
                    this.okButton.doClick();
                    break;
                }
                if (!this.autoButton.isEnabled()) break;
                this.autoButton.doClick();
                break;
            }
        }
    }

    public void clearSourceListModel() {
        this.sourceListModel.clear();
    }

    public void clearDestinationListModel() {
        this.destListModel.clear();
    }

    public void addSourceElements(ListModel<T> newValue) {
        this.fillListModel(this.sourceListModel, newValue);
    }

    public void setSourceElements(ListModel<T> newValue) {
        this.clearSourceListModel();
        this.addSourceElements(newValue);
    }

    public void addDestinationElements(List<T> newValue) {
        this.fillListModel(this.destListModel, newValue);
    }

    public void addDestinationElements(ListModel<T> newValue) {
        this.fillListModel(this.destListModel, newValue);
    }

    private void fillListModel(UnsortedListModel<T> model, ListModel<T> newValues) {
        model.addAll(newValues);
    }

    public void addSourceElements(List<T> newValue) {
        this.fillListModel(this.sourceListModel, newValue);
    }

    public void setSourceElements(List<T> newValue) {
        this.clearSourceListModel();
        this.addSourceElements(newValue);
    }

    private void fillListModel(UnsortedListModel<T> model, List<T> newValues) {
        model.addAll(newValues);
    }

    private void clearSourceSelected() {
        int[] selected = this.sourceList.getSelectedIndices();
        for (int i = selected.length - 1; i >= 0; --i) {
            this.sourceListModel.removeElement(selected[i]);
        }
    }

    private void clearDestinationSelected() {
        int[] selected = this.destList.getSelectedIndices();
        for (int i = selected.length - 1; i >= 0; --i) {
            this.destListModel.removeElement(selected[i]);
        }
    }

    public List<T> getOrderedList() {
        this.setVisible(false);
        return this.destListModel.model;
    }

    public List<T> getRemainingSourceList() {
        return this.sourceListModel.model;
    }

    private void showSelectedCard(Object obj) {
        Card host;
        if (!this.showCard || null == obj) {
            return;
        }
        CardView card = obj instanceof CardView ? (CardView)obj : (obj instanceof CardView.CardStateView ? ((CardView.CardStateView)obj).getCard() : (obj instanceof SpellAbilityView ? ((SpellAbilityView)obj).getHostCard() : (obj instanceof WrappedAbility ? ((host = ((WrappedAbility)obj).getHostCard()) != null ? host.getView() : null) : (obj instanceof PaperCard ? Card.getCardForUi((IPaperCard)obj).getView() : null))));
        if (this.matchUI != null) {
            this.matchUI.clearPanelSelections();
            if (card != null) {
                this.matchUI.setCard(card);
                this.matchUI.setPanelSelection(card);
            }
        }
    }

    private void _addListListeners(final FList<T> list) {
        list.getModel().addListDataListener(new ListDataListener(){
            int callCount = 0;

            @Override
            public void intervalRemoved(ListDataEvent e) {
                int callNum = ++this.callCount;
                SwingUtilities.invokeLater(() -> {
                    if (callNum != this.callCount) {
                        return;
                    }
                    ListModel model = list.getModel();
                    if (0 == model.getSize()) {
                        return;
                    }
                    int cardIdx = e.getIndex0();
                    if (model.getSize() <= cardIdx) {
                        cardIdx = model.getSize() - 1;
                    }
                    DualListBox.this.showCard = false;
                    list.setSelectedIndex(cardIdx);
                    DualListBox.this.showCard = true;
                    DualListBox.this.showSelectedCard(model.getElementAt(cardIdx));
                    if (!DualListBox.this.okButton.isEnabled()) {
                        list.requestFocusInWindow();
                    }
                });
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                SwingUtilities.invokeLater(() -> {
                    int startIdx = Math.min(e.getIndex0(), e.getIndex1());
                    int endIdx = Math.max(e.getIndex0(), e.getIndex1());
                    int[] addedIndices = new int[endIdx - startIdx + 1];
                    for (int idx = startIdx; idx <= endIdx; ++idx) {
                        addedIndices[idx - startIdx] = idx;
                    }
                    DualListBox.this.showCard = false;
                    list.setSelectedValue(list.getModel().getElementAt(Math.min(endIdx, startIdx + list.getVisibleRowCount())), true);
                    list.setSelectedIndices(addedIndices);
                    DualListBox.this.showCard = true;
                });
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
        list.addListSelectionListener(ev -> this.showSelectedCard(list.getSelectedValue()));
        list.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DualListBox.this.showSelectedCard(list.getSelectedValue());
            }
        });
    }

    private void _addAll() {
        this.addDestinationElements(this.sourceListModel);
        this.clearSourceListModel();
        this._setButtonState();
    }

    private void _removeAll() {
        this.addSourceElements(this.destListModel);
        this.clearDestinationListModel();
        this._setButtonState();
    }

    private void _setButtonState() {
        if (this.sideboardingMode) {
            this.removeAllButton.setVisible(false);
            this.addAllButton.setVisible(false);
            this.selectOrder.setText(Localizer.getInstance().getMessage("lblSideboard", new Object[0]) + String.format(" (%d):", this.sourceListModel.getSize()));
            this.orderedLabel.setText(Localizer.getInstance().getMessage("ttMain", new Object[0]) + String.format(" (%d):", this.destListModel.getSize()));
        }
        boolean anySize = this.targetRemainingSourcesMax < 0;
        boolean canAdd = this.sourceListModel.getSize() != 0 && (anySize || this.targetRemainingSourcesMin <= this.sourceListModel.getSize());
        boolean canRemove = this.destListModel.getSize() != 0;
        boolean targetReached = anySize || this.targetRemainingSourcesMin <= this.sourceListModel.getSize() && this.targetRemainingSourcesMax >= this.sourceListModel.getSize();
        this.autoButton.setEnabled(this.targetRemainingSourcesMax == 0 && !targetReached && !this.sideboardingMode);
        this.addButton.setEnabled(canAdd);
        this.addAllButton.setEnabled(canAdd);
        this.removeButton.setEnabled(canRemove);
        this.removeAllButton.setEnabled(canRemove);
        this.okButton.setEnabled(targetReached);
        if (targetReached) {
            this.okButton.requestFocusInWindow();
        }
    }

    private void _finish() {
        this.setVisible(false);
    }
}

