/*
 * Decompiled with CFR 0.152.
 */
package forge.gui;

import forge.ImageCache;
import forge.ImageKeys;
import forge.game.card.CardView;
import forge.gui.GuiBase;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.toolbox.CardFaceSymbols;
import forge.toolbox.imaging.FImagePanel;
import forge.toolbox.imaging.FImageUtil;
import forge.util.ImageFetcher;
import java.awt.BorderLayout;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import javax.swing.JPanel;
import org.apache.commons.lang3.tuple.Pair;

public final class CardPicturePanel
extends JPanel
implements ImageFetcher.Callback {
    private static final long serialVersionUID = -3160874016387273383L;
    private Object displayed;
    private boolean mayView = true;
    private final FImagePanel panel = new FImagePanel();
    private BufferedImage currentImage;

    public CardPicturePanel() {
        super(new BorderLayout());
        this.add(this.panel);
    }

    public Object getDisplayed() {
        return this.displayed;
    }

    public void setItem(InventoryItem item) {
        this.setImage(item, true);
    }

    public void setItem(BufferedImage image) {
        this.currentImage = image;
        this.panel.setImage(image, CardPicturePanel.getAutoSizeImageMode());
        this.displayed = null;
        this.mayView = false;
    }

    public void setCard(CardView.CardStateView c) {
        this.setCard(c, true);
    }

    public void setCard(CardView.CardStateView c, boolean mayView) {
        this.setImage(c, mayView);
    }

    private void setImage(Object display, boolean mayView) {
        this.displayed = display;
        this.mayView = mayView;
        BufferedImage image = this.getImage();
        if (image != null && image != this.currentImage) {
            if (this.displayed instanceof PaperCard) {
                BufferedImage displayedimage;
                ColorModel cm = image.getColorModel();
                boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
                WritableRaster raster = image.copyData(image.getRaster().createCompatibleWritableRaster());
                this.currentImage = displayedimage = new BufferedImage(cm, raster, isAlphaPremultiplied, null).getSubimage(0, 0, image.getWidth(), image.getHeight());
                this.panel.setImage(displayedimage, CardPicturePanel.getAutoSizeImageMode());
                PaperCard card = (PaperCard)this.displayed;
                if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_OVERLAY_FOIL_EFFECT) && card.isFoil()) {
                    CardFaceSymbols.drawOther(displayedimage.getGraphics(), String.format("foil%02d", 1), 0, 0, displayedimage.getWidth(), displayedimage.getHeight());
                }
            } else {
                this.currentImage = image;
                this.panel.setImage(image, CardPicturePanel.getAutoSizeImageMode());
            }
        }
    }

    private BufferedImage getImage() {
        if (!this.mayView) {
            return ImageCache.getOriginalImage(ImageKeys.getTokenKey("hidden"), true, null);
        }
        if (this.displayed instanceof InventoryItem) {
            InventoryItem item = (InventoryItem)this.displayed;
            Pair<BufferedImage, Boolean> originalImageInfo = ImageCache.getCardOriginalImageInfo(item.getImageKey(false), true);
            BufferedImage image = originalImageInfo.getLeft();
            boolean isPlaceHolderImage = originalImageInfo.getRight();
            if ((ImageCache.isDefaultImage(image) || isPlaceHolderImage) && item instanceof PaperCard) {
                GuiBase.getInterface().getImageFetcher().fetchImage(item.getImageKey(false), this);
            }
            return image;
        }
        if (this.displayed instanceof CardView.CardStateView) {
            CardView.CardStateView card = (CardView.CardStateView)this.displayed;
            BufferedImage image = ImageCache.getOriginalImage(card.getImageKey(), false, card.getCard());
            if (image == null) {
                GuiBase.getInterface().getImageFetcher().fetchImage(card.getImageKey(), this);
            }
            return FImageUtil.getImage((CardView.CardStateView)this.displayed);
        }
        return null;
    }

    @Override
    public void onImageFetched() {
        this.setImage(this.displayed, this.mayView);
        this.repaint();
    }

    private static FImagePanel.AutoSizeImageMode getAutoSizeImageMode() {
        return CardPicturePanel.isUIScaleLarger() ? FImagePanel.AutoSizeImageMode.PANEL : FImagePanel.AutoSizeImageMode.SOURCE;
    }

    private static boolean isUIScaleLarger() {
        return FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_SCALE_LARGER);
    }

    public void showAsDisabled() {
        this.panel.setAlpha(0.5f);
    }

    public void showAsEnabled() {
        this.panel.setAlpha(0.0f);
    }
}

