/*
 * Decompiled with CFR 0.152.
 */
package forge.gui;

import forge.game.card.CardView;
import forge.gui.CardDetailPanel;
import forge.gui.CardPicturePanel;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.toolbox.FButton;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.util.Localizer;
import forge.view.FDialog;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CardListViewer
extends FDialog {
    private final List<PaperCard> list;
    private final JList<PaperCard> jList;
    private final CardDetailPanel detail;
    private final CardPicturePanel picture;

    public CardListViewer(String title, List<PaperCard> list) {
        this(title, "", list, null);
    }

    public CardListViewer(String title, String message, List<PaperCard> list) {
        this(title, message, list, null);
    }

    public CardListViewer(String title, String message, List<PaperCard> list, Icon dialogIcon) {
        this.list = Collections.unmodifiableList(list);
        this.jList = new JList<PaperCard>(new ChooserListModel());
        this.detail = new CardDetailPanel();
        this.picture = new CardPicturePanel();
        this.picture.setOpaque(false);
        this.setTitle(title);
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_LARGE_CARD_VIEWERS)) {
            this.setSize(1200, 825);
        } else {
            this.setSize(720, 374);
        }
        this.addWindowFocusListener(new CardListFocuser());
        FButton btnOK = new FButton(Localizer.getInstance().getMessage("lblOK", new Object[0]));
        btnOK.addActionListener(e -> this.processWindowEvent(new WindowEvent(this, 201)));
        this.add((Component)new FLabel.Builder().text(message).build(), "cell 0 0, spanx 3, gapbottom 4");
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_LARGE_CARD_VIEWERS)) {
            this.add((Component)new FScrollPane(this.jList, true), "cell 0 1, w 225, h 450, ax c");
            this.add((Component)this.picture, "cell 1 1, w 480, growy, pushy, ax c");
            this.add((Component)this.detail, "cell 2 1, w 320, h 500, ax c");
            this.add((Component)btnOK, "cell 1 2, w 150, h 40, ax c, gaptop 6");
        } else {
            this.add((Component)new FScrollPane(this.jList, true), "cell 0 1, w 225, growy, pushy, ax c");
            this.add((Component)this.picture, "cell 1 1, w 225, growy, pushy, ax c");
            this.add((Component)this.detail, "cell 2 1, w 225, growy, pushy, ax c");
            this.add((Component)btnOK, "cell 1 2, w 150, h 26, ax c, gaptop 6");
        }
        this.jList.getSelectionModel().addListSelectionListener(new SelListener());
        this.jList.setSelectedIndex(0);
    }

    private class SelListener
    implements ListSelectionListener {
        private SelListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row = CardListViewer.this.jList.getSelectedIndex();
            if (row >= 0 && row < CardListViewer.this.list.size()) {
                PaperCard cp = (PaperCard)CardListViewer.this.list.get(row);
                CardListViewer.this.detail.setCard(CardView.getCardForUi(cp));
                CardListViewer.this.picture.setItem(cp);
            }
        }
    }

    private class CardListFocuser
    implements WindowFocusListener {
        private CardListFocuser() {
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            CardListViewer.this.jList.grabFocus();
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
        }
    }

    private class ChooserListModel
    extends AbstractListModel<PaperCard> {
        private static final long serialVersionUID = 3871965346333840556L;

        private ChooserListModel() {
        }

        @Override
        public int getSize() {
            return CardListViewer.this.list.size();
        }

        @Override
        public PaperCard getElementAt(int index) {
            return (PaperCard)CardListViewer.this.list.get(index);
        }
    }
}

