/*
 * Decompiled with CFR 0.152.
 */
package forge.gui;

import forge.card.CardEdition;
import forge.card.CardRarity;
import forge.game.GameView;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.zone.ZoneType;
import forge.gui.card.CardDetailUtil;
import forge.item.IPaperCard;
import forge.item.InventoryItemFromSet;
import forge.model.FModel;
import forge.toolbox.FHtmlViewer;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;

public class CardDetailPanel
extends FSkin.SkinnedPanel {
    private static final long serialVersionUID = -8461473263764812323L;
    private final FLabel nameCostLabel;
    private final FLabel typeLabel;
    private final FLabel powerToughnessLabel;
    private final FLabel idLabel;
    private final JLabel setInfoLabel;
    private final FHtmlViewer cdArea;
    private final FScrollPane scrArea;
    private GameView gameView = null;

    private static Color fromDetailColor(CardDetailUtil.DetailColors detailColor) {
        return new Color(detailColor.r, detailColor.g, detailColor.b);
    }

    public CardDetailPanel() {
        this.setLayout(null);
        this.setOpaque(false);
        this.nameCostLabel = new FLabel.Builder().fontAlign(0).tooltip(Localizer.getInstance().getMessage("lblCardNameAndCost", new Object[0])).build();
        this.typeLabel = new FLabel.Builder().fontAlign(0).tooltip(Localizer.getInstance().getMessage("lblCardType", new Object[0])).build();
        this.idLabel = new FLabel.Builder().fontAlign(2).tooltip(Localizer.getInstance().getMessage("lblCardID", new Object[0])).build();
        this.powerToughnessLabel = new FLabel.Builder().fontAlign(0).tooltip(Localizer.getInstance().getMessage("lblPrimaryCharacteristic", new Object[0])).build();
        this.setInfoLabel = new JLabel();
        this.setInfoLabel.setHorizontalAlignment(0);
        Integer fontSizeR12 = FSkin.getRelativeFontSize(12);
        Integer fontSizeR14 = FSkin.getRelativeFontSize(14);
        Font font = new Font("Dialog", 0, fontSizeR14);
        this.nameCostLabel.setFont(font);
        this.typeLabel.setFont(font);
        this.idLabel.setFont(font);
        this.powerToughnessLabel.setFont(font);
        this.cdArea = new FHtmlViewer();
        this.cdArea.setFont(new Font("Dialog", 0, fontSizeR12));
        this.cdArea.setBorder(new EmptyBorder(2, 6, 2, 6));
        this.cdArea.setOpaque(false);
        this.cdArea.setFocusable(true);
        this.cdArea.getAccessibleContext().setAccessibleName("Card textbox");
        this.scrArea = new FScrollPane(this.cdArea, false);
        this.add(this.nameCostLabel);
        this.add(this.typeLabel);
        this.add(this.idLabel);
        this.add(this.setInfoLabel);
        this.add(this.powerToughnessLabel);
        this.add(this.scrArea);
    }

    public void setGameView(GameView gameView) {
        this.gameView = gameView;
    }

    @Override
    public void doLayout() {
        int insets = 3;
        int setInfoWidth = 40;
        int x = 3;
        int y = 3;
        int lineWidth = this.getWidth() - 6;
        int areaHeight = this.nameCostLabel.getPreferredSize().height;
        this.nameCostLabel.setBounds(3, y, lineWidth, areaHeight);
        y += areaHeight + 1;
        areaHeight = this.typeLabel.getPreferredSize().height;
        this.typeLabel.setBounds(3, y, lineWidth, areaHeight);
        y += areaHeight + 1;
        areaHeight = Math.max(Math.max(this.idLabel.getPreferredSize().height, this.powerToughnessLabel.getPreferredSize().height), this.setInfoLabel.getPreferredSize().height);
        this.idLabel.setBounds(3, y, this.idLabel.getAutoSizeWidth(), areaHeight);
        this.powerToughnessLabel.setBounds(3, y, lineWidth, areaHeight);
        this.setInfoLabel.setBounds(3 + lineWidth - 40 + 1, y + 1, 40, areaHeight);
        this.scrArea.setBounds(0, y += areaHeight + 1, this.getWidth(), this.getHeight() - y);
    }

    public final void setItem(InventoryItemFromSet item) {
        this.nameCostLabel.setText(item.getName());
        this.typeLabel.setVisible(false);
        this.powerToughnessLabel.setVisible(false);
        this.idLabel.setText("");
        this.cdArea.setText(CardDetailUtil.getItemDescription(item));
        this.updateBorder(item instanceof IPaperCard ? Card.getCardForUi((IPaperCard)((Object)item)).getView().getCurrentState() : null, true);
        String set = item.getEdition();
        this.setInfoLabel.setText(set);
        this.setInfoLabel.setToolTipText("");
        if (StringUtils.isEmpty(set)) {
            this.setInfoLabel.setOpaque(false);
            this.setInfoLabel.setBorder(null);
        } else {
            CardEdition edition = FModel.getMagicDb().getEditions().get(set);
            if (null != edition) {
                this.setInfoLabel.setToolTipText(edition.getName());
            }
            this.setInfoLabel.setOpaque(true);
            this.setInfoLabel.setBackground(Color.BLACK);
            this.setInfoLabel.setForeground(Color.WHITE);
            this.setInfoLabel.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        }
        SwingUtilities.invokeLater(() -> this.scrArea.getVerticalScrollBar().setValue(this.scrArea.getVerticalScrollBar().getMinimum()));
    }

    public final void setCard(CardView card) {
        this.setCard(card, true, false);
    }

    public final void setCard(CardView card, boolean mayView, boolean isInAltState) {
        CardRarity rarity;
        String set;
        String nameCost;
        CardView.CardStateView state;
        this.typeLabel.setVisible(true);
        this.powerToughnessLabel.setVisible(true);
        CardView.CardStateView cardStateView = state = card == null ? null : card.getState(isInAltState);
        if (state == null) {
            this.nameCostLabel.setText("");
            this.typeLabel.setText("");
            this.powerToughnessLabel.setText("");
            this.idLabel.setText("");
            this.setInfoLabel.setText("");
            this.setInfoLabel.setToolTipText("");
            this.setInfoLabel.setOpaque(false);
            this.setInfoLabel.setBorder(null);
            this.cdArea.setText("");
            this.updateBorder(null, false);
            return;
        }
        String name = CardDetailUtil.formatCardName(card, mayView, isInAltState);
        if (state.getManaCost().isNoCost() || !mayView) {
            nameCost = name;
        } else {
            String manaCost = card.isSplitCard() && card.hasAlternateState() && !card.isFaceDown() && card.getZone() != ZoneType.Stack && card.getZone() != ZoneType.Battlefield ? card.getLeftSplitState().getManaCost() + " // " + card.getAlternateState().getManaCost() : state.getManaCost().toString();
            nameCost = String.format("%s - %s", name, manaCost);
        }
        this.nameCostLabel.setText(FSkin.encodeSymbols(nameCost, false));
        this.typeLabel.setText(FSkin.encodeSymbols(CardDetailUtil.formatCardType(state, mayView), false));
        if (mayView) {
            set = state.getSetCode();
            rarity = state.getRarity();
        } else {
            set = CardEdition.UNKNOWN.getCode();
            rarity = CardRarity.Unknown;
        }
        this.setInfoLabel.setText(set);
        if (null != set && !set.isEmpty()) {
            if (mayView) {
                CardEdition edition = FModel.getMagicDb().getEditions().get(set);
                String setTooltip = null == edition ? rarity.name() : String.format("%s (%s)", edition.getName(), rarity.name());
                this.setInfoLabel.setToolTipText(setTooltip);
            }
            this.setInfoLabel.setOpaque(true);
            Color backColor = CardDetailPanel.fromDetailColor(CardDetailUtil.getRarityColor(rarity));
            this.setInfoLabel.setBackground(backColor);
            Color foreColor = FSkin.getHighContrastColor(backColor);
            this.setInfoLabel.setForeground(foreColor);
            this.setInfoLabel.setBorder(BorderFactory.createLineBorder(foreColor));
        }
        if (card.isFaceDown()) {
            this.updateBorder(state, false);
        } else {
            this.updateBorder(state, mayView);
        }
        this.powerToughnessLabel.setText(FSkin.encodeSymbols(CardDetailUtil.formatPrimaryCharacteristic(state, mayView), false));
        this.idLabel.setText(mayView ? CardDetailUtil.formatCardId(state) : "");
        this.cdArea.setText(FSkin.encodeSymbols(CardDetailUtil.composeCardText(state, this.gameView, mayView), true));
        SwingUtilities.invokeLater(() -> this.scrArea.getVerticalScrollBar().setValue(this.scrArea.getVerticalScrollBar().getMinimum()));
    }

    public FLabel getNameCostLabel() {
        return this.nameCostLabel;
    }

    public FLabel getTypeLabel() {
        return this.typeLabel;
    }

    public FLabel getPowerToughnessLabel() {
        return this.powerToughnessLabel;
    }

    public JLabel getSetInfoLabel() {
        return this.setInfoLabel;
    }

    public FHtmlViewer getCDArea() {
        return this.cdArea;
    }

    private void updateBorder(CardView.CardStateView card, boolean canShow) {
        if (card == null) {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.scrArea.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            return;
        }
        Color color = CardDetailPanel.fromDetailColor(CardDetailUtil.getBorderColor(card, canShow));
        this.setBorder(BorderFactory.createLineBorder(color, 2));
        this.scrArea.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, color));
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.setInfoLabel.addMouseListener(l);
        this.cdArea.addMouseListener(l);
    }
}

