/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.tournament.system;

import com.google.common.collect.Lists;
import forge.gamemodes.tournament.system.AbstractTournament;
import forge.gamemodes.tournament.system.TournamentPairing;
import forge.gamemodes.tournament.system.TournamentPlayer;
import forge.player.GamePlayerUtil;
import java.util.ArrayList;
import java.util.List;

public class TournamentRoundRobin
extends AbstractTournament {
    public TournamentRoundRobin(int ttlRnds, int pairingAmount) {
        super(ttlRnds);
        this.playersInPairing = pairingAmount;
    }

    public TournamentRoundRobin(int ttlRnds, List<TournamentPlayer> allPlayers) {
        super(ttlRnds, allPlayers);
        this.initializeTournament();
    }

    public TournamentRoundRobin(List<TournamentPlayer> allPlayers, int pairingAmount) {
        super(allPlayers.size() % 2 == 0 ? allPlayers.size() - 1 : allPlayers.size(), allPlayers);
        this.playersInPairing = pairingAmount;
    }

    @Override
    public void generateActivePairings() {
        int i;
        int numPlayers = this.remainingPlayers.size();
        ArrayList<TournamentPlayer> pair = new ArrayList<TournamentPlayer>();
        ArrayList<TournamentPlayer> roundPairings = Lists.newArrayList(this.remainingPlayers);
        if (numPlayers % 2 == 1) {
            roundPairings.add(new TournamentPlayer(GamePlayerUtil.createAiPlayer("BYE", 0)));
            ++numPlayers;
        }
        TournamentPlayer pivot = (TournamentPlayer)roundPairings.get(0);
        roundPairings.remove(0);
        for (i = 0; i < this.activeRound; ++i) {
            TournamentPlayer rotate = (TournamentPlayer)roundPairings.get(0);
            roundPairings.remove(0);
            roundPairings.add(rotate);
        }
        roundPairings.add(0, pivot);
        ++this.activeRound;
        for (i = 0; i < numPlayers / 2; ++i) {
            boolean bye = false;
            if (((TournamentPlayer)roundPairings.get(i)).getPlayer().getName().equals("BYE")) {
                bye = true;
            } else {
                pair.add((TournamentPlayer)roundPairings.get(i));
            }
            if (((TournamentPlayer)roundPairings.get(numPlayers - i - 1)).getPlayer().getName().equals("BYE")) {
                bye = true;
            } else {
                pair.add((TournamentPlayer)roundPairings.get(numPlayers - i - 1));
            }
            TournamentPairing pairing = new TournamentPairing(this.activeRound, pair);
            pairing.setBye(bye);
            this.activePairings.add(pairing);
            pair = new ArrayList();
        }
    }

    @Override
    public boolean reportMatchCompletion(TournamentPairing pairing) {
        this.finishMatch(pairing);
        if (!pairing.isBye()) {
            for (TournamentPlayer tp : pairing.getPairedPlayers()) {
                if (!tp.equals(pairing.getWinner())) {
                    tp.addLoss();
                    continue;
                }
                tp.addWin();
            }
        }
        if (this.activePairings.isEmpty()) {
            this.completeRound();
            return false;
        }
        return true;
    }

    @Override
    public boolean completeRound() {
        if (this.activeRound < this.totalRounds) {
            if (this.continualPairing) {
                this.generateActivePairings();
            }
            return true;
        }
        this.endTournament();
        return false;
    }

    @Override
    public void endTournament() {
        this.activePairings.clear();
    }
}

