/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.tournament.system;

import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import forge.LobbyPlayer;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.List;

public class TournamentPlayer {
    private LobbyPlayer player;
    private int wins = 0;
    private int losses = 0;
    private int ties = 0;
    private int byes = 0;
    private boolean active = true;
    private List<Integer> previousOpponents = new ArrayList<Integer>();
    private int index = -1;

    public TournamentPlayer(LobbyPlayer plyr) {
        this.player = plyr;
    }

    public TournamentPlayer(LobbyPlayer plyr, int idx) {
        this.player = plyr;
        this.index = idx;
    }

    public LobbyPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(LobbyPlayer player) {
        this.player = player;
    }

    public void addOpponentIndex(int oppIndex) {
        this.previousOpponents.add(oppIndex);
    }

    public void addLoss() {
        ++this.losses;
    }

    public void addWin() {
        ++this.wins;
    }

    public void addTie() {
        ++this.ties;
    }

    public void addBye() {
        ++this.byes;
    }

    public int getScore() {
        return (this.wins + this.byes) * 3 + this.ties;
    }

    public int getSwissScore() {
        return (this.wins + this.byes) * 30 + this.ties * 10 + this.byes;
    }

    public String getNameAndScore() {
        return TextUtil.concatNoSpace(this.getPlayer().getName(), TextUtil.enclosedBracket(String.valueOf(this.getScore())));
    }

    public int getWins() {
        return this.wins;
    }

    public void setWins(int wins) {
        this.wins = wins;
    }

    public int getLosses() {
        return this.losses;
    }

    public void setLosses(int losses) {
        this.losses = losses;
    }

    public int getTies() {
        return this.ties;
    }

    public void setTies(int ties) {
        this.ties = ties;
    }

    public int getByes() {
        return this.byes;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public List<Integer> getPreviousOpponents() {
        return this.previousOpponents;
    }

    public void exportToXML(HierarchicalStreamWriter writer) {
    }
}

