/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.tournament.system;

import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import forge.LobbyPlayer;
import forge.game.GameOutcome;
import forge.gamemodes.tournament.system.TournamentPlayer;
import java.util.ArrayList;
import java.util.List;

public class TournamentPairing {
    private int round;
    private boolean bye = false;
    private final List<TournamentPlayer> pairedPlayers = new ArrayList<TournamentPlayer>();
    private final List<GameOutcome> outcomes = new ArrayList<GameOutcome>();
    private TournamentPlayer winner;

    public TournamentPairing(int rnd, List<TournamentPlayer> plyrs) {
        this.pairedPlayers.addAll(plyrs);
        this.round = rnd;
        this.winner = null;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public boolean isBye() {
        return this.bye;
    }

    public void setBye(boolean bye) {
        this.bye = bye;
    }

    public List<TournamentPlayer> getPairedPlayers() {
        return this.pairedPlayers;
    }

    public List<GameOutcome> getOutcomes() {
        return this.outcomes;
    }

    public TournamentPlayer getWinner() {
        return this.winner;
    }

    public void setWinner(TournamentPlayer winner) {
        this.winner = winner;
    }

    public void setWinnerByIndex(int index) {
        for (TournamentPlayer pl : this.pairedPlayers) {
            if (pl.getIndex() != index) continue;
            this.winner = pl;
            return;
        }
    }

    public boolean hasPlayer(LobbyPlayer player) {
        for (TournamentPlayer pl : this.pairedPlayers) {
            if (!pl.getPlayer().equals(player)) continue;
            return true;
        }
        return false;
    }

    public String outputHeader() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (TournamentPlayer tp : this.getPairedPlayers()) {
            if (!first) {
                sb.append("vs ");
            }
            first = false;
            sb.append(tp.getNameAndScore()).append(" ");
        }
        if (this.isBye()) {
            sb.append("BYE");
        }
        return sb.toString();
    }

    public void exportToXML(HierarchicalStreamWriter writer) {
    }
}

