/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.tournament.system;

import forge.gamemodes.tournament.system.AbstractTournament;
import forge.gamemodes.tournament.system.TournamentPairing;
import forge.gamemodes.tournament.system.TournamentPlayer;
import java.util.ArrayList;
import java.util.List;

public class TournamentBracket
extends AbstractTournament {
    public TournamentBracket(int ttlRnds, int pairingAmount) {
        super(ttlRnds);
        this.playersInPairing = pairingAmount;
    }

    public TournamentBracket(List<TournamentPlayer> allPlayers, int pairingAmount) {
        super((int)Math.ceil(Math.log(allPlayers.size()) / Math.log(2.0)), allPlayers);
        this.playersInPairing = pairingAmount;
    }

    public TournamentBracket(int ttlRnds, List<TournamentPlayer> allPlayers) {
        super(ttlRnds, allPlayers);
        this.initializeTournament();
    }

    public TournamentBracket(int ttlRnds, List<TournamentPlayer> allPlayers, int pairingAmount) {
        super(ttlRnds, allPlayers);
        this.playersInPairing = pairingAmount;
        this.initializeTournament();
    }

    @Override
    public void generateActivePairings() {
        ++this.activeRound;
        int numByes = 0;
        if (this.activeRound == 1) {
            int fullBracketSize = (int)Math.pow(2.0, Math.ceil(Math.log(this.remainingPlayers.size()) / Math.log(2.0)));
            numByes = fullBracketSize - this.remainingPlayers.size();
        }
        ArrayList<TournamentPlayer> pair = new ArrayList<TournamentPlayer>();
        int count = 0;
        for (TournamentPlayer tp : this.remainingPlayers) {
            pair.add(tp);
            if (++count != this.playersInPairing && numByes <= 0) continue;
            count = 0;
            TournamentPairing pairing = new TournamentPairing(this.activeRound, pair);
            if (numByes > 0) {
                --numByes;
                pairing.setBye(true);
            }
            this.activePairings.add(pairing);
            pair = new ArrayList();
        }
    }

    @Override
    public boolean reportMatchCompletion(TournamentPairing pairing) {
        this.finishMatch(pairing);
        if (!pairing.isBye()) {
            for (TournamentPlayer tp : pairing.getPairedPlayers()) {
                if (!tp.equals(pairing.getWinner())) {
                    tp.addLoss();
                    this.remainingPlayers.remove(tp);
                    tp.setActive(false);
                    continue;
                }
                tp.addWin();
            }
        }
        if (this.activePairings.isEmpty()) {
            this.completeRound();
            return false;
        }
        return true;
    }

    @Override
    public boolean completeRound() {
        if (this.activeRound < this.totalRounds) {
            if (this.continualPairing) {
                this.generateActivePairings();
            }
            return true;
        }
        this.endTournament();
        return false;
    }

    @Override
    public void endTournament() {
        this.activePairings.clear();
    }

    public int getFurthestRound(int index) {
        int i = this.completedPairings.size();
        while (--i >= 0) {
            TournamentPairing pairing = (TournamentPairing)this.completedPairings.get(i);
            for (TournamentPlayer player : pairing.getPairedPlayers()) {
                if (player.getIndex() != index) continue;
                int roundAdjustment = pairing.getWinner().equals(player) ? 1 : 0;
                return pairing.getRound() + roundAdjustment;
            }
        }
        return 0;
    }

    public static TournamentBracket importFromXML() {
        TournamentBracket bracket = new TournamentBracket(3, 2);
        return bracket;
    }
}

