/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest.data;

import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.gamemodes.quest.QuestDeckGroupMap;
import forge.gamemodes.quest.QuestDeckMap;
import forge.gamemodes.quest.QuestMode;
import forge.gamemodes.quest.QuestUtilCards;
import forge.gamemodes.quest.bazaar.QuestItemType;
import forge.gamemodes.quest.data.GameFormatQuest;
import forge.gamemodes.quest.data.QuestItemCondition;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.model.FModel;
import forge.util.ItemPool;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class QuestAssets {
    private final ItemPool<PaperCard> cardPool = new ItemPool<PaperCard>(PaperCard.class);
    private long credits;
    private final HashMap<String, Deck> myDecks = new HashMap();
    private final ItemPool<InventoryItem> newCardList = new ItemPool<InventoryItem>(InventoryItem.class);
    private final ItemPool<InventoryItem> shopList = new ItemPool<InventoryItem>(InventoryItem.class);
    private final Map<QuestItemType, QuestItemCondition> inventoryItems = new EnumMap<QuestItemType, QuestItemCondition>(QuestItemType.class);
    private final Map<String, QuestItemCondition> combatPets = new HashMap<String, QuestItemCondition>();
    private final HashMap<String, DeckGroup> draftDecks = new HashMap();

    public final boolean hasItem(QuestItemType itemType) {
        return this.inventoryItems.containsKey((Object)itemType) && this.inventoryItems.get((Object)itemType).getLevel() > 0;
    }

    public final int getItemLevel(QuestItemType itemType) {
        QuestItemCondition state = this.inventoryItems.get((Object)itemType);
        return state == null ? 0 : state.getLevel();
    }

    public final <T extends QuestItemCondition> T getItemCondition(QuestItemType itemType) {
        QuestItemCondition current = this.inventoryItems.get((Object)itemType);
        if (!current.getClass().equals(itemType.getModelClass())) {
            try {
                QuestItemCondition modern = itemType.getModelClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                modern.takeDataFrom(current);
                current = modern;
                this.inventoryItems.put(itemType, modern);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return (T)current;
    }

    public final void setItemLevel(QuestItemType itemType, int level) {
        QuestItemCondition cond = this.inventoryItems.get((Object)itemType);
        if (null == cond) {
            try {
                cond = itemType.getModelClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                cond = new QuestItemCondition();
            }
            this.inventoryItems.put(itemType, cond);
        }
        cond.setLevel(level);
    }

    public final int getPetLevel(String name) {
        QuestItemCondition state = this.combatPets.get(name);
        return state == null ? 0 : state.getLevel();
    }

    public final <T extends QuestItemCondition> T getPetCondition(String name) {
        return (T)this.combatPets.get(name);
    }

    public final void setPetLevel(String name, int level) {
        QuestItemCondition cond = this.combatPets.computeIfAbsent(name, k -> new QuestItemCondition());
        cond.setLevel(level);
    }

    public QuestAssets() {
    }

    public QuestAssets(GameFormatQuest useFormat) {
        QuestPreferences prefs = FModel.getQuestPreferences();
        int snowLands = prefs.getPrefInt(QuestPreferences.QPref.STARTING_SNOW_LANDS);
        if (useFormat != null && !useFormat.hasSnowLands()) {
            snowLands = 0;
        }
        ItemPool<PaperCard> lands = QuestUtilCards.generateBasicLands(0, snowLands, useFormat);
        this.getCardPool().addAll(lands);
    }

    public long getCredits() {
        return this.credits;
    }

    public int getLife(QuestMode mode) {
        int base = mode.equals((Object)QuestMode.Fantasy) ? 15 : 20;
        switch (FModel.getQuest().getDeckConstructionRules()) {
            case Default: {
                break;
            }
            case Commander: {
                base += 20;
            }
        }
        return base + this.getItemLevel(QuestItemType.ELIXIR_OF_LIFE) - this.getItemLevel(QuestItemType.POUND_FLESH);
    }

    public ItemPool<InventoryItem> getNewCardList() {
        return this.newCardList;
    }

    public ItemPool<InventoryItem> getShopList() {
        return this.shopList;
    }

    public void setCredits(long credits0) {
        this.credits = credits0;
    }

    public void addCredits(long c) {
        this.setCredits(this.getCredits() + c);
    }

    public ItemPool<PaperCard> getCardPool() {
        return this.cardPool;
    }

    public void subtractCredits(long c) {
        this.setCredits(this.getCredits() > c ? this.getCredits() - c : 0L);
    }

    public QuestDeckMap getDeckStorage() {
        return new QuestDeckMap(this.myDecks);
    }

    public QuestDeckGroupMap getDraftDeckStorage() {
        return new QuestDeckGroupMap(this.draftDecks);
    }
}

