/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest.data;

import com.google.common.base.Predicate;
import forge.card.CardEdition;
import forge.game.GameFormat;
import forge.gamemodes.quest.setrotation.ISetRotation;
import forge.item.PaperCard;
import forge.model.FModel;
import java.util.ArrayList;
import java.util.List;

public final class GameFormatQuest
extends GameFormat {
    private final boolean allowUnlocks;
    private int unlocksUsed = 0;
    private ISetRotation setRotation;

    @Override
    public List<String> getAllowedSetCodes() {
        if (this.setRotation != null) {
            return this.setRotation.getCurrentSetCodes(super.getAllowedSetCodes());
        }
        return super.getAllowedSetCodes();
    }

    @Override
    public Predicate<PaperCard> getFilterRules() {
        if (this.setRotation != null) {
            return super.buildFilter(false);
        }
        return super.getFilterRules();
    }

    @Override
    public Predicate<PaperCard> getFilterPrinted() {
        if (this.setRotation != null) {
            return super.buildFilter(true);
        }
        return super.getFilterPrinted();
    }

    public GameFormatQuest(String newName, List<String> setsToAllow, List<String> cardsToBan) {
        super(newName, setsToAllow, cardsToBan);
        this.allowUnlocks = false;
        this.setRotation = null;
    }

    public GameFormatQuest(String newName, List<String> setsToAllow, List<String> cardsToBan, boolean allowSetUnlocks) {
        super(newName, setsToAllow, cardsToBan);
        this.allowUnlocks = allowSetUnlocks;
        this.setRotation = null;
    }

    public GameFormatQuest(String newName, List<String> setsToAllow, List<String> cardsToBan, boolean allowSetUnlocks, ISetRotation setRotation) {
        super(newName, setsToAllow, cardsToBan);
        this.allowUnlocks = allowSetUnlocks;
        this.setRotation = setRotation;
    }

    public GameFormatQuest(GameFormat toCopy, boolean allowSetUnlocks, ISetRotation setRotation) {
        super(toCopy.getName(), toCopy.getEffectiveDate(), toCopy.getAllowedSetCodes(), toCopy.getBannedCardNames(), toCopy.getRestrictedCards(), toCopy.isRestrictedLegendary(), toCopy.getAdditionalCards(), toCopy.getAllowedRarities(), toCopy.getIndex(), GameFormat.FormatType.CUSTOM, GameFormat.FormatSubType.CUSTOM);
        this.allowUnlocks = allowSetUnlocks;
        this.setRotation = setRotation;
    }

    public List<String> getLockedSets() {
        ArrayList<String> exSets = new ArrayList<String>();
        if (this.allowedSetCodes.isEmpty()) {
            return exSets;
        }
        for (CardEdition ce : FModel.getMagicDb().getEditions()) {
            if (this.isSetLegal(ce.getCode())) continue;
            exSets.add(ce.getCode());
        }
        return exSets;
    }

    public void unlockSet(String setCode) {
        if (!this.canUnlockSets() || this.allowedSetCodes_ro.isEmpty() || this.allowedSetCodes_ro.contains(setCode)) {
            return;
        }
        this.allowedSetCodes.add(setCode);
        ++this.unlocksUsed;
    }

    public boolean hasSnowLands() {
        return this.isSetLegal("ICE") || this.isSetLegal("CSP");
    }

    public boolean canUnlockSets() {
        return this.allowUnlocks;
    }

    public int getUnlocksUsed() {
        return this.unlocksUsed;
    }

    public static abstract class QPredicates {
        public static Predicate<CardEdition> isLegalInFormatQuest(GameFormatQuest qFormat) {
            return new LegalInFormatQuest(qFormat);
        }

        private static final class LegalInFormatQuest
        implements Predicate<CardEdition> {
            private final GameFormatQuest qFormat;

            private LegalInFormatQuest(GameFormatQuest fmt) {
                this.qFormat = fmt;
            }

            @Override
            public boolean apply(CardEdition subject) {
                return this.qFormat.isSetLegal(subject.getCode());
            }
        }
    }
}

