/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest.bazaar;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import forge.card.CardEdition;
import forge.card.CardRules;
import forge.item.PaperToken;
import forge.localinstance.properties.ForgeConstants;
import forge.util.FileUtil;
import java.io.File;
import java.util.List;

@XStreamAlias(value="level")
public class QuestPetStats {
    @XStreamAsAttribute
    @XStreamAlias(value="value")
    private int levelValue;
    @XStreamAsAttribute
    @XStreamAlias(value="pic")
    private String picture;
    @XStreamAsAttribute
    private String stats;
    @XStreamAsAttribute
    private String cardFile;
    @XStreamAsAttribute
    private int cost;
    @XStreamAsAttribute
    private String nextLevel;
    private transient PaperToken petCard = null;

    private QuestPetStats() {
    }

    public final int getLevelValue() {
        return this.levelValue;
    }

    public final String getPicture() {
        return this.picture;
    }

    public final String getStats() {
        return this.stats;
    }

    public final PaperToken getCard() {
        if (null == this.petCard) {
            List<String> cardLines = FileUtil.readFile(new File(ForgeConstants.BAZAAR_DIR, this.cardFile));
            CardRules rules = CardRules.fromScript(cardLines);
            this.petCard = new PaperToken(rules, CardEdition.UNKNOWN, this.picture);
        }
        return this.petCard;
    }

    public final int getCost() {
        return this.cost;
    }

    public final String getNextLevel() {
        return this.nextLevel;
    }
}

