/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest.bazaar;

import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.bazaar.IQuestBazaarItem;
import forge.gamemodes.quest.bazaar.QuestItemType;
import forge.gamemodes.quest.data.QuestAssets;
import forge.gui.GuiBase;
import forge.localinstance.skin.FSkinProp;
import forge.localinstance.skin.ISkinImage;
import org.apache.commons.lang3.StringUtils;

public class QuestItemBasic
implements IQuestBazaarItem {
    @XStreamAsAttribute
    private QuestItemType itemType;
    @XStreamAsAttribute
    private int maxLevel = 1;
    @XStreamAsAttribute
    private String purchaseName = null;
    private String description = "Read from XML";
    @XStreamAsAttribute
    private int basePrice = 1000;
    @XStreamAsAttribute
    private final FSkinProp icon = null;

    public final QuestItemType getItemType() {
        return this.itemType;
    }

    protected final int getBasePrice() {
        return this.basePrice;
    }

    protected QuestItemBasic() {
    }

    protected QuestItemBasic(QuestItemType type0) {
        this.itemType = type0;
    }

    public final String getName() {
        return this.itemType.getKey();
    }

    @Override
    public String getPurchaseName() {
        return StringUtils.isBlank(this.purchaseName) ? this.getName() : this.purchaseName;
    }

    @Override
    public void onPurchase(QuestAssets qA) {
        int currentLevel = qA.getItemLevel(this.itemType);
        qA.setItemLevel(this.itemType, currentLevel + 1);
    }

    @Override
    public boolean isAvailableForPurchase(QuestAssets qA, QuestController qCtrl) {
        return qA.getItemLevel(this.itemType) < this.maxLevel;
    }

    public final int getMaxLevel() {
        return this.maxLevel;
    }

    public final boolean isLeveledItem() {
        return this.maxLevel == 1;
    }

    @Override
    public String getPurchaseDescription(QuestAssets qA) {
        return this.description;
    }

    @Override
    public ISkinImage getIcon(QuestAssets qA) {
        return GuiBase.getInterface().getSkinIcon(this.icon);
    }

    @Override
    public int getBuyingPrice(QuestAssets qA) {
        return this.basePrice;
    }

    @Override
    public int getSellingPrice(QuestAssets qA) {
        return 0;
    }

    @Override
    public final int compareTo(Object o) {
        IQuestBazaarItem q = (IQuestBazaarItem)o;
        return this.getPurchaseName().compareTo(q.getPurchaseName());
    }
}

