/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import com.google.common.base.Function;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckFormat;
import forge.deck.DeckSection;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestUtilCards;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gamemodes.quest.io.ReadPriceList;
import forge.gui.GuiBase;
import forge.gui.util.SOptionPane;
import forge.item.BoosterBox;
import forge.item.BoosterPack;
import forge.item.BoxedProduct;
import forge.item.FatPack;
import forge.item.IPaperCard;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.item.PreconDeck;
import forge.item.SealedProduct;
import forge.item.TournamentPack;
import forge.itemmanager.IItemManager;
import forge.itemmanager.SItemManagerUtil;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.ItemPool;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class QuestSpellShop {
    private static Map<String, Integer> mapPrices;
    private static double multiplier;
    private static ItemPool<InventoryItem> decksUsingMyCards;
    public static final Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> fnPriceCompare;
    public static final Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnPriceGet;
    public static final Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnPriceSellGet;
    public static final Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> fnDeckCompare;
    public static final Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnDeckGet;

    public static Integer getCardValue(InventoryItem card) {
        String nsArt;
        String ns;
        int value = 1337;
        boolean foil = false;
        PaperCard pc = null;
        int artIndex = 0;
        if (card instanceof PaperCard) {
            pc = (PaperCard)card;
            artIndex = pc.getArtIndex();
            ns = card.getName() + "|" + pc.getEdition();
            nsArt = card.getName() + " (" + artIndex + ")|" + pc.getEdition();
            foil = ((PaperCard)card).isFoil();
        } else {
            nsArt = ns = card.getName();
        }
        if (mapPrices == null) {
            mapPrices = new ReadPriceList().getPriceList();
        }
        if (mapPrices.containsKey(ns)) {
            value = mapPrices.get(ns);
        } else if (mapPrices.containsKey(nsArt)) {
            value = mapPrices.get(nsArt);
        } else if (card instanceof PaperCard) {
            switch (((IPaperCard)card).getRarity()) {
                case BasicLand: {
                    value = 4;
                    break;
                }
                case Common: {
                    value = 6;
                    break;
                }
                case Uncommon: {
                    value = 40;
                    break;
                }
                case Rare: {
                    value = 120;
                    break;
                }
                case MythicRare: {
                    value = 600;
                    break;
                }
                default: {
                    value = 15;
                    break;
                }
            }
        } else if (card instanceof BoosterPack) {
            value = 395;
        } else if (card instanceof TournamentPack) {
            value = 995;
        } else if (card instanceof FatPack) {
            value = 2365;
        } else if (card instanceof BoosterBox) {
            value = 8750;
        } else if (card instanceof PreconDeck) {
            value = QuestController.getPreconDeals((PreconDeck)card).getCost();
        }
        if (foil) {
            int foilMultiplier;
            switch (((IPaperCard)card).getRarity()) {
                case BasicLand: {
                    foilMultiplier = 2;
                    break;
                }
                case Common: {
                    foilMultiplier = 2;
                    break;
                }
                case Uncommon: {
                    foilMultiplier = 2;
                    break;
                }
                case Rare: {
                    foilMultiplier = 3;
                    break;
                }
                case MythicRare: {
                    foilMultiplier = 3;
                    break;
                }
                default: {
                    foilMultiplier = 2;
                }
            }
            value *= foilMultiplier;
        }
        if (value == 0) {
            value = 1;
        }
        return value;
    }

    public static long getTotalBuyCost(Iterable<Map.Entry<InventoryItem, Integer>> items) {
        long totalCost = 0L;
        for (Map.Entry<InventoryItem, Integer> itemEntry : items) {
            InventoryItem item = itemEntry.getKey();
            if (!(item instanceof PaperCard) && !(item instanceof SealedProduct) && !(item instanceof PreconDeck)) continue;
            totalCost += (long)(itemEntry.getValue() * QuestSpellShop.getCardValue(item));
        }
        return totalCost;
    }

    public static void buy(Iterable<Map.Entry<InventoryItem, Integer>> items, IItemManager<InventoryItem> shopManager, IItemManager<InventoryItem> inventoryManager, boolean confirmPurchase) {
        long totalCost = 0L;
        ItemPool<InventoryItem> itemsToBuy = new ItemPool<InventoryItem>(InventoryItem.class);
        for (Map.Entry<InventoryItem, Integer> itemEntry : items) {
            InventoryItem item = itemEntry.getKey();
            if (!(item instanceof PaperCard) && !(item instanceof SealedProduct) && !(item instanceof PreconDeck)) continue;
            int qty = itemEntry.getValue();
            itemsToBuy.add(item, qty);
            totalCost += (long)(qty * QuestSpellShop.getCardValue(item));
        }
        if (itemsToBuy.isEmpty()) {
            return;
        }
        List<InventoryItem> itemFlatList = itemsToBuy.toFlatList();
        String suffix = SItemManagerUtil.getItemDisplayString(itemFlatList, 1, true);
        String displayList = SItemManagerUtil.buildDisplayList(itemsToBuy);
        String title = "Buy " + suffix;
        long creditsShort = totalCost - FModel.getQuest().getAssets().getCredits();
        if (creditsShort > 0L) {
            SOptionPane.showMessageDialog("You need " + creditsShort + " more credits to purchase the following " + suffix.toLowerCase() + ".\n" + displayList, title);
            return;
        }
        if (confirmPurchase && !SOptionPane.showConfirmDialog("Pay " + totalCost + " credits to purchase the following " + suffix.toLowerCase() + "?\n" + displayList, title, "Buy", "Cancel")) {
            return;
        }
        ItemPool<InventoryItem> itemsToAdd = new ItemPool<InventoryItem>(InventoryItem.class);
        for (Map.Entry<InventoryItem, Integer> entry : itemsToBuy) {
            InventoryItem item = entry.getKey();
            int qty = entry.getValue();
            int value = QuestSpellShop.getCardValue(item);
            if (item instanceof PaperCard) {
                FModel.getQuest().getCards().buyCard((PaperCard)item, qty, value);
                itemsToAdd.add(item, qty);
                continue;
            }
            if (item instanceof SealedProduct) {
                for (int i = 0; i < qty; ++i) {
                    SealedProduct booster = null;
                    if (item instanceof BoosterPack) {
                        booster = (BoosterPack)((BoosterPack)item).clone();
                        if (SealedProduct.specialSets.contains(booster.getEdition()) || booster.getEdition().equals("?")) {
                            String color = booster.getName().substring(0, booster.getName().indexOf(booster.getItemType()) - 1);
                            booster = new BoosterPack(color, QuestUtilCards.getColoredBoosterTemplate(color));
                        }
                    } else if (item instanceof TournamentPack) {
                        booster = (TournamentPack)((TournamentPack)item).clone();
                    } else if (item instanceof FatPack) {
                        booster = (FatPack)((FatPack)item).clone();
                    } else if (item instanceof BoosterBox) {
                        booster = (BoosterBox)((BoosterBox)item).clone();
                    }
                    FModel.getQuest().getCards().buyPack(booster, value);
                    assert (booster != null);
                    List<PaperCard> newCards = booster.getCards();
                    itemsToAdd.addAllOfTypeFlat(newCards);
                    if (booster instanceof BoxedProduct && FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_OPEN_PACKS_INDIV)) {
                        int totalPacks = ((BoxedProduct)booster).boosterPacksRemaining();
                        boolean skipTheRest = false;
                        ArrayList<PaperCard> remainingCards = new ArrayList<PaperCard>();
                        while (((BoxedProduct)booster).boosterPacksRemaining() > 0 && !skipTheRest) {
                            skipTheRest = GuiBase.getInterface().showBoxedProduct(booster.getName(), "You have found the following cards inside (Booster Pack " + (totalPacks - ((BoxedProduct)booster).boosterPacksRemaining() + 1) + " of " + totalPacks + "):", ((BoxedProduct)booster).getNextBoosterPack());
                        }
                        if (skipTheRest) {
                            while (((BoxedProduct)booster).boosterPacksRemaining() > 0) {
                                remainingCards.addAll(((BoxedProduct)booster).getNextBoosterPack());
                            }
                        }
                        remainingCards.addAll(((BoxedProduct)booster).getExtraCards());
                        if (remainingCards.isEmpty()) continue;
                        GuiBase.getInterface().showCardList(booster.getName(), "You have found the following cards inside:", remainingCards);
                        continue;
                    }
                    GuiBase.getInterface().showCardList(booster.getName(), "You have found the following cards inside:", newCards);
                }
                continue;
            }
            if (!(item instanceof PreconDeck)) continue;
            PreconDeck deck = (PreconDeck)item;
            for (int i = 0; i < qty; ++i) {
                FModel.getQuest().getCards().buyPreconDeck(deck, value);
                itemsToAdd.addAllOfType(deck.getDeck().getMain());
            }
            boolean one = qty == 1;
            SOptionPane.showMessageDialog(String.format("%s '%s' %s added to your decklist.%n%n%s cards were also added to your pool.", one ? "Deck" : String.format("%d copies of deck", qty), deck.getName(), one ? "was" : "were", one ? "Its" : "Their"), "Thanks for purchasing!", SOptionPane.INFORMATION_ICON);
        }
        shopManager.removeItems(itemsToBuy);
        inventoryManager.addItems(itemsToAdd);
    }

    public static long getTotalSellValue(Iterable<Map.Entry<InventoryItem, Integer>> items) {
        long totalValue = 0L;
        int sellPriceLimit = FModel.getQuest().getCards().getSellPriceLimit();
        for (Map.Entry<InventoryItem, Integer> itemEntry : items) {
            InventoryItem item = itemEntry.getKey();
            if (!(item instanceof PaperCard)) continue;
            totalValue += (long)(itemEntry.getValue() * Math.max(Math.min((int)(multiplier * (double)QuestSpellShop.getCardValue(item).intValue()), sellPriceLimit), 1));
        }
        return totalValue;
    }

    public static void sell(Iterable<Map.Entry<InventoryItem, Integer>> items, IItemManager<InventoryItem> shopManager, IItemManager<InventoryItem> inventoryManager, boolean confirmSale) {
        long totalReceived = 0L;
        int sellPriceLimit = FModel.getQuest().getCards().getSellPriceLimit();
        ItemPool<InventoryItem> itemsToSell = new ItemPool<InventoryItem>(InventoryItem.class);
        for (Map.Entry<InventoryItem, Integer> entry : items) {
            InventoryItem item = entry.getKey();
            if (!(item instanceof PaperCard)) continue;
            int qty = entry.getValue();
            itemsToSell.add(item, qty);
            totalReceived += (long)(qty * Math.max(Math.min((int)(multiplier * (double)QuestSpellShop.getCardValue(item).intValue()), sellPriceLimit), 1));
        }
        if (itemsToSell.isEmpty()) {
            return;
        }
        if (confirmSale) {
            List<InventoryItem> itemFlatList = itemsToSell.toFlatList();
            String string = SItemManagerUtil.getItemDisplayString(itemFlatList, 1, true);
            String displayList = SItemManagerUtil.buildDisplayList(itemsToSell);
            String title = "Sell " + string;
            if (!SOptionPane.showConfirmDialog("Sell the following " + string.toLowerCase() + " for " + totalReceived + " credit" + (totalReceived != 1L ? "s" : "") + "?\n" + displayList, title, "Sell", "Cancel")) {
                return;
            }
        }
        for (Map.Entry<InventoryItem, Integer> entry : itemsToSell) {
            PaperCard card = (PaperCard)entry.getKey();
            int pricePerCard = Math.max(Math.min((int)(multiplier * (double)QuestSpellShop.getCardValue(card).intValue()), FModel.getQuest().getCards().getSellPriceLimit()), 1);
            QuestSpellShop.sellCard(card, entry.getValue(), pricePerCard);
        }
        inventoryManager.removeItems(itemsToSell);
        shopManager.addItems(itemsToSell);
    }

    public static void sellExtras(IItemManager<InventoryItem> shopManager, IItemManager<InventoryItem> inventoryManager) {
        PaperCard card;
        LinkedList cardsToRemove = new LinkedList();
        for (Map.Entry<InventoryItem, Integer> entry : inventoryManager.getPool()) {
            card = (PaperCard)entry.getKey();
            int numToKeep = 4;
            if (card.getRules().getType().isBasic()) {
                numToKeep = FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.PLAYSET_BASIC_LAND_SIZE);
            } else {
                switch (FModel.getQuest().getDeckConstructionRules()) {
                    case Default: {
                        numToKeep = FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.PLAYSET_SIZE);
                        break;
                    }
                    case Commander: {
                        numToKeep = 1;
                    }
                }
            }
            if (DeckFormat.canHaveAnyNumberOf(card)) {
                numToKeep = FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.PLAYSET_ANY_NUMBER_SIZE);
            } else {
                Integer cardCopies = DeckFormat.canHaveSpecificNumberInDeck(card);
                if (cardCopies != null) {
                    numToKeep = cardCopies;
                }
            }
            if (numToKeep >= entry.getValue()) continue;
            cardsToRemove.add(Pair.of(entry.getKey(), entry.getValue() - numToKeep));
        }
        inventoryManager.removeItems(cardsToRemove);
        shopManager.addItems(cardsToRemove);
        for (Map.Entry<InventoryItem, Integer> entry : cardsToRemove) {
            if (!(entry.getKey() instanceof PaperCard)) continue;
            card = (PaperCard)entry.getKey();
            int pricePerCard = Math.max(Math.min((int)(multiplier * (double)QuestSpellShop.getCardValue(card).intValue()), FModel.getQuest().getCards().getSellPriceLimit()), 1);
            QuestSpellShop.sellCard(card, entry.getValue(), pricePerCard);
        }
    }

    private static void sellCard(PaperCard card, int quantity, int pricePerCard) {
        FModel.getQuest().getCards().removeCard(card, quantity);
        FModel.getQuest().getAssets().addCredits(pricePerCard * quantity);
    }

    public static void updateDecksForEachCard() {
        decksUsingMyCards = new ItemPool<InventoryItem>(InventoryItem.class);
        for (Deck deck : FModel.getQuest().getMyDecks()) {
            CardPool main = deck.getMain();
            for (Map.Entry e : main) {
                decksUsingMyCards.add((InventoryItem)e.getKey());
            }
            if (!deck.has(DeckSection.Sideboard)) continue;
            for (Map.Entry e : deck.get(DeckSection.Sideboard)) {
                if (main.contains((PaperCard)e.getKey())) continue;
                decksUsingMyCards.add((InventoryItem)e.getKey());
            }
        }
    }

    public static double updateMultiplier() {
        multiplier = FModel.getQuest().getCards().getSellMultiplier();
        return multiplier;
    }

    static {
        fnPriceCompare = from -> QuestSpellShop.getCardValue((InventoryItem)from.getKey());
        fnPriceGet = from -> QuestSpellShop.getCardValue((InventoryItem)from.getKey());
        fnPriceSellGet = from -> Math.max((int)(multiplier * (double)QuestSpellShop.getCardValue((InventoryItem)from.getKey()).intValue()), 1);
        fnDeckCompare = from -> Integer.valueOf(decksUsingMyCards.count((InventoryItem)from.getKey()));
        fnDeckGet = from -> Integer.toString(decksUsingMyCards.count((InventoryItem)from.getKey()));
    }
}

