/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import forge.gamemodes.quest.QuestRewardCard;
import forge.item.PaperCard;
import forge.model.FModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QuestRewardCardFiltered
extends QuestRewardCard {
    private final String description;
    private final Predicate<PaperCard> predicates;

    public QuestRewardCardFiltered(String[] creationParameters) {
        this.description = this.buildDescription(creationParameters);
        this.predicates = this.buildPredicates(creationParameters);
    }

    @Override
    public String getName() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    @Override
    public String getItemType() {
        return "chosen card";
    }

    @Override
    public final List<PaperCard> getChoices() {
        ArrayList<PaperCard> cardChoices = new ArrayList<PaperCard>();
        for (PaperCard card : Iterables.filter(FModel.getMagicDb().getCommonCards().getAllCards(), this.predicates)) {
            cardChoices.add(card);
        }
        Collections.sort(cardChoices);
        return Collections.unmodifiableList(cardChoices);
    }
}

