/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import forge.deck.Deck;
import forge.gamemodes.quest.BoosterUtils;
import forge.gamemodes.quest.IQuestEvent;
import forge.gamemodes.quest.QuestEventDifficulty;
import forge.gamemodes.quest.QuestUtil;
import forge.item.InventoryItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class QuestEvent
implements IQuestEvent {
    protected Deck eventDeck = null;
    private String title = "Mystery Event";
    private String description = "";
    private QuestEventDifficulty difficulty = QuestEventDifficulty.MEDIUM;
    private boolean showDifficulty = true;
    private String imageKey = "";
    private String name = "Noname";
    private String cardReward = null;
    private List<InventoryItem> cardRewardList = null;
    private String profile = "Default";
    private String opponentName = null;
    private boolean isRandomMatch = false;

    public final String getTitle() {
        return this.title;
    }

    public String getOpponentName() {
        return this.opponentName;
    }

    public void setOpponentName(String newName) {
        this.opponentName = newName;
    }

    public final QuestEventDifficulty getDifficulty() {
        return this.difficulty;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    public Deck getEventDeck() {
        return this.eventDeck;
    }

    @Override
    public final String getIconImageKey() {
        return this.imageKey;
    }

    public final String getName() {
        return this.name;
    }

    public final String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile0) {
        this.profile = profile0;
    }

    public void setName(String name0) {
        this.name = name0;
    }

    public void setTitle(String title0) {
        this.title = title0;
    }

    public void setDifficulty(QuestEventDifficulty difficulty0) {
        this.difficulty = difficulty0;
    }

    public void setDescription(String description0) {
        this.description = description0;
    }

    public void setEventDeck(Deck eventDeck0) {
        this.eventDeck = eventDeck0;
    }

    @Override
    public void setIconImageKey(String s0) {
        this.imageKey = s0;
    }

    public final List<InventoryItem> getCardRewardList() {
        if (this.cardReward == null) {
            return null;
        }
        if (this.cardRewardList == null) {
            this.cardRewardList = new ArrayList<InventoryItem>(BoosterUtils.generateCardRewardList(this.cardReward));
        }
        return this.cardRewardList;
    }

    public void setCardReward(String cardReward0) {
        this.cardReward = cardReward0;
    }

    public List<String> getHumanExtraCards() {
        return Collections.emptyList();
    }

    public List<String> getAiExtraCards() {
        return Collections.emptyList();
    }

    @Override
    public final String getFullTitle() {
        return this.title + (this.showDifficulty ? " (" + this.difficulty.getTitle() + ")" : "");
    }

    @Override
    public void select() {
        QuestUtil.setEvent(this);
    }

    @Override
    public boolean hasImage() {
        return true;
    }

    public boolean showDifficulty() {
        return this.showDifficulty;
    }

    public void setShowDifficulty(boolean showDifficulty) {
        this.showDifficulty = showDifficulty;
    }

    public boolean getIsRandomMatch() {
        return this.isRandomMatch;
    }

    public void setIsRandomMatch(boolean b) {
        this.isRandomMatch = b;
    }
}

