/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.planarconquest;

import forge.card.CardRules;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.deck.generation.DeckGenPool;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.gamemodes.planarconquest.ConquestRecord;
import forge.gamemodes.planarconquest.ConquestRegion;
import forge.gamemodes.planarconquest.ConquestUtil;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.model.FModel;
import forge.util.XmlReader;
import forge.util.XmlWriter;

public class ConquestCommander
implements InventoryItem,
XmlWriter.IXmlWritable {
    private final PaperCard card;
    private final ConquestRecord record;
    private final ConquestPlane originPlane;
    private final String originRegionName;
    private Deck deck;

    public ConquestCommander(PaperCard card0) {
        this(card0, null, null);
    }

    public ConquestCommander(PaperCard card0, ConquestPlane startingPlane) {
        this(card0, ConquestUtil.generateDeck(card0, new DeckGenPool(startingPlane.getCardPool().getAllCards(pc -> {
            CardRules rules = pc.getRules();
            return !rules.canBeCommander() && !rules.getType().isPlaneswalker();
        })), false), null);
    }

    private ConquestCommander(PaperCard card0, Deck deck0, ConquestRecord record0) {
        this.card = card0;
        this.deck = deck0;
        if (record0 == null) {
            record0 = new ConquestRecord();
        }
        this.record = record0;
        ConquestPlane originPlane0 = null;
        String originRegionName0 = null;
        block0: for (ConquestPlane plane : FModel.getPlanes()) {
            if (!plane.getCommanders().contains(this.card)) continue;
            originPlane0 = plane;
            for (ConquestRegion region : plane.getRegions()) {
                if (!region.getCardPool().contains(this.card)) continue;
                originRegionName0 = region.getName();
                break block0;
            }
        }
        this.originPlane = originPlane0;
        this.originRegionName = originRegionName0;
    }

    public ConquestCommander(XmlReader xml) {
        this(xml.read("card", FModel.getMagicDb().getCommonCards()), null, xml.read("record", ConquestRecord.class));
    }

    @Override
    public void saveToXml(XmlWriter xml) {
        xml.write("card", this.card);
        xml.write("record", this.record);
    }

    @Override
    public String getName() {
        return this.card.getName();
    }

    public String getPlayerName() {
        String name = this.card.getName();
        int idx = name.indexOf(44);
        if (idx != -1) {
            name = name.substring(0, idx);
        }
        return name;
    }

    public PaperCard getCard() {
        return this.card;
    }

    public Deck getDeck() {
        if (this.deck == null) {
            this.reloadDeck();
        }
        return this.deck;
    }

    public void reloadDeck() {
        this.deck = FModel.getConquest().getDecks().get(this.card.getName());
        if (this.deck == null) {
            this.deck = new Deck(this.card.getName());
            this.deck.getOrCreate(DeckSection.Commander).add(this.card);
            FModel.getConquest().getDecks().add(this.deck);
        }
    }

    public ConquestRecord getRecord() {
        return this.record;
    }

    public String getOrigin() {
        if (this.originPlane == null) {
            return "";
        }
        return this.originPlane.getName().replace("_", " ") + " - " + this.originRegionName;
    }

    public ConquestPlane getOriginPlane() {
        return this.originPlane;
    }

    @Override
    public String getItemType() {
        return "Commander";
    }

    @Override
    public String getImageKey(boolean altState) {
        return this.card.getImageKey(altState);
    }

    public String toString() {
        return this.card.getName();
    }
}

