/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.planarconquest;

import forge.LobbyPlayer;
import forge.deck.Deck;
import forge.game.GameType;
import forge.game.GameView;
import forge.gamemodes.planarconquest.ConquestData;
import forge.gamemodes.planarconquest.ConquestLocation;
import forge.gamemodes.planarconquest.ConquestUtil;
import forge.gui.interfaces.IButton;
import forge.gui.interfaces.IGuiGame;
import forge.gui.interfaces.IWinLoseView;
import forge.item.PaperCard;
import forge.util.Localizer;
import java.util.Set;

public abstract class ConquestBattle {
    private final ConquestLocation location;
    private final int tier;
    private Deck opponentDeck;
    private boolean conquered;
    private boolean finished;

    protected ConquestBattle(ConquestLocation location0, int tier0) {
        this.location = location0;
        this.tier = tier0;
    }

    public ConquestLocation getLocation() {
        return this.location;
    }

    public int getTier() {
        return this.tier;
    }

    public Deck getOpponentDeck() {
        if (this.opponentDeck == null) {
            this.opponentDeck = this.buildOpponentDeck();
        }
        return this.opponentDeck;
    }

    public boolean wasConquered() {
        return this.conquered;
    }

    public void setConquered(boolean conquered0) {
        this.conquered = conquered0;
    }

    public void showGameOutcome(ConquestData model, GameView game, LobbyPlayer humanPlayer, IWinLoseView<? extends IButton> view) {
        if (game.isMatchWonBy(humanPlayer)) {
            view.getBtnRestart().setVisible(false);
            view.getBtnQuit().setText(Localizer.getInstance().getMessage("lblGreat", new Object[0]));
            model.addWin(this);
            if (this.location.getEvent().getTemporaryUnlock() != null) {
                ConquestUtil.setPlaneTemporarilyAccessible(this.location.getEvent().getTemporaryUnlock(), true);
            }
        } else {
            view.getBtnRestart().setVisible(true);
            view.getBtnRestart().setText(Localizer.getInstance().getMessage("lblRetry", new Object[0]));
            view.getBtnQuit().setText(Localizer.getInstance().getMessage("lblQuit", new Object[0]));
            model.addLoss(this);
        }
        model.resetNewCards();
        model.saveData();
    }

    public void onFinished(ConquestData model, IWinLoseView<? extends IButton> view) {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    protected abstract Deck buildOpponentDeck();

    public abstract String getEventName();

    public abstract String getOpponentName();

    public abstract PaperCard getPlaneswalker();

    public abstract void setOpponentAvatar(LobbyPlayer var1, IGuiGame var2);

    public abstract Set<GameType> getVariants();

    public abstract int gamesPerMatch();
}

