/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.net.server;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import forge.gamemodes.match.LobbySlot;
import forge.gamemodes.match.LobbySlotType;
import forge.gamemodes.net.CompatibleObjectDecoder;
import forge.gamemodes.net.CompatibleObjectEncoder;
import forge.gamemodes.net.event.LobbyUpdateEvent;
import forge.gamemodes.net.event.LoginEvent;
import forge.gamemodes.net.event.LogoutEvent;
import forge.gamemodes.net.event.MessageEvent;
import forge.gamemodes.net.event.NetEvent;
import forge.gamemodes.net.event.UpdateLobbyPlayerEvent;
import forge.gamemodes.net.server.GameServerHandler;
import forge.gamemodes.net.server.NetGuiGame;
import forge.gamemodes.net.server.RemoteClient;
import forge.gamemodes.net.server.ServerGameLobby;
import forge.gui.GuiBase;
import forge.gui.interfaces.IGuiGame;
import forge.interfaces.IGameController;
import forge.interfaces.ILobbyListener;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.serialization.ClassResolvers;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.UpnpServiceImpl;
import org.fourthline.cling.support.igd.PortMappingListener;
import org.fourthline.cling.support.model.PortMapping;

public final class FServerManager {
    private static FServerManager instance = null;
    private byte[] externalAddress = new byte[]{8, 8, 8, 8};
    private boolean isHosting = false;
    private EventLoopGroup bossGroup = new NioEventLoopGroup(1);
    private EventLoopGroup workerGroup = new NioEventLoopGroup();
    private UpnpService upnpService = null;
    private final Map<Channel, RemoteClient> clients = Maps.newTreeMap();
    private ServerGameLobby localLobby;
    private ILobbyListener lobbyListener;
    private final Thread shutdownHook = new Thread(() -> {
        if (this.isHosting()) {
            this.stopServer(false);
        }
    });

    private FServerManager() {
    }

    RemoteClient getClient(Channel ch) {
        return this.clients.get(ch);
    }

    IGameController getController(int index) {
        return this.localLobby.getController(index);
    }

    public static FServerManager getInstance() {
        if (instance == null) {
            instance = new FServerManager();
        }
        return instance;
    }

    public void startServer(int port) {
        try {
            ServerBootstrap b = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler(new LoggingHandler(LogLevel.INFO))).childHandler(new ChannelInitializer<SocketChannel>(){

                @Override
                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new CompatibleObjectEncoder(), new CompatibleObjectDecoder(0x989800, ClassResolvers.cacheDisabled(null)), new MessageHandler(), new RegisterClientHandler(), new LobbyInputHandler(), new DeregisterClientHandler(), new GameServerHandler());
                }
            });
            ChannelFuture ch = b.bind(port).sync().channel().closeFuture();
            new Thread(() -> {
                try {
                    ch.sync();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    this.stopServer();
                }
            }).start();
            this.mapNatPort(port);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            this.isHosting = true;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void stopServer() {
        this.stopServer(true);
    }

    private void stopServer(boolean removeShutdownHook) {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        if (this.upnpService != null) {
            this.upnpService.shutdown();
            this.upnpService = null;
        }
        if (removeShutdownHook) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        this.isHosting = false;
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
    }

    public boolean isHosting() {
        return this.isHosting;
    }

    public void broadcast(NetEvent event) {
        if (event instanceof MessageEvent) {
            MessageEvent msgEvent = (MessageEvent)event;
            this.lobbyListener.message(msgEvent.getSource(), msgEvent.getMessage());
        }
        this.broadcastTo(event, this.clients.values());
    }

    public void broadcastExcept(NetEvent event, RemoteClient notTo) {
        this.broadcastExcept(event, Collections.singleton(notTo));
    }

    public void broadcastExcept(NetEvent event, Collection<RemoteClient> notTo) {
        this.broadcastTo(event, Iterables.filter(this.clients.values(), Predicates.not(Predicates.in(notTo))));
    }

    private void broadcastTo(NetEvent event, Iterable<RemoteClient> to) {
        for (RemoteClient client : to) {
            this.broadcastTo(event, client);
        }
    }

    private void broadcastTo(NetEvent event, RemoteClient to) {
        event.updateForClient(to);
        to.send(event);
    }

    public void setLobby(ServerGameLobby lobby) {
        this.localLobby = lobby;
    }

    public void unsetReady() {
        if (this.localLobby != null && this.localLobby.getSlot(0) != null) {
            this.localLobby.getSlot(0).setIsReady(false);
            this.updateLobbyState();
        }
    }

    public boolean isMatchActive() {
        return this.localLobby != null && this.localLobby.isMatchActive();
    }

    public void setLobbyListener(ILobbyListener listener) {
        this.lobbyListener = listener;
    }

    public void updateLobbyState() {
        LobbyUpdateEvent event = new LobbyUpdateEvent(this.localLobby.getData());
        this.broadcast(event);
    }

    public void updateSlot(int index, UpdateLobbyPlayerEvent event) {
        this.localLobby.applyToSlot(index, event);
    }

    public IGuiGame getGui(int index) {
        LobbySlot slot = this.localLobby.getSlot(index);
        LobbySlotType type = slot.getType();
        if (type == LobbySlotType.LOCAL) {
            return GuiBase.getInterface().getNewGuiGame();
        }
        if (type == LobbySlotType.REMOTE) {
            for (RemoteClient client : this.clients.values()) {
                if (client.getIndex() != index) continue;
                return new NetGuiGame(client);
            }
        }
        return null;
    }

    private String getRoutableAddress(boolean preferIpv4, boolean preferIPv6) throws SocketException, UnknownHostException {
        try (DatagramSocket s2 = new DatagramSocket();){
            s2.connect(InetAddress.getByAddress(this.externalAddress), 0);
            NetworkInterface n = NetworkInterface.getByInetAddress(s2.getLocalAddress());
            Enumeration<InetAddress> en = n.getInetAddresses();
            while (en.hasMoreElements()) {
                InetAddress addr = en.nextElement();
                if (addr instanceof Inet4Address) {
                    if (preferIPv6) continue;
                    String string = addr.getHostAddress();
                    return string;
                }
                if (!(addr instanceof Inet6Address)) continue;
                if (preferIpv4) continue;
                String string = addr.getHostAddress();
                return string;
            }
        }
        return null;
    }

    public String getLocalAddress() {
        try {
            return this.getRoutableAddress(true, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "localhost";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExternalAddress() {
        BufferedReader in = null;
        try {
            String ip;
            URL whatismyip = new URL("https://checkip.amazonaws.com");
            in = new BufferedReader(new InputStreamReader(whatismyip.openStream()));
            String string = ip = in.readLine();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private void mapNatPort(int port) {
        String localAddress = this.getLocalAddress();
        PortMapping portMapping = new PortMapping(port, localAddress, PortMapping.Protocol.TCP, "Forge");
        if (this.upnpService != null) {
            this.upnpService.shutdown();
        }
        try {
            this.upnpService = new UpnpServiceImpl(new PortMappingListener(portMapping));
            this.upnpService.getControlPoint().search();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    private class DeregisterClientHandler
    extends ChannelInboundHandlerAdapter {
        private DeregisterClientHandler() {
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            RemoteClient client = (RemoteClient)FServerManager.this.clients.remove(ctx.channel());
            String username = client.getUsername();
            FServerManager.this.localLobby.disconnectPlayer(client.getIndex());
            FServerManager.this.broadcast(new MessageEvent(String.format("%s left the room", username)));
            FServerManager.this.broadcast(new LogoutEvent(username));
            super.channelInactive(ctx);
        }
    }

    private class LobbyInputHandler
    extends ChannelInboundHandlerAdapter {
        private LobbyInputHandler() {
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            RemoteClient client = (RemoteClient)FServerManager.this.clients.get(ctx.channel());
            if (msg instanceof LoginEvent) {
                LoginEvent event = (LoginEvent)msg;
                int index = FServerManager.this.localLobby.connectPlayer(event.getUsername(), event.getAvatarIndex(), event.getSleeveIndex());
                if (index == -1) {
                    ctx.close();
                } else {
                    client.setIndex(index);
                    FServerManager.this.broadcast(event);
                    FServerManager.this.updateLobbyState();
                }
            } else if (msg instanceof UpdateLobbyPlayerEvent) {
                FServerManager.this.updateSlot(client.getIndex(), (UpdateLobbyPlayerEvent)msg);
            } else if (msg instanceof MessageEvent) {
                MessageEvent event = (MessageEvent)msg;
                FServerManager.this.lobbyListener.message(event.getSource(), event.getMessage());
            }
            super.channelRead(ctx, msg);
        }
    }

    private class RegisterClientHandler
    extends ChannelInboundHandlerAdapter {
        private RegisterClientHandler() {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            RemoteClient client = new RemoteClient(ctx.channel());
            FServerManager.this.clients.put(ctx.channel(), client);
            System.out.println("Client connected to server at " + ctx.channel().remoteAddress());
            FServerManager.this.updateLobbyState();
            super.channelActive(ctx);
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            RemoteClient client = (RemoteClient)FServerManager.this.clients.get(ctx.channel());
            if (msg instanceof LoginEvent) {
                String username = ((LoginEvent)msg).getUsername();
                client.setUsername(username);
                FServerManager.this.broadcast(new MessageEvent(String.format("%s joined the room", username)));
                FServerManager.this.updateLobbyState();
            } else if (msg instanceof UpdateLobbyPlayerEvent) {
                FServerManager.this.localLobby.applyToSlot(client.getIndex(), (UpdateLobbyPlayerEvent)msg);
            }
            super.channelRead(ctx, msg);
        }
    }

    private class MessageHandler
    extends ChannelInboundHandlerAdapter {
        private MessageHandler() {
        }

        @Override
        public final void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            RemoteClient client = (RemoteClient)FServerManager.this.clients.get(ctx.channel());
            if (msg instanceof MessageEvent) {
                FServerManager.this.broadcast(new MessageEvent(client.getUsername(), ((MessageEvent)msg).getMessage()));
            }
            super.channelRead(ctx, msg);
        }
    }
}

