/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.net.client;

import com.google.common.collect.Lists;
import forge.game.Game;
import forge.game.GameRules;
import forge.game.GameType;
import forge.game.GameView;
import forge.game.Match;
import forge.game.player.PlayerView;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.match.LobbySlot;
import forge.gamemodes.net.GameProtocolHandler;
import forge.gamemodes.net.IRemote;
import forge.gamemodes.net.ProtocolMethod;
import forge.gamemodes.net.ReplyPool;
import forge.gamemodes.net.client.ClientGameLobby;
import forge.gamemodes.net.client.FGameClient;
import forge.gamemodes.net.event.LoginEvent;
import forge.gui.interfaces.IGuiGame;
import forge.interfaces.ILobbyListener;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.LobbyPlayerHuman;
import forge.player.PlayerZoneUpdate;
import forge.player.PlayerZoneUpdates;
import forge.trackable.TrackableCollection;
import forge.trackable.TrackableObject;
import forge.trackable.TrackableTypes;
import forge.trackable.Tracker;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;

final class GameClientHandler
extends GameProtocolHandler<IGuiGame> {
    private final FGameClient client;
    private final IGuiGame gui;
    private Tracker tracker;
    private Match match;
    private Game game;

    public GameClientHandler(FGameClient client) {
        super(true);
        this.client = client;
        this.gui = client.getGui();
        this.tracker = null;
        this.match = null;
        this.game = null;
    }

    @Override
    protected ReplyPool getReplyPool(ChannelHandlerContext ctx) {
        return this.client.getReplyPool();
    }

    @Override
    protected IRemote getRemote(ChannelHandlerContext ctx) {
        return this.client;
    }

    @Override
    protected IGuiGame getToInvoke(ChannelHandlerContext ctx) {
        return this.gui;
    }

    @Override
    protected void beforeCall(ProtocolMethod protocolMethod, Object[] args) {
        switch (protocolMethod) {
            case openView: {
                if (this.match == null) {
                    this.match = this.createMatch();
                }
                this.game = this.createGame();
                this.tracker = this.createTracker();
                for (PlayerView myPlayer : (TrackableCollection)args[0]) {
                    if (myPlayer.getTracker() != null) continue;
                    myPlayer.setTracker(this.tracker);
                }
                TrackableCollection myPlayers = (TrackableCollection)args[0];
                this.client.setGameControllers(myPlayers);
                break;
            }
        }
        if (this.tracker != null) {
            this.updateTrackers(args);
            this.replicateProps(args);
        }
    }

    private GameRules createGameRules(GameType gameType, GameView gameView) {
        GameRules gameRules = new GameRules(gameType);
        gameRules.setAppliedVariants(Collections.singleton(gameType));
        gameRules.setGamesPerMatch(gameView.getNumGamesInMatch());
        gameRules.setPoisonCountersToLose(gameView.getPoisonCountersToLose());
        return gameRules;
    }

    private GameType getGameType() {
        List<ILobbyListener> lobbyListeners = this.client.getLobbyListeners();
        ILobbyListener lobbyListener = lobbyListeners.get(0);
        ClientGameLobby myLobby = lobbyListener.getLobby();
        return myLobby.getGameType();
    }

    private Match createMatch() {
        IGuiGame gui = this.client.getGui();
        GameView gameView = gui.getGameView();
        GameType gameType = this.getGameType();
        GameRules gameRules = this.createGameRules(gameType, gameView);
        List<RegisteredPlayer> registeredPlayers = this.createRegisteredPlayers(gameType);
        String title = gameView.getTitle();
        Match match = new Match(gameRules, registeredPlayers, title);
        return match;
    }

    private Game createGame() {
        this.tracker = null;
        return this.match.createGame();
    }

    private Tracker createTracker() {
        this.gui.setGameView(null);
        this.gui.setGameView(this.game.getView());
        return this.gui.getGameView().getTracker();
    }

    private List<RegisteredPlayer> createRegisteredPlayers(GameType gameType) {
        List<ILobbyListener> lobbyListeners = this.client.getLobbyListeners();
        ILobbyListener lobbyListener = lobbyListeners.get(0);
        ClientGameLobby myLobby = lobbyListener.getLobby();
        ArrayList<RegisteredPlayer> players = Lists.newArrayList();
        int playerCount = myLobby.getNumberOfSlots();
        for (int i = 0; i < playerCount; ++i) {
            LobbySlot playerSlot = myLobby.getSlot(i);
            RegisteredPlayer player = RegisteredPlayer.forVariants(playerCount, Collections.singleton(gameType), playerSlot.getDeck(), null, false, null, null);
            LobbyPlayerHuman lobbyPlayer = new LobbyPlayerHuman(playerSlot.getName(), playerSlot.getAvatarIndex(), playerSlot.getSleeveIndex());
            player.setPlayer(lobbyPlayer);
            player.setTeamNumber(playerSlot.getTeam());
            players.add(player);
        }
        ArrayList<RegisteredPlayer> sortedPlayers = Lists.newArrayList(players);
        sortedPlayers.sort((p1, p2) -> {
            int v1 = p1.getPlayer() instanceof LobbyPlayerHuman ? 0 : 1;
            int v2 = p2.getPlayer() instanceof LobbyPlayerHuman ? 0 : 1;
            return Integer.compare(v1, v2);
        });
        return sortedPlayers;
    }

    private void updateTrackers(Object[] objs) {
        for (Object obj : objs) {
            if (obj instanceof TrackableObject) {
                TrackableObject trackableObject = (TrackableObject)obj;
                if (trackableObject.getTracker() != null) continue;
                trackableObject.setTracker(this.tracker);
                EnumMap props = (EnumMap)trackableObject.getProps();
                if (props == null) continue;
                for (Object propObj : props.values()) {
                    this.updateTrackers(new Object[]{propObj});
                }
                continue;
            }
            if (!(obj instanceof TrackableCollection)) continue;
            TrackableCollection collection = (TrackableCollection)obj;
            for (Object objCollection : collection) {
                this.updateTrackers(new Object[]{objCollection});
            }
        }
    }

    private void replicateProps(Object[] objs) {
        for (Object obj : objs) {
            if (obj instanceof PlayerView) {
                this.replicatePlayerView((PlayerView)obj);
                continue;
            }
            if (obj instanceof PlayerZoneUpdate) {
                this.replicatePlayerView(((PlayerZoneUpdate)obj).getPlayer());
                continue;
            }
            if (!(obj instanceof PlayerZoneUpdates)) continue;
            Iterator<PlayerZoneUpdate> itrPlayerZoneUpdates = ((PlayerZoneUpdates)obj).iterator();
            while (itrPlayerZoneUpdates.hasNext()) {
                PlayerView newPlayerView = itrPlayerZoneUpdates.next().getPlayer();
                this.updateTrackers(new Object[]{newPlayerView});
                this.replicatePlayerView(newPlayerView);
            }
        }
    }

    private void replicatePlayerView(PlayerView newPlayerView) {
        PlayerView existingPlayerView = this.tracker.getObj(TrackableTypes.PlayerViewType, newPlayerView.getId());
        existingPlayerView.copyChangedProps(newPlayerView);
        System.err.println("replicated PlayerView properties - " + existingPlayerView.toString());
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        ctx.channel().writeAndFlush(new LoginEvent(FModel.getPreferences().getPref(ForgePreferences.FPref.PLAYER_NAME), Integer.parseInt(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AVATARS).split(",")[0]), Integer.parseInt(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_SLEEVES).split(",")[0])));
    }
}

