/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.net;

import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ChatMessage {
    private static final ForgePreferences prefs = FModel.getPreferences();
    private static final SimpleDateFormat inFormat = new SimpleDateFormat("HH:mm:ss");
    private final String source;
    private final String message;
    private final String timestamp;

    public ChatMessage(String source0, String message0) {
        this.source = source0;
        this.message = message0;
        this.timestamp = inFormat.format(new Date());
    }

    public boolean isLocal() {
        return this.source == null || this.source.equals(prefs.getPref(ForgePreferences.FPref.PLAYER_NAME));
    }

    public String getSource() {
        return this.source;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getFormattedMessage() {
        if (this.source == null) {
            return String.format("[%s] %s", this.timestamp, this.message);
        }
        return String.format("[%s] %s: %s", this.timestamp, this.source, this.message);
    }
}

