/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import com.google.common.collect.Maps;
import forge.card.ColorSet;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostShard;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.gamemodes.match.input.InputSelectManyBase;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.PlayerControllerHuman;
import forge.util.ITriggerEvent;
import forge.util.TextUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class InputSelectCardsForConvokeOrImprovise
extends InputSelectManyBase<Card> {
    private static final long serialVersionUID = -1779224307654698954L;
    private final Map<Card, ManaCostShard> chosenCards = new HashMap<Card, ManaCostShard>();
    private final ManaCostBeingPaid remainingCost;
    private final Player player;
    private final CardCollectionView availableCards;
    private final boolean improvise;
    private final String cardType;
    private final String description;

    public InputSelectCardsForConvokeOrImprovise(PlayerControllerHuman controller, Player p, ManaCost cost, CardCollectionView untapped, boolean impr, SpellAbility sa) {
        super(controller, 0, Math.min(cost.getCMC(), untapped.size()), sa);
        this.remainingCost = new ManaCostBeingPaid(cost);
        this.player = p;
        this.availableCards = untapped;
        this.improvise = impr;
        this.cardType = impr ? "artifact" : "creature";
        this.description = impr ? "Improvise" : "Convoke";
    }

    @Override
    protected String getMessage() {
        StringBuilder sb = new StringBuilder();
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_DETAILED_SPELLDESC_IN_PROMPT) && this.sa != null) {
            sb.append(this.sa.getStackDescription()).append("\n");
        }
        sb.append(TextUtil.concatNoSpace("Choose ", this.cardType, " to tap for ", this.description, ".\nRemaining mana cost is ", this.remainingCost.toString()));
        return sb.toString();
    }

    @Override
    protected boolean onCardSelected(Card card, List<Card> otherCardsToSelect, ITriggerEvent triggerEvent) {
        if (!this.availableCards.contains(card)) {
            return false;
        }
        boolean entityWasSelected = this.chosenCards.containsKey(card);
        if (entityWasSelected) {
            ManaCostShard color = this.chosenCards.remove(card);
            this.remainingCost.increaseShard(color, 1);
            this.onSelectStateChanged(card, false);
        } else {
            byte chosenColor;
            if (this.improvise) {
                chosenColor = ManaCostShard.COLORLESS.getColorMask();
            } else {
                ColorSet colors = card.getColor();
                if (colors.isMulticolor()) {
                    colors = ColorSet.fromMask(colors.getColor() & this.remainingCost.getUnpaidColors());
                }
                chosenColor = colors.isMulticolor() ? this.player.getController().chooseColorAllowColorless("Convoke " + card.toString() + "  for which color?", card, colors) : colors.getColor();
            }
            ManaCostShard shard = this.remainingCost.payManaViaConvoke(chosenColor);
            if (shard != null) {
                this.chosenCards.put(card, shard);
                this.onSelectStateChanged(card, true);
            } else {
                this.showMessage("The colors provided by " + card.toString() + " you've chosen cannot be used to pay the manacost of " + this.remainingCost.toString());
                return false;
            }
        }
        this.refresh();
        return true;
    }

    @Override
    public String getActivateAction(Card card) {
        if (this.availableCards.contains(card)) {
            return TextUtil.concatNoSpace("tap ", this.cardType, " for ", this.description);
        }
        return null;
    }

    @Override
    protected void onPlayerSelected(Player player, ITriggerEvent triggerEvent) {
    }

    public Map<Card, ManaCostShard> getConvokeMap() {
        if (this.hasCancelled()) {
            return Maps.newHashMap();
        }
        return this.chosenCards;
    }

    @Override
    protected boolean hasEnoughTargets() {
        return true;
    }

    @Override
    protected boolean hasAllTargets() {
        return false;
    }

    @Override
    public Collection<Card> getSelected() {
        return this.chosenCards.keySet();
    }
}

