/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.player.Player;
import forge.game.zone.ZoneType;
import forge.gamemodes.match.input.InputSyncronizedBase;
import forge.player.PlayerControllerHuman;
import forge.util.ITriggerEvent;
import forge.util.Localizer;
import java.util.List;

public class InputLondonMulligan
extends InputSyncronizedBase {
    private static final long serialVersionUID = -8112954113001155622L;
    private final CardCollection selected = new CardCollection();
    private final Player player;
    private final int toReturn;
    volatile boolean cardSelectLocked = false;

    public InputLondonMulligan(PlayerControllerHuman controller, Player humanPlayer, int returning) {
        super(controller);
        this.player = humanPlayer;
        this.toReturn = returning;
    }

    @Override
    public final void showMessage() {
        Localizer localizer = Localizer.getInstance();
        Game game = this.player.getGame();
        game.getView().updateIsMulligan(true);
        int cardsLeft = this.toReturn - this.selected.size();
        StringBuilder sb = new StringBuilder();
        this.getController().getGui().updateButtons(this.getOwner(), localizer.getMessage("lblOK", new Object[0]), localizer.getMessage("lblAuto", new Object[0]), cardsLeft == 0, cardsLeft != 0, true);
        sb.append(String.format(localizer.getMessage("lblReturnForLondon", new Object[0]), cardsLeft));
        this.showMessage(sb.toString());
    }

    @Override
    protected final boolean allowAwaitNextInput() {
        return true;
    }

    @Override
    protected final void onOk() {
        this.cardSelectLocked = true;
        this.done();
    }

    @Override
    protected final void onCancel() {
        int cardsLeft = this.toReturn - this.selected.size();
        int count = 0;
        for (Card c : this.player.getZone(ZoneType.Hand).getCards()) {
            if (this.selected.contains(c)) continue;
            this.selected.add(c);
            this.setCardHighlight(c, this.selected.contains(c));
            if (cardsLeft != ++count) continue;
            break;
        }
        this.onOk();
    }

    private void done() {
        this.resetCardHighlights();
        this.getController().getGame().getView().updateIsMulligan(false);
        this.stop();
    }

    @Override
    protected boolean onCardSelected(Card c0, List<Card> otherCardsToSelect, ITriggerEvent triggerEvent) {
        boolean fromHand = this.player.getZone(ZoneType.Hand).contains(c0);
        if (!fromHand || this.cardSelectLocked) {
            return false;
        }
        if (this.selected.contains(c0)) {
            this.selected.remove(c0);
        } else if (this.selected.size() < this.toReturn) {
            this.selected.add(c0);
        }
        this.setCardHighlight(c0, this.selected.contains(c0));
        this.showMessage();
        return true;
    }

    public CardCollectionView getSelectedCards() {
        return this.selected;
    }

    @Override
    public String getActivateAction(Card card) {
        return null;
    }

    private void setCardHighlight(Card card, boolean state) {
        this.getController().getGui().setUsedToPay(card.getView(), state);
    }

    private void resetCardHighlights() {
        for (Card c : this.selected) {
            this.getController().getGui().setUsedToPay(c.getView(), false);
        }
    }
}

