/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import forge.game.GameView;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.event.GameEventSpellAbilityCast;
import forge.game.event.GameEventSpellRemovedFromStack;
import forge.game.player.PlayerView;
import forge.gamemodes.match.NextGameDecision;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.control.PlaybackSpeed;
import forge.gui.interfaces.IGuiGame;
import forge.gui.interfaces.IMayViewCards;
import forge.interfaces.IGameController;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.player.PlayerControllerHuman;
import forge.trackable.TrackableCollection;
import forge.trackable.TrackableTypes;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractGuiGame
implements IGuiGame,
IMayViewCards {
    private PlayerView currentPlayer = null;
    private IGameController spectator = null;
    private final Map<PlayerView, IGameController> gameControllers = Maps.newHashMap();
    private final Map<PlayerView, IGameController> originalGameControllers = Maps.newHashMap();
    private boolean gamePause = false;
    private boolean gameSpeed = false;
    private PlaybackSpeed playbackSpeed = PlaybackSpeed.NORMAL;
    private String daytime = null;
    private boolean ignoreConcedeChain = false;
    private GameView gameView = null;
    private final Set<PlayerView> highlightedPlayers = Sets.newHashSet();
    private final Set<CardView> highlightedCards = Sets.newHashSet();
    private final Set<CardView> selectableCards = Sets.newHashSet();
    private final Set<PlayerView> autoPassUntilEndOfTurn = Sets.newHashSet();
    private Timer awaitNextInputTimer;
    private TimerTask awaitNextInputTask;
    private final Set<String> autoYields = Sets.newHashSet();
    private boolean disableAutoYields;
    private final Map<Integer, Boolean> triggersAlwaysAccept = Maps.newTreeMap();

    public final boolean hasLocalPlayers() {
        return !this.gameControllers.isEmpty();
    }

    public final Set<PlayerView> getLocalPlayers() {
        return this.gameControllers.keySet();
    }

    public final int getLocalPlayerCount() {
        return this.gameControllers.size();
    }

    public final boolean isLocalPlayer(PlayerView player) {
        return this.gameControllers.containsKey(player);
    }

    public final PlayerView getCurrentPlayer() {
        return this.currentPlayer;
    }

    @Override
    public String getDayTime() {
        return this.daytime;
    }

    @Override
    public void updateDayTime(String daytime) {
        this.daytime = daytime;
    }

    @Override
    public final void setCurrentPlayer(PlayerView player) {
        player = TrackableTypes.PlayerViewType.lookup(player);
        if (this.hasLocalPlayers() && !this.isLocalPlayer(player)) {
            if (GuiBase.getInterface().isLibgdxPort() && this.spectator != null) {
                this.currentPlayer = null;
                this.updateCurrentPlayer(null);
                this.gameControllers.clear();
                return;
            }
            throw new IllegalArgumentException();
        }
        this.currentPlayer = player;
        this.updateCurrentPlayer(player);
    }

    protected abstract void updateCurrentPlayer(PlayerView var1);

    @Override
    public final GameView getGameView() {
        return this.gameView;
    }

    @Override
    public void setGameView(GameView gameView0) {
        if (this.gameView == null || gameView0 == null) {
            if (gameView0 != null) {
                gameView0.updateObjLookup();
            }
            this.gameView = gameView0;
            return;
        }
        this.gameView.copyChangedProps(gameView0);
    }

    public final IGameController getGameController() {
        return this.getGameController(this.getCurrentPlayer());
    }

    public final IGameController getGameController(PlayerView player) {
        if (player == null) {
            return this.spectator;
        }
        return this.gameControllers.get(player);
    }

    public final Collection<IGameController> getOriginalGameControllers() {
        return this.originalGameControllers.values();
    }

    @Override
    public void setOriginalGameController(PlayerView player, IGameController gameController) {
        if (player == null || gameController == null) {
            throw new IllegalArgumentException();
        }
        player = TrackableTypes.PlayerViewType.lookup(player);
        boolean doSetCurrentPlayer = this.originalGameControllers.isEmpty();
        this.originalGameControllers.put(player, gameController);
        this.gameControllers.put(player, gameController);
        if (doSetCurrentPlayer) {
            this.setCurrentPlayer(player);
        }
    }

    @Override
    public void setGameController(PlayerView player, IGameController gameController) {
        if (player == null) {
            throw new IllegalArgumentException();
        }
        player = TrackableTypes.PlayerViewType.lookup(player);
        if (gameController == null) {
            if (this.originalGameControllers.containsKey(player)) {
                this.gameControllers.put(player, this.originalGameControllers.get(player));
            } else {
                this.gameControllers.remove(player);
                this.autoPassUntilEndOfTurn.remove(player);
                PlayerView currentPlayer = this.getCurrentPlayer();
                if (player.equals(currentPlayer)) {
                    this.setCurrentPlayer(Iterables.getFirst(this.gameControllers.keySet(), null));
                }
            }
        } else {
            this.gameControllers.put(player, gameController);
        }
    }

    @Override
    public void setSpectator(IGameController spectator) {
        this.spectator = spectator;
    }

    @Override
    public final void updateSingleCard(CardView card) {
        this.updateCards(Collections.singleton(card));
    }

    @Override
    public void updateRevealedCards(TrackableCollection<CardView> collection) {
        if (this.gameView != null) {
            TrackableCollection<CardView> existing = this.gameView.getRevealedCollection();
            if (existing != null) {
                collection.addAll((Collection<CardView>)existing);
            }
            this.gameView.updateRevealedCards(collection);
        }
    }

    @Override
    public void refreshCardDetails(Iterable<CardView> cards) {
    }

    @Override
    public void refreshField() {
    }

    @Override
    public boolean mayView(CardView c) {
        block9: {
            if (!this.hasLocalPlayers()) {
                return true;
            }
            if (GuiBase.getInterface().isLibgdxPort()) {
                if (this.gameView != null && this.gameView.isGameOver()) {
                    return true;
                }
                if (this.spectator != null) {
                    for (Map.Entry<PlayerView, IGameController> e : this.gameControllers.entrySet()) {
                        if (!e.getValue().equals(this.spectator)) continue;
                        this.gameControllers.remove(e.getKey());
                        break;
                    }
                    return true;
                }
                try {
                    if (this.getGameController().mayLookAtAllCards()) {
                        return true;
                    }
                    break block9;
                }
                catch (NullPointerException e) {
                    return true;
                }
            }
            if (this.getGameController().mayLookAtAllCards()) {
                return true;
            }
        }
        return c.canBeShownToAny(this.getLocalPlayers());
    }

    @Override
    public boolean mayFlip(CardView cv) {
        if (cv == null) {
            return false;
        }
        CardView.CardStateView altState = cv.getAlternateState();
        if (altState == null) {
            return false;
        }
        switch (altState.getState()) {
            case Original: {
                if (cv.isFaceDown()) {
                    return this.getCurrentPlayer() == null || cv.canFaceDownBeShownToAny(this.getLocalPlayers());
                }
                return true;
            }
            case Flipped: 
            case Transformed: 
            case Meld: 
            case Modal: {
                return true;
            }
            case Adventure: {
                if (cv.isFaceDown()) {
                    return this.getCurrentPlayer() == null || cv.canFaceDownBeShownToAny(this.getLocalPlayers());
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void setHighlighted(PlayerView pv, boolean b) {
        boolean hasChanged;
        boolean bl = hasChanged = b ? this.highlightedPlayers.add(pv) : this.highlightedPlayers.remove(pv);
        if (hasChanged) {
            this.updateLives(Collections.singleton(pv));
        }
    }

    public boolean isHighlighted(PlayerView player) {
        return this.highlightedPlayers.contains(player);
    }

    @Override
    public void setUsedToPay(CardView card, boolean value) {
        boolean hasChanged;
        boolean bl = hasChanged = value ? this.highlightedCards.add(card) : this.highlightedCards.remove(card);
        if (hasChanged) {
            this.updateSingleCard(card);
        }
    }

    public boolean isUsedToPay(CardView card) {
        return this.highlightedCards.contains(card);
    }

    @Override
    public void setSelectables(Iterable<CardView> cards) {
        for (CardView cv : cards) {
            this.selectableCards.add(cv);
        }
    }

    @Override
    public void clearSelectables() {
        this.selectableCards.clear();
    }

    public boolean isSelectable(CardView card) {
        return this.selectableCards.contains(card);
    }

    @Override
    public boolean isSelecting() {
        return !this.selectableCards.isEmpty();
    }

    @Override
    public boolean isGamePaused() {
        return this.gamePause;
    }

    public boolean isGameFast() {
        return this.gameSpeed;
    }

    @Override
    public void setgamePause(boolean pause) {
        this.gamePause = pause;
    }

    @Override
    public void setGameSpeed(PlaybackSpeed speed) {
        this.playbackSpeed = speed;
    }

    public void pauseMatch() {
        IGameController controller = this.spectator;
        if (controller != null && !this.isGamePaused()) {
            controller.selectButtonOk();
        }
    }

    public void resumeMatch() {
        IGameController controller = this.spectator;
        if (controller != null && this.isGamePaused()) {
            controller.selectButtonOk();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean concede() {
        if (this.gameView.isGameOver()) {
            return true;
        }
        if (this.hasLocalPlayers()) {
            boolean concedeNeeded = false;
            for (IGameController c : this.getOriginalGameControllers()) {
                if (!(c instanceof PlayerControllerHuman) || ((PlayerControllerHuman)c).getPlayer().getOutcome() != null) continue;
                concedeNeeded = true;
            }
            if (concedeNeeded) {
                if (this.gameView.isMulligan()) {
                    this.showErrorDialog(Localizer.getInstance().getMessage("lblWaitingforActions", new Object[0]));
                    return false;
                }
                if (!this.showConfirmDialog(Localizer.getInstance().getMessage("lblConcedeCurrentGame", new Object[0]), Localizer.getInstance().getMessage("lblConcedeTitle", new Object[0]), Localizer.getInstance().getMessage("lblConcede", new Object[0]), Localizer.getInstance().getMessage("lblCancel", new Object[0]))) return false;
                for (IGameController c : this.getOriginalGameControllers()) {
                    c.concede();
                }
            } else {
                if (this.ignoreConcedeChain) return false;
                return true;
            }
            if (this.gameView.isGameOver()) {
                return false;
            }
            this.ignoreConcedeChain = true;
            for (PlayerView player : this.getLocalPlayers()) {
                if (player.isAI()) continue;
                this.getGameController(player).nextGameDecision(NextGameDecision.QUIT);
            }
            this.ignoreConcedeChain = false;
            return false;
        }
        if (this.spectator == null) {
            return true;
        }
        if (!this.showConfirmDialog(Localizer.getInstance().getMessage("lblCloseGameSpectator", new Object[0]), Localizer.getInstance().getMessage("lblCloseGame", new Object[0]), Localizer.getInstance().getMessage("lblClose", new Object[0]), Localizer.getInstance().getMessage("lblCancel", new Object[0]))) return false;
        IGameController controller = this.spectator;
        this.spectator = null;
        if (!this.isGamePaused()) {
            controller.selectButtonOk();
        }
        controller.nextGameDecision(NextGameDecision.QUIT);
        return false;
    }

    public String getConcedeCaption() {
        if (this.hasLocalPlayers()) {
            return Localizer.getInstance().getMessage("lblConcede", new Object[0]);
        }
        return Localizer.getInstance().getMessage("lblStopWatching", new Object[0]);
    }

    @Override
    public void updateButtons(PlayerView owner, boolean okEnabled, boolean cancelEnabled, boolean focusOk) {
        this.updateButtons(owner, Localizer.getInstance().getMessage("lblOK", new Object[0]), Localizer.getInstance().getMessage("lblCancel", new Object[0]), okEnabled, cancelEnabled, focusOk);
    }

    @Override
    public final void autoPassUntilEndOfTurn(PlayerView player) {
        this.autoPassUntilEndOfTurn.add(player);
        this.updateAutoPassPrompt();
    }

    @Override
    public final void autoPassCancel(PlayerView player) {
        if (!this.autoPassUntilEndOfTurn.remove(player)) {
            return;
        }
        PlayerView playerView = this.getCurrentPlayer();
        this.showPromptMessage(playerView, "");
        this.updateButtons(playerView, false, false, false);
        this.awaitNextInput();
    }

    @Override
    public final boolean mayAutoPass(PlayerView player) {
        return this.autoPassUntilEndOfTurn.contains(player);
    }

    @Override
    public final void awaitNextInput() {
        this.checkAwaitNextInputTimer();
        this.awaitNextInputTask = new TimerTask(){

            @Override
            public void run() {
                FThreads.invokeInEdtLater(() -> {
                    AbstractGuiGame.this.checkAwaitNextInputTimer();
                    Timer timer = AbstractGuiGame.this.awaitNextInputTimer;
                    synchronized (timer) {
                        if (AbstractGuiGame.this.awaitNextInputTask != null) {
                            AbstractGuiGame.this.updatePromptForAwait(AbstractGuiGame.this.getCurrentPlayer());
                            AbstractGuiGame.this.awaitNextInputTask = null;
                        }
                    }
                });
            }
        };
        this.awaitNextInputTimer.schedule(this.awaitNextInputTask, 250L);
    }

    private void checkAwaitNextInputTimer() {
        if (this.awaitNextInputTimer == null) {
            String name = "?";
            if (this.currentPlayer != null) {
                name = this.currentPlayer.getLobbyPlayerName();
            }
            this.awaitNextInputTimer = new Timer("awaitNextInputTimer Game:" + this.gameView.getId() + " Player:" + name);
        }
    }

    protected final void updatePromptForAwait(PlayerView playerView) {
        this.showPromptMessage(playerView, Localizer.getInstance().getMessage("lblWaitingForOpponent", new Object[0]));
        this.updateButtons(playerView, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancelAwaitNextInput() {
        if (this.awaitNextInputTimer == null) {
            return;
        }
        Timer timer = this.awaitNextInputTimer;
        synchronized (timer) {
            if (this.awaitNextInputTask != null) {
                try {
                    this.awaitNextInputTask.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.awaitNextInputTask = null;
            }
        }
    }

    @Override
    public final void updateAutoPassPrompt() {
        if (!this.autoPassUntilEndOfTurn.isEmpty()) {
            this.cancelAwaitNextInput();
            this.showPromptMessage(this.getCurrentPlayer(), Localizer.getInstance().getMessage("lblYieldingUntilEndOfTurn", new Object[0]));
            this.updateButtons(this.getCurrentPlayer(), false, true, false);
        }
    }

    public final Iterable<String> getAutoYields() {
        return this.autoYields;
    }

    @Override
    public final boolean shouldAutoYield(String key) {
        String abilityKey = key.contains("): ") ? key.substring(key.indexOf("): ") + 3) : key;
        boolean yieldPerAbility = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AUTO_YIELD_MODE).equals("Per Ability (Each Match)");
        return !this.getDisableAutoYields() && this.autoYields.contains(yieldPerAbility ? abilityKey : key);
    }

    @Override
    public final void setShouldAutoYield(String key, boolean autoYield) {
        String abilityKey = key.contains("): ") ? key.substring(key.indexOf("): ") + 3) : key;
        boolean yieldPerAbility = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AUTO_YIELD_MODE).equals("Per Ability (Each Match)");
        if (autoYield) {
            this.autoYields.add(yieldPerAbility ? abilityKey : key);
        } else {
            this.autoYields.remove(yieldPerAbility ? abilityKey : key);
        }
    }

    public final boolean getDisableAutoYields() {
        return this.disableAutoYields;
    }

    public final void setDisableAutoYields(boolean b0) {
        this.disableAutoYields = b0;
    }

    @Override
    public final void clearAutoYields() {
        this.autoYields.clear();
        this.triggersAlwaysAccept.clear();
    }

    @Override
    public final boolean shouldAlwaysAcceptTrigger(int trigger) {
        return Boolean.TRUE.equals(this.triggersAlwaysAccept.get(trigger));
    }

    @Override
    public final boolean shouldAlwaysDeclineTrigger(int trigger) {
        return Boolean.FALSE.equals(this.triggersAlwaysAccept.get(trigger));
    }

    @Override
    public final void setShouldAlwaysAcceptTrigger(int trigger) {
        this.triggersAlwaysAccept.put(trigger, Boolean.TRUE);
    }

    @Override
    public final void setShouldAlwaysDeclineTrigger(int trigger) {
        this.triggersAlwaysAccept.put(trigger, Boolean.FALSE);
    }

    @Override
    public final void setShouldAlwaysAskTrigger(int trigger) {
        this.triggersAlwaysAccept.remove(trigger);
    }

    @Override
    public <T> T oneOrNone(String message, List<T> choices) {
        if (choices == null || choices.isEmpty()) {
            return null;
        }
        List<T> choice = this.getChoices(message, 0, 1, choices);
        return choice.isEmpty() ? null : (T)choice.get(0);
    }

    @Override
    public <T> T one(String message, List<T> choices) {
        if (choices == null || choices.isEmpty()) {
            return null;
        }
        if (choices.size() == 1) {
            return Iterables.getFirst(choices, null);
        }
        List<T> choice = this.getChoices(message, 1, 1, choices);
        assert (choice.size() == 1);
        return choice.get(0);
    }

    @Override
    public <T> void reveal(String message, List<T> items) {
        this.getChoices(message, -1, -1, items);
    }

    @Override
    public Integer getInteger(String message, int min2) {
        return this.getInteger(message, min2, Integer.MAX_VALUE, false);
    }

    @Override
    public Integer getInteger(String message, int min2, int max) {
        return this.getInteger(message, min2, max, false);
    }

    @Override
    public Integer getInteger(String message, int min2, int max, boolean sortDesc) {
        if (max <= min2) {
            return min2;
        }
        if (max == Integer.MAX_VALUE) {
            return this.getInteger(message, min2, max, min2 + 99);
        }
        int count = max - min2 + 1;
        if (count > 100) {
            return this.getInteger(message, min2, max, min2 + 99);
        }
        Integer[] choices = new Integer[count];
        if (sortDesc) {
            for (int i = 0; i < count; ++i) {
                choices[count - i - 1] = i + min2;
            }
        } else {
            for (int i = 0; i < count; ++i) {
                choices[i] = i + min2;
            }
        }
        return this.oneOrNone(message, ImmutableList.copyOf(choices));
    }

    @Override
    public Integer getInteger(String message, int min2, int max, int cutoff) {
        int val;
        String str;
        if (max <= min2 || cutoff < min2) {
            return min2;
        }
        if (cutoff >= max) {
            return this.getInteger(message, min2, max);
        }
        ImmutableList.Builder choices = ImmutableList.builder();
        for (int i = min2; i <= cutoff; ++i) {
            choices.add((Object)i);
        }
        choices.add(Localizer.getInstance().getMessage("lblOtherInteger", new Object[0]));
        Object choice = this.oneOrNone(message, (List)((Object)choices.build()));
        if (choice instanceof Integer || choice == null) {
            return (Integer)choice;
        }
        Localizer localizer = Localizer.getInstance();
        String prompt = "";
        if (min2 != Integer.MIN_VALUE) {
            prompt = max != Integer.MAX_VALUE ? localizer.getMessage("lblEnterNumberBetweenMinAndMax", String.valueOf(min2), String.valueOf(max)) : localizer.getMessage("lblEnterNumberGreaterThanOrEqualsToMin", String.valueOf(min2));
        } else if (max != Integer.MAX_VALUE) {
            prompt = localizer.getMessage("lblEnterNumberLessThanOrEqualsToMax", String.valueOf(max));
        }
        do {
            if ((str = this.showInputDialog(prompt, message, true)) != null) continue;
            return null;
        } while (!StringUtils.isNumeric(str) || (val = Integer.parseInt(str)) < min2 || val > max);
        return val;
    }

    @Override
    public <T> List<T> getChoices(String message, int min2, int max, List<T> choices) {
        return this.getChoices(message, min2, max, choices, null, null);
    }

    @Override
    public <T> List<T> many(String title, String topCaption, int cnt, List<T> sourceChoices, CardView c) {
        return this.many(title, topCaption, cnt, cnt, sourceChoices, c);
    }

    @Override
    public <T> List<T> many(String title, String topCaption, int min2, int max, List<T> sourceChoices, CardView c) {
        if (max == 1) {
            return this.getChoices(title, min2, max, sourceChoices);
        }
        int m22 = min2 >= 0 ? sourceChoices.size() - min2 : -1;
        int m1 = max >= 0 ? sourceChoices.size() - max : -1;
        return this.order(title, topCaption, m1, m22, sourceChoices, null, c, false);
    }

    @Override
    public <T> List<T> order(String title, String top, List<T> sourceChoices, CardView c) {
        return this.order(title, top, 0, 0, sourceChoices, null, c, false);
    }

    @Override
    public <T> List<T> insertInList(String title, T newItem, List<T> oldItems) {
        T placeAfter = this.oneOrNone(title, oldItems);
        int indexAfter = placeAfter == null ? 0 : oldItems.indexOf(placeAfter) + 1;
        ArrayList<T> result = Lists.newArrayListWithCapacity(oldItems.size() + 1);
        result.addAll(oldItems);
        result.add(indexAfter, newItem);
        return result;
    }

    @Override
    public String showInputDialog(String message, String title, boolean isNumeric) {
        return this.showInputDialog(message, title, null, "", null, isNumeric);
    }

    @Override
    public String showInputDialog(String message, String title, FSkinProp icon) {
        return this.showInputDialog(message, title, icon, "", null, false);
    }

    @Override
    public String showInputDialog(String message, String title, FSkinProp icon, String initialInput) {
        return this.showInputDialog(message, title, icon, initialInput, null, false);
    }

    @Override
    public boolean confirm(CardView c, String question) {
        return this.confirm(c, question, true, null);
    }

    @Override
    public boolean confirm(CardView c, String question, List<String> options) {
        return this.confirm(c, question, true, options);
    }

    @Override
    public void message(String message) {
        this.message(message, "Forge");
    }

    @Override
    public void showErrorDialog(String message) {
        this.showErrorDialog(message, "Error");
    }

    @Override
    public boolean showConfirmDialog(String message, String title) {
        return this.showConfirmDialog(message, title, true);
    }

    @Override
    public boolean showConfirmDialog(String message, String title, boolean defaultYes) {
        return this.showConfirmDialog(message, title, Localizer.getInstance().getMessage("lblYes", new Object[0]), Localizer.getInstance().getMessage("lblNo", new Object[0]));
    }

    @Override
    public boolean showConfirmDialog(String message, String title, String yesButtonText, String noButtonText) {
        return this.showConfirmDialog(message, title, yesButtonText, noButtonText, true);
    }

    @Override
    public void notifyStackAddition(GameEventSpellAbilityCast event) {
    }

    @Override
    public void notifyStackRemoval(GameEventSpellRemovedFromStack event) {
    }

    @Override
    public void handleLandPlayed(Card land) {
    }

    @Override
    public void afterGameEnd() {
        if (this.awaitNextInputTimer != null) {
            this.awaitNextInputTimer.cancel();
            this.awaitNextInputTimer = null;
        }
        this.daytime = null;
    }
}

