/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import com.google.common.collect.Iterables;
import forge.card.CardRulesPredicates;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.gamemodes.limited.CardRanker;
import forge.gamemodes.limited.LimitedDeckBuilder;
import forge.item.PaperCard;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SealedDeckBuilder
extends LimitedDeckBuilder {
    public SealedDeckBuilder(List<PaperCard> list) {
        super(list);
        this.setColors(this.chooseColors());
    }

    private ColorSet chooseColors() {
        String color2;
        String color1;
        ArrayList<PaperCard> colorChooserList = new ArrayList<PaperCard>();
        List<PaperCard> initialRanked = CardRanker.rankCardsInDeck(this.getAiPlayables());
        double limit = (double)this.getAiPlayables().size() * 0.33;
        int i = 0;
        while ((double)i < limit) {
            PaperCard cp = initialRanked.get(i);
            colorChooserList.add(cp);
            ++i;
        }
        Iterable rules = Iterables.transform(colorChooserList, PaperCard::getRules);
        int white = Iterables.size(Iterables.filter(rules, CardRulesPredicates.Presets.IS_WHITE));
        int blue = Iterables.size(Iterables.filter(rules, CardRulesPredicates.Presets.IS_BLUE));
        int black = Iterables.size(Iterables.filter(rules, CardRulesPredicates.Presets.IS_BLACK));
        int red = Iterables.size(Iterables.filter(rules, CardRulesPredicates.Presets.IS_RED));
        int green = Iterables.size(Iterables.filter(rules, CardRulesPredicates.Presets.IS_GREEN));
        int[] colorCounts = new int[]{white, blue, black, red, green};
        int[] countsCopy = Arrays.copyOf(colorCounts, 5);
        Arrays.sort(countsCopy);
        ArrayList<String> maxColors = new ArrayList<String>();
        ArrayList<String> secondColors = new ArrayList<String>();
        for (int i2 = 0; i2 < 5; ++i2) {
            if (countsCopy[4] == colorCounts[i2]) {
                maxColors.add((String)MagicColor.Constant.ONLY_COLORS.get(i2));
                continue;
            }
            if (countsCopy[3] != colorCounts[i2]) continue;
            secondColors.add((String)MagicColor.Constant.ONLY_COLORS.get(i2));
        }
        if (maxColors.size() > 1) {
            int n = MyRandom.getRandom().nextInt(maxColors.size());
            color1 = (String)maxColors.get(n);
            maxColors.remove(n);
            n = MyRandom.getRandom().nextInt(maxColors.size());
            color2 = (String)maxColors.get(n);
        } else {
            color1 = (String)maxColors.get(0);
            color2 = secondColors.size() > 1 ? (String)secondColors.get(MyRandom.getRandom().nextInt(secondColors.size())) : (String)secondColors.get(0);
        }
        return ColorSet.fromNames(color1, color2);
    }
}

