/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import com.google.common.collect.Lists;
import forge.StaticData;
import forge.card.CardEdition;
import forge.card.MagicColor;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.deck.DeckSection;
import forge.gamemodes.limited.CustomLimited;
import forge.gamemodes.limited.LimitedDeckEvaluator;
import forge.gamemodes.limited.LimitedPoolType;
import forge.gamemodes.limited.SealedDeckBuilder;
import forge.gui.util.SGuiChoose;
import forge.gui.util.SOptionPane;
import forge.item.PaperCard;
import forge.item.SealedTemplate;
import forge.item.generation.IUnOpenedProduct;
import forge.item.generation.UnOpenedProduct;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.CardBlock;
import forge.model.FModel;
import forge.model.UnOpenedMeta;
import forge.util.FileUtil;
import forge.util.Localizer;
import forge.util.MyRandom;
import forge.util.TextUtil;
import forge.util.storage.IStorage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SealedCardPoolGenerator {
    public static final String FILE_EXT = ".sealed";
    private final List<IUnOpenedProduct> product = new ArrayList<IUnOpenedProduct>();
    private String landSetCode = null;

    public static DeckGroup generateSealedDeck(boolean addBasicLands) {
        String prompt = Localizer.getInstance().getMessage("lblChooseSealedDeckFormat", new Object[0]);
        LimitedPoolType poolType2 = SGuiChoose.oneOrNone(prompt, LimitedPoolType.values());
        if (poolType2 == null) {
            return null;
        }
        SealedCardPoolGenerator sd = new SealedCardPoolGenerator(poolType2);
        if (sd.isEmpty()) {
            return null;
        }
        CardPool humanPool = sd.getCardPool(true);
        if (humanPool == null) {
            return null;
        }
        int rounds = 7;
        String sDeckName = SOptionPane.showInputDialog(Localizer.getInstance().getMessage("lblSaveCardPoolAs", new Object[0]) + ":", Localizer.getInstance().getMessage("lblSaveCardPool", new Object[0]), FSkinProp.ICO_QUESTION);
        if (StringUtils.isBlank(sDeckName)) {
            return null;
        }
        IStorage<DeckGroup> sealedDecks = FModel.getDecks().getSealed();
        if (sealedDecks.contains(sDeckName)) {
            if (!SOptionPane.showConfirmDialog(Localizer.getInstance().getMessage("lblDeckExistsReplaceConfirm", sDeckName), Localizer.getInstance().getMessage("lblSealedDeckGameExists", new Object[0]))) {
                return null;
            }
            sealedDecks.delete(sDeckName);
        }
        Deck deck = new Deck(sDeckName);
        deck.getOrCreate(DeckSection.Sideboard).addAll(humanPool);
        if (addBasicLands) {
            int landsCount = 10;
            boolean isZendikarSet = sd.getLandSetCode().equals("ZEN");
            boolean zendikarSetMode = MyRandom.getRandom().nextBoolean();
            for (String element : MagicColor.Constant.BASIC_LANDS) {
                int maxArtIndex;
                int numArt = FModel.getMagicDb().getCommonCards().getArtCount(element, sd.getLandSetCode());
                int minArtIndex = isZendikarSet ? (zendikarSetMode ? 1 : 5) : 1;
                int n = maxArtIndex = isZendikarSet ? minArtIndex + 3 : numArt;
                if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_RANDOM_ART_IN_POOLS)) {
                    for (int i = minArtIndex; i <= maxArtIndex; ++i) {
                        deck.get(DeckSection.Sideboard).add(element, sd.getLandSetCode(), i, numArt > 1 ? 10 : 30);
                    }
                    continue;
                }
                deck.get(DeckSection.Sideboard).add(element, sd.getLandSetCode(), 30);
            }
        }
        DeckGroup sealed = new DeckGroup(sDeckName);
        deck.setDirectory(sealedDecks.getName());
        sealed.setHumanDeck(deck);
        for (int i = 0; i < rounds; ++i) {
            try {
                CardPool aiPool = sd.getCardPool(false);
                if (aiPool == null) {
                    return null;
                }
                sealed.addAiDeck(new SealedDeckBuilder(aiPool.toFlatList()).buildDeck(sd.getLandSetCode()));
                continue;
            }
            catch (IllegalStateException e) {
                System.out.println(e.toString());
                rounds = i;
            }
        }
        sealed.rankAiDecks(new LimitedDeckEvaluator.LimitedDeckComparer());
        FModel.getDecks().getSealed().add(sealed);
        return sealed;
    }

    private SealedCardPoolGenerator(LimitedPoolType poolType2) {
        switch (poolType2) {
            case Full: {
                if (!this.chooseNumberOfBoosters(new UnOpenedProduct(SealedTemplate.genericDraftBooster))) {
                    return;
                }
                this.landSetCode = CardEdition.Predicates.getRandomSetWithAllBasicLands(FModel.getMagicDb().getEditions()).getCode();
                break;
            }
            case Prerelease: {
                String[] parts;
                ArrayList<CardEdition> editions = Lists.newArrayList(StaticData.instance().getEditions().getPrereleaseEditions());
                Collections.sort(editions);
                Collections.reverse(editions);
                CardEdition chosenEdition = SGuiChoose.oneOrNone(Localizer.getInstance().getMessage("lblChooseAnEdition", new Object[0]), editions);
                if (chosenEdition == null) {
                    return;
                }
                String bundle = chosenEdition.getPrerelease();
                for (String part : parts = bundle.split(", ")) {
                    boolean promo = part.endsWith("+");
                    if (promo) {
                        part = part.substring(0, part.length() - 1);
                    }
                    String[] pieces = part.split(" ");
                    int num = Integer.parseInt(pieces[0]);
                    String thing = pieces[pieces.length - 1];
                    if (thing.equalsIgnoreCase("Booster") || thing.equalsIgnoreCase("Boosters")) {
                        String code = chosenEdition.getCode();
                        if (pieces.length > 2) {
                            code = pieces[1];
                        }
                        for (int i = 0; i < num; ++i) {
                            this.product.add(new UnOpenedProduct(FModel.getMagicDb().getBoosters().get(code)));
                        }
                        continue;
                    }
                    ArrayList<Pair<String, Integer>> promoSlot = new ArrayList<Pair<String, Integer>>();
                    promoSlot.add(Pair.of(pieces[1], num));
                    SealedTemplate promoProduct = new SealedTemplate("Prerelease Promo", promoSlot);
                    this.product.add(new UnOpenedProduct(promoProduct, FModel.getMagicDb().getCommonCards().getAllCards(chosenEdition)));
                }
                this.landSetCode = chosenEdition.getCode();
                break;
            }
            case Block: 
            case FantasyBlock: {
                ArrayList<CardBlock> blocks = new ArrayList<CardBlock>();
                IStorage<CardBlock> src = poolType2 == LimitedPoolType.Block ? FModel.getBlocks() : FModel.getFantasyBlocks();
                for (CardBlock b : src) {
                    blocks.add(b);
                }
                CardBlock block = (CardBlock)SGuiChoose.oneOrNone(Localizer.getInstance().getMessage("lblChooseBlock", new Object[0]), blocks);
                if (block == null) {
                    return;
                }
                int nPacks = block.getCntBoostersSealed();
                Stack<String> sets = new Stack<String>();
                for (CardEdition edition : block.getSets()) {
                    sets.add(edition.getCode());
                }
                for (String ms : block.getMetaSetNames()) {
                    sets.push(ms);
                }
                if (sets.size() > 1) {
                    String p;
                    List<String> setCombos = SealedCardPoolGenerator.getSetCombos(sets, nPacks);
                    if (setCombos == null || setCombos.isEmpty()) {
                        throw new RuntimeException("Unsupported amount of packs (" + nPacks + ") in a Sealed Deck block!");
                    }
                    String string = p = setCombos.size() > 1 ? SGuiChoose.oneOrNone(Localizer.getInstance().getMessage("lblChoosePackNumberToPlay", new Object[0]), setCombos) : setCombos.get(0);
                    if (p == null) {
                        return;
                    }
                    for (String pz : TextUtil.split(p, ',')) {
                        int nBoosters;
                        String[] pps = TextUtil.splitWithParenthesis(pz.trim(), ' ');
                        String setCode = pps[pps.length - 1];
                        int n = nBoosters = pps.length > 1 ? Integer.parseInt(pps[0]) : 1;
                        while (nBoosters-- > 0) {
                            this.product.add(block.getBooster(setCode));
                        }
                    }
                } else {
                    IUnOpenedProduct prod = block.getBooster((String)sets.get(0));
                    for (int i = 0; i < nPacks; ++i) {
                        this.product.add(prod);
                    }
                }
                this.landSetCode = block.getLandSet().getCode();
                break;
            }
            case Custom: {
                String[] dList;
                ArrayList<CustomLimited> customs = new ArrayList<CustomLimited>();
                File dFolder = new File(ForgeConstants.SEALED_DIR);
                if (!dFolder.exists()) {
                    throw new RuntimeException("GenerateSealed : folder not found -- folder is " + dFolder.getAbsolutePath());
                }
                if (!dFolder.isDirectory()) {
                    throw new RuntimeException("GenerateSealed : not a folder -- " + dFolder.getAbsolutePath());
                }
                for (String element : dList = dFolder.list()) {
                    List<String> dfData;
                    CustomLimited cs;
                    if (!element.endsWith(FILE_EXT) || (cs = CustomLimited.parse(dfData = FileUtil.readFile(ForgeConstants.SEALED_DIR + element), FModel.getDecks().getCubes())).getSealedProductTemplate().getNumberOfCardsExpected() <= 5) continue;
                    customs.add(cs);
                }
                if (customs.isEmpty()) {
                    SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblNotFoundCustomSealedFiles", new Object[0]));
                    return;
                }
                CustomLimited draft = (CustomLimited)SGuiChoose.oneOrNone(Localizer.getInstance().getMessage("lblChooseCustomSealedPool", new Object[0]), customs);
                if (draft == null) {
                    return;
                }
                UnOpenedProduct toAdd = new UnOpenedProduct(draft.getSealedProductTemplate(), draft.getCardPool());
                toAdd.setLimitedPool(draft.isSingleton());
                if (!this.chooseNumberOfBoosters(toAdd)) {
                    return;
                }
                this.landSetCode = draft.getLandSetCode();
            }
        }
    }

    private boolean chooseNumberOfBoosters(IUnOpenedProduct product1) {
        Integer boosterCount = SGuiChoose.getInteger(Localizer.getInstance().getMessage("lblHowManyBoosterPacks", new Object[0]), 3, 12);
        if (boosterCount == null) {
            return false;
        }
        for (int i = 0; i < boosterCount; ++i) {
            this.product.add(product1);
        }
        return true;
    }

    private static List<String> getSetCombos(List<String> setz, int nPacks) {
        String[] sets = setz.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        ArrayList<String> setCombos = new ArrayList<String>();
        if (nPacks == 3) {
            if (sets.length >= 2) {
                setCombos.add(TextUtil.concatNoSpace(sets[0], ", ", sets[0], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[1], ", ", sets[0], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[1], ", ", sets[1], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace("3 ", sets[1]));
            }
            if (sets.length >= 3) {
                setCombos.add(TextUtil.concatNoSpace(sets[2], ", ", sets[0], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[0], ", ", sets[2], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[2], ", ", sets[2], ", ", sets[2]));
                setCombos.add(TextUtil.concatNoSpace(sets[2], ", ", sets[1], ", ", sets[0]));
            }
        } else if (nPacks == 4) {
            if (sets.length >= 2) {
                setCombos.add(TextUtil.concatNoSpace(sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0]));
            }
            if (sets.length >= 3) {
                setCombos.add(TextUtil.concatNoSpace(sets[2], ", ", sets[2], ", ", sets[0], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[2], ", ", sets[1], ", ", sets[0], ", ", sets[0]));
            }
            if (sets.length >= 4) {
                setCombos.add(TextUtil.concatNoSpace(sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[0]));
            }
        } else if (nPacks == 5) {
            if (sets.length == 1 || !sets[0].equals(sets[1])) {
                setCombos.add(TextUtil.concatNoSpace("5 ", sets[0]));
            }
            if (sets.length >= 2 && !sets[0].equals(sets[1])) {
                setCombos.add(TextUtil.concatNoSpace("3 ", sets[0], ", 2 ", sets[1]));
                setCombos.add(TextUtil.concatNoSpace("2 ", sets[0], ", 3 ", sets[1]));
            }
            if (sets.length >= 3 && !sets[0].equals(sets[2])) {
                setCombos.add(TextUtil.concatNoSpace("3 ", sets[0], ", 2 ", sets[2]));
                setCombos.add(TextUtil.concatNoSpace("3 ", sets[0], ", ", sets[1], ", ", sets[2]));
                setCombos.add(TextUtil.concatNoSpace("2 ", sets[0], ", 2 ", sets[1], ", ", sets[2]));
            }
            if (sets.length >= 4) {
                if (sets[1].equals(sets[2]) && sets[1].equals(sets[0])) {
                    setCombos.add(TextUtil.concatNoSpace(sets[3], ", 4 ", sets[0]));
                } else {
                    setCombos.add(TextUtil.concatNoSpace(sets[3], ", ", sets[2], ", ", sets[1], ", 2 ", sets[0]));
                }
            }
            if (sets.length >= 5) {
                setCombos.add(TextUtil.concatNoSpace(sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[0]));
            }
        } else if (nPacks == 7 && (sets.length == 4 || sets.length >= 7)) {
            if (sets.length >= 7) {
                setCombos.add(TextUtil.concatNoSpace(sets[6], ", ", sets[5], ", ", sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[5], ", ", sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[0], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[3], ", ", sets[2], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[2], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[2], ", ", sets[2], ", ", sets[2], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[1], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
                setCombos.add(TextUtil.concatNoSpace(sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            } else if (sets.length == 4) {
                if (sets[1].equals(sets[2]) && sets[1].equals(sets[0])) {
                    setCombos.add(TextUtil.concatNoSpace(sets[3], ", 6 ", sets[0]));
                } else {
                    setCombos.add(TextUtil.concatNoSpace(sets[3], ", 2 ", sets[2], ", 2 ", sets[1], ", 2 ", sets[0]));
                }
            }
        } else if (nPacks == 8 && sets.length >= 8) {
            setCombos.add(TextUtil.concatNoSpace(sets[7], ", ", sets[6], ", ", sets[5], ", ", sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[6], ", ", sets[5], ", ", sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[5], ", ", sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[5], ", ", sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[3], ", ", sets[3], ", ", sets[2], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[3], ", ", sets[2], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[2], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[2], ", ", sets[2], ", ", sets[2], ", ", sets[2], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[1], ", ", sets[1], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
        } else if (nPacks == 9 && sets.length >= 9) {
            setCombos.add(TextUtil.concatNoSpace(sets[8], ", ", sets[7], ", ", sets[6], ", ", sets[5], ", ", sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[7], ", ", sets[6], ", ", sets[5], ", ", sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[6], ", ", sets[5], ", ", sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[6], ", ", sets[5], ", ", sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[4], ", ", sets[3], ", ", sets[3], ", ", sets[2], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[3], ", ", sets[3], ", ", sets[2], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[3], ", ", sets[2], ", ", sets[2], ", ", sets[1], ", ", sets[1], ", ", sets[1], ", ", sets[0], ", ", sets[0], ", ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[3], ", ", sets[2], ", 2 ", sets[1], ", 5 ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace("3 ", sets[2], ", 3 ", sets[1], ", 3 ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace("2 ", sets[2], ", 2 ", sets[1], ", 5 ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace(sets[2], ", ", sets[1], ", 7 ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace("4 ", sets[2], ", 5 ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace("4 ", sets[1], ", 5 ", sets[0]));
            setCombos.add(TextUtil.concatNoSpace("9 ", sets[0]));
        } else {
            if (sets.length == 1 || !sets[0].equals(sets[1])) {
                setCombos.add(TextUtil.concatNoSpace("6 ", sets[0]));
            }
            if (sets.length >= 2 && !sets[0].equals(sets[1])) {
                setCombos.add(TextUtil.concatNoSpace("4 ", sets[0], ", 2 ", sets[1]));
                setCombos.add(TextUtil.concatNoSpace("3 ", sets[0], ", 3 ", sets[1]));
                setCombos.add(TextUtil.concatNoSpace("2 ", sets[0], ", 4 ", sets[1]));
            }
            if (sets.length >= 3 && !sets[0].equals(sets[2])) {
                setCombos.add(TextUtil.concatNoSpace("3 ", sets[0], ", 3 ", sets[2]));
                setCombos.add(TextUtil.concatNoSpace("2 ", sets[0], ", 2 ", sets[1], ", 2 ", sets[2]));
            }
            if (sets.length >= 4) {
                if (sets[1].equals(sets[2]) && sets[1].equals(sets[0])) {
                    setCombos.add(TextUtil.concatNoSpace(sets[3], ", 5 ", sets[0]));
                } else {
                    setCombos.add(TextUtil.concatNoSpace(sets[3], ", ", sets[2], ", ", sets[1], ", 3 ", sets[0]));
                    setCombos.add(TextUtil.concatNoSpace(sets[3], ", ", sets[2], ", 2 ", sets[1], ", 2 ", sets[0]));
                }
            }
            if (sets.length >= 5) {
                setCombos.add(TextUtil.concatNoSpace(sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", 2 ", sets[0]));
            }
            if (sets.length >= 6) {
                setCombos.add(TextUtil.concatNoSpace(sets[5], ", ", sets[4], ", ", sets[3], ", ", sets[2], ", ", sets[1], ", ", sets[0]));
            }
        }
        return setCombos;
    }

    public CardPool getCardPool(boolean isHuman) {
        CardPool pool = new CardPool();
        for (IUnOpenedProduct prod : this.product) {
            if (prod instanceof UnOpenedMeta) {
                List<PaperCard> cards = ((UnOpenedMeta)prod).open(isHuman, true);
                if (cards == null) {
                    return null;
                }
                pool.addAllFlat(cards);
                continue;
            }
            pool.addAllFlat(prod.get());
        }
        return pool;
    }

    public String getLandSetCode() {
        return this.landSetCode;
    }

    public boolean isEmpty() {
        return this.product.isEmpty();
    }
}

