/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import forge.localinstance.properties.ForgeConstants;
import forge.util.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ReadDraftRankings {
    private static final String COMMENT = "//";
    private final Map<String, Map<String, Integer>> draftRankings;
    private final Map<String, Integer> setSizes = new HashMap<String, Integer>();

    public ReadDraftRankings() {
        this.draftRankings = this.readRankingFolder();
    }

    public ReadDraftRankings(String customFile) {
        this.draftRankings = this.readFile(FileUtil.readFile(ForgeConstants.DRAFT_DIR + customFile));
    }

    private Map<String, Map<String, Integer>> readRankingFolder() {
        HashMap<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
        File rankingDirectory = new File(ForgeConstants.DRAFT_RANKINGS_FOLDER);
        if (!rankingDirectory.isDirectory()) {
            System.out.println(rankingDirectory + " is not a directory...");
            return null;
        }
        for (File rank : rankingDirectory.listFiles()) {
            if (rank.isDirectory()) continue;
            this.readFile(FileUtil.readFile(rank), map);
        }
        return map;
    }

    private Map<String, Map<String, Integer>> readFile(List<String> lines) {
        HashMap<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
        return this.readFile(lines, map);
    }

    private Map<String, Map<String, Integer>> readFile(List<String> lines, Map<String, Map<String, Integer>> map) {
        for (String line : lines) {
            if (line == null || line.length() == 0) break;
            if (line.startsWith(COMMENT)) continue;
            String[] s2 = line.split("\\|");
            String rankStr = s2[0].trim().substring(1);
            String name = StringUtils.stripAccents(s2[1].trim());
            String edition = s2[3].trim();
            try {
                int rank = Integer.parseInt(rankStr);
                if (!map.containsKey(edition)) {
                    map.put(edition, new HashMap());
                }
                map.get(edition).put(name, rank);
                if (this.setSizes.containsKey(edition)) {
                    this.setSizes.put(edition, Math.max(this.setSizes.get(edition), rank));
                    continue;
                }
                this.setSizes.put(edition, rank);
            }
            catch (NumberFormatException nfe) {
                System.err.println("NumberFormatException: " + nfe.getMessage());
            }
        }
        return map;
    }

    public Double getRanking(String cardName, String edition) {
        Double rank = null;
        if (this.draftRankings.containsKey(edition)) {
            String safeName = StringUtils.stripAccents(cardName);
            safeName = safeName.replace(" // ", " ");
            if (this.draftRankings.get(edition).get(safeName) == null) {
                return null;
            }
            rank = (double)this.draftRankings.get(edition).get(safeName).intValue() / (double)this.setSizes.get(edition).intValue();
        }
        return rank;
    }
}

