/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import forge.game.GameView;
import forge.gamemodes.limited.GauntletMini;
import forge.gui.interfaces.IButton;
import forge.gui.interfaces.IWinLoseView;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.util.Localizer;

public abstract class LimitedWinLoseController {
    private final Localizer localizer = Localizer.getInstance();
    private final IWinLoseView<? extends IButton> view;
    private final GameView lastGame;
    private final boolean wonMatch;
    private GauntletMini gauntlet;
    private boolean nextRound = false;

    public LimitedWinLoseController(IWinLoseView<? extends IButton> view0, GameView game0) {
        this.view = view0;
        this.lastGame = game0;
        this.gauntlet = FModel.getGauntletMini();
        this.wonMatch = this.lastGame.isMatchWonBy(GamePlayerUtil.getGuiPlayer());
    }

    public void showOutcome() {
        this.resetView();
        this.nextRound = false;
        if (this.lastGame.isWinner(GamePlayerUtil.getGuiPlayer())) {
            this.gauntlet.addWin();
        } else {
            this.gauntlet.addLoss();
        }
        this.view.getBtnRestart().setText(this.localizer.getMessage("btnRestartRound", new Object[0]));
        this.showOutcome(() -> {
            if (!this.lastGame.isMatchOver()) {
                this.showTournamentInfo(this.localizer.getMessage("btnTournamentInfo", new Object[0]));
                return;
            }
            if (this.wonMatch) {
                if (this.gauntlet.getCurrentRound() < this.gauntlet.getRounds()) {
                    this.view.getBtnContinue().setText(this.localizer.getMessage("btnNextRound", new Object[0]) + " (" + (this.gauntlet.getCurrentRound() + 1) + "/" + this.gauntlet.getRounds() + ")");
                    this.nextRound = true;
                    this.view.getBtnContinue().setEnabled(true);
                    this.showTournamentInfo(this.localizer.getMessage("btnWonRound", new Object[0]) + this.gauntlet.getCurrentRound() + "/" + this.gauntlet.getRounds());
                } else {
                    this.showTournamentInfo(this.localizer.getMessage("btnWonTournament", new Object[0]));
                }
            } else {
                this.view.getBtnContinue().setVisible(false);
                this.showTournamentInfo(this.localizer.getMessage("btnLoseRound", new Object[0]) + this.gauntlet.getCurrentRound() + "/" + this.gauntlet.getRounds());
            }
        });
    }

    public final boolean actionOnContinue() {
        this.resetView();
        if (this.nextRound) {
            this.view.hide();
            this.saveOptions();
            this.gauntlet.nextRound();
            return true;
        }
        return false;
    }

    public final void actionOnRestart() {
        this.resetView();
    }

    public final void actionOnQuit() {
        this.resetView();
        this.gauntlet.resetCurrentRound();
    }

    private void showTournamentInfo(String newTitle) {
        this.showMessage("Round: " + this.gauntlet.getCurrentRound() + "/" + this.gauntlet.getRounds(), newTitle);
    }

    private void resetView() {
        this.view.getBtnQuit().setText(this.localizer.getMessage("btnQuit", new Object[0]));
        this.view.getBtnContinue().setText(this.localizer.getMessage("btnContinue", new Object[0]));
        this.view.getBtnRestart().setText(this.localizer.getMessage("btnRestart", new Object[0]));
    }

    protected abstract void showOutcome(Runnable var1);

    protected abstract void showMessage(String var1, String var2);

    protected abstract void saveOptions();
}

