/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import forge.util.Localizer;

public enum LimitedPoolType {
    Full(Localizer.getInstance().getMessage("lblLimitedPoolFull", new Object[0])),
    Block(Localizer.getInstance().getMessage("lblLimitedBlock", new Object[0])),
    Prerelease(Localizer.getInstance().getMessage("lblLimitedPrerelease", new Object[0]), false),
    FantasyBlock(Localizer.getInstance().getMessage("lblLimitedFantasy", new Object[0])),
    Custom(Localizer.getInstance().getMessage("lblLimitedCustom", new Object[0])),
    Chaos(Localizer.getInstance().getMessage("lblLimitedChaos", new Object[0]));

    private final String displayName;
    private final boolean draftable;

    private LimitedPoolType(String name) {
        this(name, true);
    }

    private LimitedPoolType(String name, boolean draftable) {
        this.draftable = draftable;
        this.displayName = name;
    }

    public static LimitedPoolType[] values(boolean draftable) {
        if (!draftable) {
            return LimitedPoolType.values();
        }
        int n = 0;
        for (LimitedPoolType lpt : LimitedPoolType.values()) {
            if (!lpt.draftable) continue;
            ++n;
        }
        LimitedPoolType[] draftableFormats = new LimitedPoolType[n];
        n = 0;
        for (LimitedPoolType lpt : LimitedPoolType.values()) {
            if (!lpt.draftable) continue;
            draftableFormats[n] = lpt;
            ++n;
        }
        return draftableFormats;
    }

    public String toString() {
        return this.displayName;
    }
}

