/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.card.CardEdition;
import forge.card.ColorSet;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.deck.generation.DeckGeneratorBase;
import forge.gamemodes.limited.BoosterDeckBuilder;
import forge.gamemodes.limited.BoosterDraft;
import forge.gamemodes.limited.CardRanker;
import forge.gamemodes.limited.DeckColors;
import forge.gamemodes.limited.DraftPack;
import forge.gamemodes.limited.LimitedPlayer;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import forge.util.MyRandom;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class LimitedPlayerAI
extends LimitedPlayer {
    protected DeckColors deckCols = new DeckColors();

    public LimitedPlayerAI(int seatingOrder, BoosterDraft draft) {
        super(seatingOrder, draft);
    }

    @Override
    public PaperCard chooseCard() {
        PaperCard bestPick;
        if (this.packQueue.isEmpty()) {
            return null;
        }
        DraftPack chooseFrom = (DraftPack)this.packQueue.peek();
        if (chooseFrom.isEmpty()) {
            return null;
        }
        CardPool pool = this.deck.getOrCreate(DeckSection.Sideboard);
        if (ForgePreferences.DEV_MODE) {
            System.out.println("Player[" + this.order + "] pack: " + chooseFrom);
        }
        if (this.hasArchdemonCurse()) {
            bestPick = this.pickFromArchdemonCurse(chooseFrom);
        } else {
            ColorSet chosenColors = this.deckCols.getChosenColors();
            boolean canAddMoreColors = this.deckCols.canChoseMoreColors();
            List<PaperCard> rankedCards = CardRanker.rankCardsInPack(chooseFrom, pool.toFlatList(), chosenColors, canAddMoreColors);
            bestPick = rankedCards.get(0);
            if (canAddMoreColors) {
                this.deckCols.addColorsOf(bestPick);
            }
        }
        if (ForgePreferences.DEV_MODE) {
            System.out.println("Player[" + this.order + "] picked: " + bestPick);
        }
        return bestPick;
    }

    public Deck buildDeck(String landSetCode) {
        CardPool section = this.deck.getOrCreate(DeckSection.Sideboard);
        return new BoosterDeckBuilder(section.toFlatList(), this.deckCols).buildDeck(landSetCode);
    }

    @Override
    protected String chooseColor(List<String> colors, LimitedPlayer player, String title) {
        if (player.equals(this)) {
            // empty if block
        }
        Collections.shuffle(colors);
        return colors.get(0);
    }

    @Override
    protected String removeWithAny(PaperCard bestPick, List<String> options) {
        Collections.shuffle(options);
        if (options.get(0).equals("Animus of Predation")) {
            if (this.removeWithAnimus(bestPick)) {
                return "Animus of Predation";
            }
        } else if (options.get(0).equals("Cogwork Grinder") && this.removeWithGrinder(bestPick)) {
            return "Cogwork Grinder";
        }
        return null;
    }

    private boolean removeWithAnimus(PaperCard bestPick) {
        return false;
    }

    private boolean removeWithGrinder(PaperCard bestPick) {
        return false;
    }

    private boolean isUsefulCard(PaperCard bestPick) {
        return false;
    }

    @Override
    protected boolean revealWithBanneret(PaperCard bestPick) {
        if (!bestPick.getRules().getType().isCreature()) {
            return false;
        }
        List nobleBanneret = this.getDraftNotes().getOrDefault("Noble Banneret", null);
        return nobleBanneret == null || !nobleBanneret.contains(bestPick.getName());
    }

    @Override
    protected boolean revealWithVanguard(PaperCard bestPick) {
        if (!bestPick.getRules().getType().isCreature()) {
            return false;
        }
        List notedTypes = this.getDraftNotes().getOrDefault("Paliano Vanguard", null);
        Set<String> types = bestPick.getRules().getType().getCreatureTypes();
        if (notedTypes == null || types.isEmpty()) {
            return false;
        }
        return types.containsAll(notedTypes);
    }

    @Override
    protected boolean revealWithSmuggler(PaperCard bestPick) {
        List notedNames = this.getDraftNotes().getOrDefault("Smuggler Captain", null);
        if (!notedNames.isEmpty() && notedNames.contains(bestPick.getName())) {
            return false;
        }
        if (bestPick.getRules().getType().isConspiracy()) {
            return false;
        }
        if (this.currentPack == 3) {
            return true;
        }
        return this.draftedThisRound < 3;
    }

    @Override
    public boolean handleWhispergearSneak() {
        if (this.draft.getRound() == 3) {
            DraftPack cards = this.peekAtBoosterPack(this.order, 1);
        } else {
            DraftPack cards = this.peekAtBoosterPack(this.order, this.draft.getRound() + 1);
        }
        return true;
    }

    @Override
    public boolean handleIllusionaryInformant() {
        int player;
        while ((player = MyRandom.getRandom().nextInt(this.draft.getOpposingPlayers().length + 1)) == this.order) {
        }
        LimitedPlayer peekAt = this.draft.getPlayer(player);
        return peekAt != null;
    }

    @Override
    public PaperCard handleSpirePhantasm(DraftPack chooseFrom) {
        if (chooseFrom.isEmpty()) {
            return null;
        }
        return CardRanker.getOrderedRawScores(chooseFrom).get(0);
    }

    @Override
    public boolean handleLeovoldsOperative(DraftPack pack, PaperCard drafted) {
        if (this.currentPack == 3) {
            return true;
        }
        return this.draftedThisRound < 3;
    }

    @Override
    public boolean handleAgentOfAcquisitions(DraftPack pack, PaperCard drafted) {
        if (this.currentPack == 3) {
            return true;
        }
        return this.draftedThisRound > 2 && this.draftedThisRound < 6;
    }

    @Override
    public boolean handleCogworkLibrarian(DraftPack pack, PaperCard drafted) {
        if (this.currentPack == 3) {
            return true;
        }
        return this.draftedThisRound < 3;
    }

    @Override
    protected CardEdition chooseEdition(List<CardEdition> possibleEditions) {
        Collections.shuffle(possibleEditions);
        return possibleEditions.get(0);
    }

    @Override
    protected PaperCard chooseExchangeCard(PaperCard offer) {
        ColorSet colors = this.deckCols.getChosenColors();
        List deckCards = this.deck.getOrCreate(DeckSection.Sideboard).toFlatList();
        DeckGeneratorBase.MatchColorIdentity hasColor = new DeckGeneratorBase.MatchColorIdentity(colors);
        Iterable<PaperCard> colorList = Iterables.filter(deckCards, Predicates.not(Predicates.compose(hasColor, PaperCard::getRules)));
        PaperCard exchangeCard = null;
        if (offer == null) {
            List<PaperCard> rankedColorList = CardRanker.rankCardsInDeck(colorList);
            return rankedColorList.get(0);
        }
        List<Pair<Double, PaperCard>> rankedColorList = CardRanker.getScores(colorList);
        double score = CardRanker.getRawScore(offer);
        double closestScore = Double.POSITIVE_INFINITY;
        for (Pair<Double, PaperCard> pair : rankedColorList) {
            double diff = Math.abs(pair.getLeft() - score);
            if (!(diff < closestScore)) continue;
            closestScore = diff;
            exchangeCard = pair.getRight();
        }
        return exchangeCard;
    }

    @Override
    protected PaperCard chooseCardToExchange(PaperCard exchangeCard, Map<PaperCard, LimitedPlayer> offers) {
        double score = CardRanker.getRawScore(exchangeCard);
        List<Pair<Double, PaperCard>> rankedColorList = CardRanker.getScores(offers.keySet());
        ColorSet colors = this.deckCols.getChosenColors();
        for (Pair<Double, PaperCard> pair : rankedColorList) {
            ColorSet cardColors = pair.getRight().getRules().getColorIdentity();
            if (!cardColors.hasNoColorsExcept(colors)) continue;
            if (score < pair.getLeft()) {
                return pair.getRight();
            }
            double threshold = Math.abs(pair.getLeft() - score) / pair.getLeft();
            if (!(threshold < 0.1)) continue;
            return pair.getRight();
        }
        return null;
    }
}

