/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import forge.deck.Deck;
import forge.game.GameType;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.match.HostedMatch;
import forge.gui.GuiBase;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.util.Aggregates;
import java.util.ArrayList;
import java.util.List;

public class GauntletMini {
    private HostedMatch hostedMatch = null;
    private int rounds;
    private Deck humanDeck;
    private int currentRound = 1;
    private int wins = 0;
    private int losses = 0;
    private boolean gauntletDraft = false;
    private GameType gauntletType;
    private final List<RegisteredPlayer> aiOpponents = new ArrayList<RegisteredPlayer>();

    public GauntletMini() {
        this.gauntletType = GameType.Sealed;
    }

    public void resetCurrentRound() {
        this.wins = 0;
        this.losses = 0;
        this.currentRound = 1;
    }

    public void nextRound() {
        System.out.println("Moving from round " + this.currentRound + " to round " + (this.currentRound + 1) + " of " + this.rounds);
        if (this.hostedMatch == null) {
            throw new IllegalStateException("Cannot advance round when no match has been hosted.");
        }
        if (this.currentRound >= this.rounds) {
            this.currentRound = this.rounds - 1;
            return;
        }
        ++this.currentRound;
        this.hostedMatch.endCurrentGame();
        this.startRound();
    }

    public void launch(int rounds0, Deck humanDeck0, GameType gauntletType0) {
        List<Deck> aiDecks;
        this.rounds = rounds0;
        this.humanDeck = humanDeck0;
        this.gauntletType = gauntletType0;
        if (this.gauntletType == GameType.Sealed) {
            aiDecks = FModel.getDecks().getSealed().get(this.humanDeck.getName()).getAiDecks();
        } else if (this.gauntletType == GameType.Draft) {
            this.gauntletDraft = true;
            aiDecks = FModel.getDecks().getDraft().get(this.humanDeck.getName()).getAiDecks();
        } else {
            throw new IllegalStateException("Cannot launch Gauntlet, game mode not implemented.");
        }
        this.aiOpponents.clear();
        if (this.rounds == 1) {
            this.aiOpponents.add(new RegisteredPlayer(aiDecks.get(Aggregates.randomInt(0, aiDecks.size() - 1))));
        } else {
            if (this.rounds > aiDecks.size()) {
                this.rounds = aiDecks.size();
            }
            for (int i = 0; i < this.rounds; ++i) {
                this.aiOpponents.add(new RegisteredPlayer(aiDecks.get(i)));
            }
        }
        this.resetCurrentRound();
        this.startRound();
    }

    private void startRound() {
        ArrayList<RegisteredPlayer> starter = new ArrayList<RegisteredPlayer>();
        RegisteredPlayer human = new RegisteredPlayer(this.humanDeck).setPlayer(GamePlayerUtil.getGuiPlayer());
        starter.add(human);
        starter.add(this.aiOpponents.get(this.currentRound - 1).setPlayer(GamePlayerUtil.createAiPlayer()));
        this.hostedMatch = GuiBase.getInterface().hostMatch();
        this.hostedMatch.startMatch(this.gauntletType, null, starter, human, GuiBase.getInterface().getNewGuiGame());
    }

    public final int getRounds() {
        return this.rounds;
    }

    public final int getCurrentRound() {
        return this.currentRound;
    }

    public void addWin() {
        ++this.wins;
    }

    public void addLoss() {
        ++this.losses;
    }

    public final int getWins() {
        return this.wins;
    }

    public final int getLosses() {
        return this.losses;
    }

    public void resetGauntletDraft() {
        this.gauntletDraft = false;
    }

    public final boolean isGauntletDraft() {
        return this.gauntletDraft;
    }
}

