/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import forge.card.CardEdition;
import forge.deck.Deck;
import forge.deck.DeckBase;
import forge.item.PaperCard;
import forge.item.SealedTemplate;
import forge.model.FModel;
import forge.util.FileSection;
import forge.util.ItemPool;
import forge.util.TextUtil;
import forge.util.storage.IStorage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class CustomLimited
extends DeckBase {
    private final SealedTemplate tpl;
    private static final long serialVersionUID = 7435640939026612173L;
    private int numPacks = 3;
    private transient ItemPool<PaperCard> cardPool;
    private String landSetCode = null;
    private boolean singleton;
    private String customRankingsFile = "";

    public CustomLimited(String name0, List<Pair<String, Integer>> slots) {
        super(name0);
        CardEdition edition = CardEdition.Predicates.getRandomSetWithAllBasicLands(FModel.getMagicDb().getEditions());
        if (edition != null) {
            this.landSetCode = edition.getCode();
        }
        this.tpl = new SealedTemplate(slots);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getItemType() {
        return "Limited deck";
    }

    public static CustomLimited parse(List<String> dfData, IStorage<Deck> cubes) {
        FileSection data = FileSection.parse(dfData, FileSection.COLON_KV_SEPARATOR);
        ArrayList<Pair<String, Integer>> slots = new ArrayList();
        String boosterData = data.get("Booster");
        if (StringUtils.isNotEmpty(boosterData)) {
            String[] booster;
            for (String slotDesc : booster = TextUtil.splitWithParenthesis(boosterData, ',')) {
                String[] kv = TextUtil.splitWithParenthesis(slotDesc, ' ', 2);
                slots.add(ImmutablePair.of(kv[1], Integer.parseInt(kv[0])));
            }
        } else {
            slots = SealedTemplate.genericDraftBooster.getSlots();
        }
        CustomLimited cd2 = new CustomLimited(data.get("Name"), slots);
        cd2.landSetCode = data.get("LandSetCode");
        cd2.numPacks = data.getInt("NumPacks");
        cd2.singleton = data.getBoolean("Singleton");
        cd2.customRankingsFile = data.get("CustomRankings", "rankings_cubecobra.txt");
        Deck deckCube = cubes.get(data.get("DeckFile"));
        cd2.cardPool = deckCube == null ? ItemPool.createFrom(FModel.getMagicDb().getCommonCards().getUniqueCards(), PaperCard.class) : deckCube.getMain();
        return cd2;
    }

    public int getNumPacks() {
        return this.numPacks;
    }

    public void setNumPacks(int numPacksIn) {
        this.numPacks = numPacksIn;
    }

    public String getLandSetCode() {
        return this.landSetCode;
    }

    public ItemPool<PaperCard> getCardPool() {
        return this.cardPool;
    }

    @Override
    protected DeckBase newInstance(String name0) {
        return new CustomLimited(name0, this.tpl.getSlots());
    }

    public SealedTemplate getSealedProductTemplate() {
        return this.tpl;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public String getCustomRankingsFileName() {
        return this.customRankingsFile;
    }

    @Override
    public boolean isEmpty() {
        return this.cardPool.isEmpty();
    }

    @Override
    public String getImageKey(boolean altState) {
        return null;
    }

    @Override
    public Deck getHumanDeck() {
        return null;
    }
}

