/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.collect.ListMultimap;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import forge.util.collect.FCollection;
import java.util.Collection;
import java.util.Map;

public class TriggerVote
extends Trigger {
    public TriggerVote(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        return true;
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        FCollection<Player> oppVotedDiff = TriggerVote.getVoters(this.getHostCard().getController(), (ListMultimap)runParams.get((Object)AbilityKey.AllVotes), true, true);
        sa.setTriggeringObject(AbilityKey.OpponentVotedDiff, oppVotedDiff);
        FCollection<Player> oppVotedSame = TriggerVote.getVoters(this.getHostCard().getController(), (ListMultimap)runParams.get((Object)AbilityKey.AllVotes), true, false);
        sa.setTriggeringObject(AbilityKey.OpponentVotedSame, oppVotedSame);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        if (this.hasParam("List")) {
            String l = this.getParam("List");
            if (l.contains("OppVotedSame")) {
                String ovs = sa.getTriggeringObject(AbilityKey.OpponentVotedSame).toString();
                sb.append(Localizer.getInstance().getMessage("lblOppVotedSame", new Object[0])).append(": ");
                sb.append(!ovs.equals("[]") ? ovs.substring(1, ovs.length() - 1) : Localizer.getInstance().getMessage("lblNone", new Object[0]));
            }
            if (l.contains("OppVotedDiff")) {
                if (sb.length() > 0) {
                    sb.append("] [");
                }
                String ovd = sa.getTriggeringObject(AbilityKey.OpponentVotedDiff).toString();
                sb.append(Localizer.getInstance().getMessage("lblOppVotedDiff", new Object[0])).append(": ");
                sb.append(!ovd.equals("[]") ? ovd.substring(1, ovd.length() - 1) : Localizer.getInstance().getMessage("lblNone", new Object[0]));
            }
        }
        return sb.toString();
    }

    private static FCollection<Player> getVoters(Player player, ListMultimap<Object, Player> votes, boolean isOpponent, boolean votedOtherchoice) {
        FCollection<Player> voters = new FCollection<Player>();
        for (Object voteType : votes.keySet()) {
            Collection players = votes.get(voteType);
            if (!(votedOtherchoice ^ players.contains(player))) continue;
            voters.addAll(players);
        }
        if (isOpponent) {
            voters.retainAll(player.getOpponents());
        }
        return voters;
    }
}

