/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardState;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerUnlockDoor
extends Trigger {
    public TriggerUnlockDoor(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public boolean performTest(Map<AbilityKey, Object> runParams) {
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Card))) {
            return false;
        }
        if (!this.matchesValidParam("ValidPlayer", runParams.get((Object)AbilityKey.Player))) {
            return false;
        }
        if (this.hasParam("ThisDoor")) {
            CardState state = (CardState)runParams.get((Object)AbilityKey.CardState);
            if (!this.getHostCard().equals(state.getCard())) {
                return false;
            }
            if (!this.getCardStateName().equals((Object)state.getStateName())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Card, AbilityKey.Player);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblPlayer", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Player));
        sb.append(", ").append(Localizer.getInstance().getMessage("lblCard", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Card));
        return sb.toString();
    }
}

