/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.collect.Sets;
import forge.card.ColorSet;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardUtil;
import forge.game.cost.Cost;
import forge.game.mana.Mana;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.spellability.TargetChoices;
import forge.game.trigger.Trigger;
import forge.util.Expressions;
import forge.util.Localizer;
import forge.util.collect.FCollection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TriggerSpellAbilityCastOrCopy
extends Trigger {
    public TriggerSpellAbilityCastOrCopy(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        int numX;
        Cost cost;
        SpellAbility spellAbility = (SpellAbility)runParams.get((Object)AbilityKey.SpellAbility);
        if (spellAbility == null) {
            System.out.println("TriggerSpellAbilityCast performTest encountered spellAbility == null. runParams2 = " + runParams);
            return false;
        }
        Card cast = spellAbility.getHostCard();
        Game game = cast.getGame();
        SpellAbilityStackInstance si = game.getStack().getInstanceMatchingSpellAbilityID(spellAbility);
        if (!this.matchesValidParam("ValidPlayer", runParams.get((Object)AbilityKey.Player))) {
            return false;
        }
        if (this.hasParam("ValidActivatingPlayer")) {
            Object valid;
            String compare;
            Player activator;
            if (spellAbility.isManaAbility()) {
                activator = (Player)runParams.get((Object)AbilityKey.Activator);
            } else {
                if (si == null) {
                    return false;
                }
                activator = si.getSpellAbility().getActivatingPlayer();
            }
            if (!this.matchesValidParam("ValidActivatingPlayer", activator)) {
                return false;
            }
            if (this.hasParam("ActivatorThisTurnCast")) {
                int right;
                compare = this.getParam("ActivatorThisTurnCast");
                valid = this.getParamOrDefault("ValidCard", "Card");
                List<Card> thisTurnCast = CardUtil.getThisTurnCast((String)valid, this.getHostCard(), this, this.getHostCard().getController());
                int left = (thisTurnCast = CardLists.filterControlledByAsList(thisTurnCast, activator)).size();
                if (!Expressions.compare(left, compare, right = Integer.parseInt(compare.substring(2)))) {
                    return false;
                }
            }
            if (this.hasParam("ActivatorThisTurnCastEach")) {
                compare = this.getParam("ActivatorThisTurnCastEach");
                valid = this.getParamOrDefault("ValidCard", "Card");
                boolean found = false;
                int right = Integer.parseInt(compare.substring(2));
                for (String v : ((String)valid).split(",")) {
                    if (!cast.isValid(v, this.getHostCard().getController(), this.getHostCard(), (CardTraitBase)this)) continue;
                    List<Card> thisTurnCast = CardUtil.getThisTurnCast(v, this.getHostCard(), this, this.getHostCard().getController());
                    int left = (thisTurnCast = CardLists.filterControlledByAsList(thisTurnCast, activator)).size();
                    if (!Expressions.compare(left, compare, right)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
        }
        if (!this.matchesValidParam("ValidCard", cast)) {
            return false;
        }
        if (!this.matchesValidParam("ValidSA", spellAbility)) {
            return false;
        }
        if (!this.matchesValidParam("ValidSAonCard", spellAbility, cast)) {
            return false;
        }
        if (this.hasParam("TargetsValid")) {
            SpellAbility sa = spellAbility;
            if (si != null) {
                sa = si.getSpellAbility();
            }
            boolean validTgtFound = false;
            while (sa != null && !validTgtFound) {
                for (GameEntity ge : sa.getTargets().getTargetEntities()) {
                    if (!this.matchesValidParam("TargetsValid", ge)) continue;
                    validTgtFound = true;
                    break;
                }
                sa = sa.getSubAbility();
            }
            if (!validTgtFound) {
                return false;
            }
        }
        if (this.hasParam("CanTargetOtherCondition")) {
            SpellAbility targetedSA;
            CardCollection candidates = new CardCollection();
            for (targetedSA = spellAbility; !(targetedSA == null || targetedSA.usesTargeting() && targetedSA.getTargets().size() != 0); targetedSA = targetedSA.getSubAbility()) {
            }
            if (targetedSA == null) {
                return false;
            }
            List<GameEntity> candidateTargets = targetedSA.getTargetRestrictions().getAllCandidates(targetedSA, true);
            for (GameEntity card : candidateTargets) {
                if (!(card instanceof Card)) continue;
                candidates.add((Card)card);
            }
            candidates.removeAll(targetedSA.getTargets().getTargetCards());
            String valid = this.getParam("CanTargetOtherCondition");
            if (CardLists.getValidCards((Iterable<Card>)candidates, valid, spellAbility.getActivatingPlayer(), spellAbility.getHostCard(), (CardTraitBase)spellAbility).isEmpty()) {
                return false;
            }
        }
        if (this.hasParam("NonTapCost") && (cost = (Cost)runParams.get((Object)AbilityKey.Cost)).hasTapCost()) {
            return false;
        }
        if (this.hasParam("HasTapCost") && !(cost = (Cost)runParams.get((Object)AbilityKey.Cost)).hasTapCost()) {
            return false;
        }
        if (this.hasParam("HasXManaCost") && (numX = spellAbility.isActivatedAbility() ? (spellAbility.getPayCosts().hasManaCost() ? spellAbility.getPayCosts().getCostMana().getAmountOfX() : 0) : cast.getManaCost().countX()) == 0) {
            return false;
        }
        if (this.hasParam("IsSingleTarget")) {
            HashSet<GameObject> targets = Sets.newHashSet();
            for (TargetChoices tc : spellAbility.getAllTargetChoices()) {
                targets.addAll(tc);
                if (targets.size() <= 1) continue;
                return false;
            }
            if (targets.size() != 1) {
                return false;
            }
        }
        if (this.hasParam("NoColoredMana")) {
            for (Mana m4 : spellAbility.getPayingMana()) {
                if (m4.isColorless()) continue;
                return false;
            }
        }
        if (this.hasParam("SnowSpentForCardsColor")) {
            boolean found = false;
            for (Mana m5 : spellAbility.getPayingMana()) {
                if (!m5.isSnow() || !cast.getColor().sharesColorWith(ColorSet.fromMask(m5.getColor()))) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        SpellAbility castSA = (SpellAbility)runParams.get((Object)AbilityKey.SpellAbility);
        SpellAbilityStackInstance si = sa.getHostCard().getGame().getStack().getInstanceMatchingSpellAbilityID(castSA);
        SpellAbility saForTargets = si != null ? si.getSpellAbility() : castSA;
        sa.setTriggeringObject(AbilityKey.Card, castSA.getHostCard());
        sa.setTriggeringObject(AbilityKey.SpellAbility, castSA);
        sa.setTriggeringObject(AbilityKey.StackInstance, si);
        List<TargetChoices> allTgts = saForTargets.getAllTargetChoices();
        if (!allTgts.isEmpty()) {
            FCollection<GameEntity> saTargets = new FCollection<GameEntity>();
            for (TargetChoices tc : allTgts) {
                saTargets.addAll(tc.getTargetEntities());
            }
            sa.setTriggeringObject(AbilityKey.SpellAbilityTargets, saTargets);
        }
        sa.setTriggeringObject(AbilityKey.LifeAmount, castSA.getAmountLifePaid());
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.CardLKI, AbilityKey.Player, AbilityKey.Activator, AbilityKey.CurrentStormCount, AbilityKey.CurrentCastSpells);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblCard", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Card)).append(", ");
        sb.append(Localizer.getInstance().getMessage("lblActivator", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Activator)).append(", ");
        sb.append(Localizer.getInstance().getMessage("lblSpellAbility", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.SpellAbility));
        return sb.toString();
    }
}

