/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerLifeGained
extends Trigger {
    public TriggerLifeGained(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        SpellAbility spellAbility;
        if (!this.matchesValidParam("ValidPlayer", runParams.get((Object)AbilityKey.Player))) {
            return false;
        }
        if (!this.matchesValidParam("ValidSource", runParams.get((Object)AbilityKey.Source))) {
            return false;
        }
        if (this.hasParam("FirstTime") && !((Boolean)runParams.get((Object)AbilityKey.FirstTime)).booleanValue()) {
            return false;
        }
        return !this.hasParam("Spell") || (spellAbility = (SpellAbility)runParams.get((Object)AbilityKey.SourceSA)) != null && spellAbility.getRootAbility().isSpell();
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.LifeAmount, AbilityKey.Player);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblPlayer", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Player)).append(", ");
        sb.append(Localizer.getInstance().getMessage("lblGainedAmount", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.LifeAmount));
        return sb.toString();
    }
}

