/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCopyService;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Expressions;
import forge.util.Localizer;
import java.util.Iterator;
import java.util.Map;

public class TriggerDamageDoneOnce
extends Trigger {
    public TriggerDamageDoneOnce(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public boolean performTest(Map<AbilityKey, Object> runParams) {
        int operand;
        String fullParam;
        String operator;
        if (this.hasParam("CombatDamage") && this.getParam("CombatDamage").equals("True") != ((Boolean)runParams.get((Object)AbilityKey.IsCombatDamage)).booleanValue()) {
            return false;
        }
        if (!this.matchesValidParam("ValidTarget", runParams.get((Object)AbilityKey.DamageTarget))) {
            return false;
        }
        int damageAmount = this.getDamageAmount((Map)runParams.get((Object)AbilityKey.DamageMap));
        if (this.hasParam("ValidSource") && damageAmount <= 0) {
            return false;
        }
        return !this.hasParam("DamageAmount") || Expressions.compare(damageAmount, operator = (fullParam = this.getParam("DamageAmount")).substring(0, 2), operand = Integer.parseInt(fullParam.substring(2)));
    }

    @Override
    public void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        Map damageMap = (Map)runParams.get((Object)AbilityKey.DamageMap);
        Object target = runParams.get((Object)AbilityKey.DamageTarget);
        if (target instanceof Card) {
            target = CardCopyService.getLKICopy((Card)runParams.get((Object)AbilityKey.DamageTarget));
        }
        sa.setTriggeringObject(AbilityKey.Target, target);
        sa.setTriggeringObject(AbilityKey.Sources, this.getDamageSources(damageMap));
        Iterator iterator = damageMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            sa.setTriggeringObject(AbilityKey.AttackingPlayer, ((Card)entry.getKey()).getController());
        }
        sa.setTriggeringObject(AbilityKey.DamageAmount, this.getDamageAmount(damageMap));
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        if (sa.getTriggeringObject(AbilityKey.Target) != null) {
            sb.append(Localizer.getInstance().getMessage("lblDamaged", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Target)).append(", ");
        }
        sb.append(Localizer.getInstance().getMessage("lblAmount", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.DamageAmount));
        return sb.toString();
    }

    public int getDamageAmount(Map<Card, Integer> damageMap) {
        int result = 0;
        for (Map.Entry<Card, Integer> e : damageMap.entrySet()) {
            if (!this.matchesValidParam("ValidSource", e.getKey())) continue;
            result += e.getValue().intValue();
        }
        return result;
    }

    public CardCollection getDamageSources(Map<Card, Integer> damageMap) {
        if (!this.hasParam("ValidSource")) {
            return new CardCollection((Iterable<Card>)damageMap.keySet());
        }
        CardCollection result = new CardCollection();
        for (Card c : damageMap.keySet()) {
            if (!this.matchesValidParam("ValidSource", c)) continue;
            result.add(c);
        }
        return result;
    }
}

