/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.game.zone.ZoneType;
import forge.util.Expressions;
import forge.util.Localizer;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class TriggerChangesZone
extends Trigger {
    public TriggerChangesZone(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
        this.correctZones();
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        SpellAbility cause;
        CardCollectionView lastState;
        if (this.hasParam("Origin") && !this.getParam("Origin").equals("Any")) {
            if (this.getParam("Origin") == null) {
                return false;
            }
            if (!ArrayUtils.contains(this.getParam("Origin").split(","), runParams.get((Object)AbilityKey.Origin))) {
                return false;
            }
        }
        if (this.hasParam("Destination") && !this.getParam("Destination").equals("Any") && !ArrayUtils.contains(this.getParam("Destination").split(","), runParams.get((Object)AbilityKey.Destination))) {
            return false;
        }
        if (this.hasParam("ExcludedDestinations") && ArrayUtils.contains(this.getParam("ExcludedDestinations").split(","), runParams.get((Object)AbilityKey.Destination))) {
            return false;
        }
        if ("Battlefield".equals(this.getParam("Origin")) && this.getActiveZone() != null && this.getActiveZone().contains((Object)ZoneType.Graveyard) && !(lastState = (CardCollectionView)runParams.get((Object)AbilityKey.LastStateGraveyard)).contains(this.getHostCard())) {
            return false;
        }
        if (this.hasParam("ValidCard")) {
            Card moved = (Card)runParams.get((Object)AbilityKey.Card);
            if ("Battlefield".equals(this.getParam("Origin")) || "Graveyard".equals(this.getParam("Origin")) && !"Battlefield".equals(this.getParam("Destination"))) {
                moved = (Card)runParams.get((Object)AbilityKey.CardLKI);
            } else if ("Battlefield".equals(runParams.get((Object)AbilityKey.Destination))) {
                List<Card> etbLKI = moved.getController().getZone(ZoneType.Battlefield).getCardsAddedThisTurn(null);
                etbLKI.sort(CardPredicates.compareByGameTimestamp());
                moved = etbLKI.get(etbLKI.lastIndexOf(moved));
            }
            if (!this.matchesValidParam("ValidCard", moved)) {
                return false;
            }
        }
        if (!this.matchesValidParam("ValidCause", runParams.get((Object)AbilityKey.Cause))) {
            return false;
        }
        if (this.hasParam("Fizzle")) {
            if (!runParams.containsKey((Object)AbilityKey.Fizzle)) {
                return false;
            }
            Boolean val = (Boolean)runParams.get((Object)AbilityKey.Fizzle);
            if ("True".equals(this.getParam("Fizzle")) != val.booleanValue()) {
                return false;
            }
        }
        if (this.hasParam("CheckOnTriggeredCard")) {
            String[] condition = this.getParam("CheckOnTriggeredCard").split(" ", 2);
            Card host = this.hostCard.getGame().getCardState(this.hostCard);
            String comparator = condition.length < 2 ? "GE1" : condition[1];
            int referenceValue = AbilityUtils.calculateAmount(host, comparator.substring(2), this);
            Card triggered = (Card)runParams.get((Object)AbilityKey.Card);
            int actualValue = AbilityUtils.calculateAmount(triggered, condition[0], this);
            if (!Expressions.compare(actualValue, comparator.substring(0, 2), referenceValue)) {
                return false;
            }
        }
        if (this.hasParam("DamageReceivedCondition")) {
            String cond = this.getParam("DamageReceivedCondition");
            if (cond.length() < 3) {
                return false;
            }
            Card card = (Card)runParams.get((Object)AbilityKey.CardLKI);
            int rightSide = AbilityUtils.calculateAmount(this.getHostCard(), cond.substring(2), this);
            boolean expr = Expressions.compare(card.getAssignedDamage(), cond, rightSide);
            if (!expr) {
                return false;
            }
        }
        if (this.hasParam("NotThisAbility") && runParams.containsKey((Object)AbilityKey.Cause) && (cause = (SpellAbility)runParams.get((Object)AbilityKey.Cause)) != null && this.equals(cause.getRootAbility().getTrigger())) {
            return false;
        }
        if (this.hasParam("ConditionYouCastThisTurn")) {
            int right;
            String compare = this.getParam("ConditionYouCastThisTurn");
            List<Card> thisTurnCast = this.getHostCard().getGame().getStack().getSpellsCastThisTurn();
            int left = Iterables.indexOf(thisTurnCast = CardLists.filterControlledByAsList(thisTurnCast, this.getHostCard().getController()), CardPredicates.castSA(Predicates.equalTo(this.getHostCard().getCastSA())));
            if (!Expressions.compare(left + 1, compare, right = Integer.parseInt(compare.substring(2)))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        if ("Battlefield".equals(this.getParam("Origin"))) {
            sa.setTriggeringObject(AbilityKey.Card, runParams.get((Object)AbilityKey.CardLKI));
            sa.setTriggeringObject(AbilityKey.NewCard, runParams.get((Object)AbilityKey.Card));
        } else {
            sa.setTriggeringObjectsFrom(runParams, AbilityKey.Card, AbilityKey.CardLKI);
        }
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblZoneChanger", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Card));
        return sb.toString();
    }

    protected void correctZones() {
        boolean leavesBattlefield;
        if (this.validHostZones != null) {
            return;
        }
        if (this.getHostCard().getGame() == null) {
            return;
        }
        if (!this.hasParam("ValidCard")) {
            return;
        }
        if (this.hasParam("Origin") && (leavesBattlefield = ArrayUtils.contains(this.getParam("Origin").split(","), ZoneType.Battlefield.toString())) && !this.isStatic()) {
            this.setActiveZone(EnumSet.of(ZoneType.Battlefield));
        }
        if (this.getParam("ValidCard").contains("Self") && (!this.hasParam("Origin") || "Any".equals(this.getParam("Origin")))) {
            this.setActiveZone(Sets.newEnumSet(ZoneType.listValueOf(this.getParam("Destination")), ZoneType.class));
        }
    }
}

