/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.collect.Iterables;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardLists;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerAttackerBlocked
extends Trigger {
    public TriggerAttackerBlocked(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        int count;
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Attacker))) {
            return false;
        }
        return !this.hasParam("ValidBlocker") || (count = CardLists.getValidCardCount((Iterable)runParams.get((Object)AbilityKey.Blockers), this.getParam("ValidBlocker"), this.getHostCard().getController(), this.getHostCard(), this)) != 0;
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Attacker, AbilityKey.Blockers, AbilityKey.Defender, AbilityKey.DefendingPlayer);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblAttacker", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Attacker)).append(", ");
        sb.append(Localizer.getInstance().getMessage("lblNumberBlockers", new Object[0])).append(": ").append(Iterables.size((Iterable)sa.getTriggeringObject(AbilityKey.Blockers)));
        return sb.toString();
    }
}

