/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class StaticAbilityMustTarget {
    static String MODE = "MustTarget";

    public static boolean filterMustTargetCards(Player targetingPlayer, List<Card> targets, SpellAbility spellAbility) {
        if (targetingPlayer != spellAbility.getHostCard().getController()) {
            return false;
        }
        List<Pair<String, ZoneType>> restrictions = StaticAbilityMustTarget.getAllRestrictions(spellAbility);
        return StaticAbilityMustTarget.applyMustTargetCardAbility(restrictions, targets, spellAbility);
    }

    public static boolean meetsMustTargetRestriction(SpellAbility spellAbility) {
        if (spellAbility.isCopied()) {
            return true;
        }
        Game game = spellAbility.getHostCard().getGame();
        List<Pair<String, ZoneType>> restrictions = StaticAbilityMustTarget.getAllRestrictions(spellAbility);
        if (restrictions.isEmpty()) {
            return true;
        }
        SpellAbility currentAbility = spellAbility;
        boolean usesTargeting = false;
        do {
            if (!currentAbility.usesTargeting() || currentAbility.hasParam("TargetingPlayer")) continue;
            usesTargeting = true;
            TargetRestrictions tgt = currentAbility.getTargetRestrictions();
            List<ZoneType> zone = tgt.getZone();
            CardCollection validCards = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(zone), tgt.getValidTgts(), currentAbility.getActivatingPlayer(), currentAbility.getHostCard(), (CardTraitBase)currentAbility);
            CardCollection choices = CardLists.getTargetableCards(validCards, currentAbility);
            StaticAbilityMustTarget.isRestrictionsMet(restrictions, choices, currentAbility);
        } while ((currentAbility = currentAbility.getSubAbility()) != null);
        return !usesTargeting || restrictions.isEmpty();
    }

    private static List<Pair<String, ZoneType>> getAllRestrictions(SpellAbility spellAbility) {
        Game game = spellAbility.getHostCard().getGame();
        ArrayList<Pair<String, ZoneType>> restrictions = new ArrayList<Pair<String, ZoneType>>();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                Pair<String, ZoneType> newRestriction;
                if (!stAb.checkConditions(MODE) || !stAb.matchesValidParam("ValidSA", spellAbility) || restrictions.contains(newRestriction = Pair.of(stAb.getParam("ValidTarget"), ZoneType.smartValueOf(stAb.getParam("ValidZone"))))) continue;
                restrictions.add(newRestriction);
            }
        }
        return restrictions;
    }

    private static boolean isRestrictionsMet(List<Pair<String, ZoneType>> restrictions, List<Card> targets, SpellAbility spellAbility) {
        for (int i = restrictions.size() - 1; i >= 0; --i) {
            Pair<String, ZoneType> restriction = restrictions.get(i);
            boolean found = false;
            for (Card card : spellAbility.getTargets().getTargetCards()) {
                if (!card.getType().hasStringType(restriction.getLeft()) || !card.isInZone(restriction.getRight())) continue;
                found = true;
                break;
            }
            if (found) {
                restrictions.remove(i);
                continue;
            }
            found = false;
            for (Card card : targets) {
                if (!card.getType().hasStringType(restriction.getLeft()) || !card.isInZone(restriction.getRight())) continue;
                found = true;
                break;
            }
            if (found) continue;
            restrictions.remove(i);
        }
        return restrictions.isEmpty();
    }

    private static boolean applyMustTargetCardAbility(List<Pair<String, ZoneType>> restrictions, List<Card> targets, SpellAbility spellAbility) {
        if (StaticAbilityMustTarget.isRestrictionsMet(restrictions, targets, spellAbility)) {
            return false;
        }
        int maxTargets = spellAbility.getMaxTargets();
        int targeted = spellAbility.getTargets().size();
        if (restrictions.size() > maxTargets - targeted) {
            targets.clear();
            return true;
        }
        boolean filtered = false;
        for (int i = targets.size() - 1; i >= 0; --i) {
            Card card = targets.get(i);
            boolean satisfied = false;
            for (Pair<String, ZoneType> restriction : restrictions) {
                if (!card.getType().hasStringType(restriction.getLeft()) || !card.isInZone(restriction.getRight())) continue;
                satisfied = true;
                break;
            }
            if (satisfied) continue;
            targets.remove(i);
            filtered = true;
        }
        return filtered;
    }
}

